/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileURL;
import org.openide.filesystems.Repository;

final class NbfsUtil {
    private static final char SEPARATOR = '/';
    private static final String SYSTEM_FILE_SYSTEM_NAME = "SystemFileSystem";

    NbfsUtil() {
    }

    static URL getURL(FileObject fo) {
        String fsPart;
        try {
            fsPart = NbfsUtil.encodeFsPart(fo);
        }
        catch (FileStateInvalidException x) {
            fsPart = "invalid";
        }
        String foPart = NbfsUtil.encodeFoPart(fo);
        String host = "nbhost";
        final String file = NbfsUtil.combine(fsPart, foPart);
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws Exception {
                    return new URL("nbfs", "nbhost", -1, file, new FileURL.Handler());
                }
            });
        }
        catch (PrivilegedActionException pae) {
            IllegalStateException ise = new IllegalStateException(pae.toString());
            ExternalUtil.annotate((Throwable)ise, pae);
            throw ise;
        }
    }

    private static String combine(String host, String file) {
        StringBuffer sb = new StringBuffer();
        sb.append('/').append(host);
        sb.append(file);
        return sb.toString();
    }

    private static String[] split(URL url) {
        String file = url.getFile();
        int idx = file.indexOf("/", 1);
        String fsPart = "";
        String foPart = file;
        if (idx > 1) {
            fsPart = file.substring(1, idx);
            foPart = file.substring(idx + 1);
        }
        return new String[]{fsPart, foPart};
    }

    static FileObject getFileObject(URL url) {
        if (!url.getProtocol().equals("nbfs")) {
            return null;
        }
        if (NbfsUtil.isOldEncoding(url)) {
            return NbfsUtil.oldDecode(url);
        }
        String[] urlParts = NbfsUtil.split(url);
        String fsName = NbfsUtil.decodeFsPart(urlParts[0]);
        String foName = NbfsUtil.decodeFoPart(urlParts[1]);
        FileSystem fsys = fsName.equals(SYSTEM_FILE_SYSTEM_NAME) ? Repository.getDefault().getDefaultFileSystem() : Repository.getDefault().findFileSystem(fsName);
        return fsys == null ? null : fsys.findResource(foName);
    }

    private static String encodeFsPart(FileObject fo) throws FileStateInvalidException {
        String n;
        FileSystem fs = fo.getFileSystem();
        assert (fs != null) : "File object " + fo + " returns null from getFileSystem()";
        String string = n = fs.isDefault() ? SYSTEM_FILE_SYSTEM_NAME : fs.getSystemName();
        if (n.isEmpty()) {
            n = String.format("%s.%h", fs.getClass().getName(), fs);
        }
        return NbfsUtil.encoder(n);
    }

    private static String encodeFoPart(FileObject fo) {
        String path = fo.getPath();
        if (fo.isFolder()) {
            path = path + "/";
        }
        if (!fo.isRoot()) {
            path = "/" + path;
        }
        try {
            return new URI(null, path, null).toString();
        }
        catch (URISyntaxException x) {
            return "???";
        }
    }

    private static String decodeFsPart(String encodedStr) {
        return NbfsUtil.decoder(encodedStr);
    }

    private static String decodeFoPart(String encodedStr) {
        if (encodedStr == null) {
            return "";
        }
        if (encodedStr.endsWith("/")) {
            encodedStr = encodedStr.substring(0, encodedStr.length() - 1);
        }
        try {
            return new URI(encodedStr).getPath();
        }
        catch (URISyntaxException x) {
            return "???";
        }
    }

    private static String encoder(String elem) {
        try {
            return URLEncoder.encode(elem, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String decoder(String elem) {
        try {
            return URLDecoder.decode(elem, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static boolean isOldEncoding(URL url) {
        String host = url.getHost();
        return host == null || host.length() == 0;
    }

    private static FileObject oldDecode(URL u) {
        int first;
        String resourceName = u.getFile();
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        if ((first = resourceName.indexOf(47)) == -1) {
            return null;
        }
        String fileSystemName = NbfsUtil.oldDecodeFSName(resourceName.substring(0, first));
        resourceName = resourceName.substring(first);
        FileSystem fsys = Repository.getDefault().findFileSystem(fileSystemName);
        return fsys == null ? null : fsys.findResource(resourceName);
    }

    private static String oldDecodeFSName(String name) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int len = name.length();
        block6: while (i < len) {
            char ch;
            if ((ch = name.charAt(i++)) == 'Q' && i < len) {
                switch (name.charAt(i++)) {
                    case 'B': {
                        sb.append('/');
                        continue block6;
                    }
                    case 'C': {
                        sb.append(':');
                        continue block6;
                    }
                    case 'D': {
                        sb.append('\\');
                        continue block6;
                    }
                    case 'E': {
                        sb.append('#');
                        continue block6;
                    }
                }
                sb.append('Q');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

