/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.power.config.Power;
import org.lsst.ccs.subsystem.power.data.PowerState;
import org.lsst.ccs.subsystem.power.ui.PowerConfigPanel;
import org.lsst.ccs.subsystem.power.ui.PowerStatusPanel;
import org.lsst.ccs.utilities.logging.Logger;

public class PowerControlPanel
extends JPanel
implements PowerStatusPanel.Parent,
CommandSender.ReplyHandler {
    private static final String NB_SPACE = "\u00a0";
    private final JPanel btnPanel = new JPanel();
    private final JButton btCfgPower = new JButton("Configure...");
    private final JButton btCfgSave = new JButton("Save Config");
    private final JButton btPwrOn = new JButton("Turn On");
    private final JButton btPwrOff = new JButton("Turn Off");
    private final JButton btQuit = new JButton("Quit");
    private final JLabel lbMessage = new JLabel("\u00a0");
    private final JPanel mainPanel = new JPanel();
    private static final Logger LOG = Logger.getLogger((String)PowerControlPanel.class.getName());
    private final PowerStatusPanel pwrPanel;
    private final CommandSender sender;
    private static final long serialVersionUID = 1L;

    public PowerControlPanel(String agent, boolean noQuit) {
        this.sender = new CommandSender(agent, (CommandSender.ReplyHandler)this);
        this.pwrPanel = new PowerStatusPanel(this);
        this.initButtonPanel(noQuit);
        this.initMainPanel();
        this.initTopPanel();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, "getFullState", new Object[0]);
    }

    public void updatePanel(PowerState state) {
        SwingUtilities.invokeLater(new UpdatePowerStatus(state));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        if (command.equals("getFullState")) {
            this.updatePanel((PowerState)reply);
        } else if (command.equals("getPowerConfig")) {
            Power[] power = (Power[])reply;
            if (PowerConfigPanel.edit(SwingUtilities.getWindowAncestor(this), power)) {
                this.sender.sendCommand(null, "setPowerConfig", new Object[]{power});
            }
        }
    }

    @Override
    public void powerResized() {
        Component f = this.getTopFrame();
        f.setSize(f.getPreferredSize());
    }

    private void initButtonPanel(boolean noQuit) {
        this.btnPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.btnPanel.add((Component)this.btCfgPower, gbc);
        this.btCfgPower.setFocusable(false);
        this.btCfgPower.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PowerControlPanel.this.sender.sendCommand(true, null, "getPowerConfig", new Object[0]);
            }
        });
        ++gbc.gridy;
        this.btnPanel.add((Component)this.btCfgSave, gbc);
        this.btCfgSave.setFocusable(false);
        this.btCfgSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PowerControlPanel.this.sender.sendCommand(null, "saveNamedConfig", new Object[]{""});
            }
        });
        ++gbc.gridy;
        this.btnPanel.add((Component)this.btPwrOn, gbc);
        this.btPwrOn.setFocusable(false);
        this.btPwrOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PowerControlPanel.this.sender.sendCommand(null, "powerOn", new Object[0]);
            }
        });
        ++gbc.gridy;
        this.btnPanel.add((Component)this.btPwrOff, gbc);
        this.btPwrOff.setFocusable(false);
        this.btPwrOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PowerControlPanel.this.sender.sendCommand(null, "powerOff", new Object[0]);
            }
        });
        if (!noQuit) {
            ++gbc.gridy;
            this.btnPanel.add((Component)this.btQuit, gbc);
            this.btQuit.setFocusable(false);
            this.btQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PowerControlPanel.this.sender.sendCommand(null, "shutdown", new Object[0]);
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            });
        }
    }

    private void initMainPanel() {
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.mainPanel.add((Component)this.pwrPanel, gbc);
        ++gbc.gridx;
        this.mainPanel.add((Component)this.btnPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.anchor = 11;
        this.mainPanel.add((Component)this.lbMessage, gbc);
    }

    private void initTopPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        this.add((Component)this.mainPanel, gbc);
    }

    private Component getTopFrame() {
        Container c = this;
        while (!(c instanceof JFrame || c instanceof JWindow || c instanceof JDialog || c.getParent() == null)) {
            c = c.getParent();
        }
        return c;
    }

    class UpdatePowerStatus
    implements Runnable {
        private final PowerState rs;

        UpdatePowerStatus(PowerState rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            PowerControlPanel.this.btCfgPower.setEnabled(true);
            PowerControlPanel.this.btCfgSave.setEnabled(true);
            PowerControlPanel.this.btPwrOff.setEnabled(true);
            PowerControlPanel.this.btPwrOn.setEnabled(true);
            PowerControlPanel.this.btQuit.setEnabled(true);
            PowerControlPanel.this.pwrPanel.updatePanel(this.rs.getChanState());
            PowerControlPanel.this.repaint();
        }
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            PowerControlPanel.this.btCfgPower.setEnabled(false);
            PowerControlPanel.this.btCfgSave.setEnabled(false);
            PowerControlPanel.this.btPwrOff.setEnabled(false);
            PowerControlPanel.this.btPwrOn.setEnabled(false);
            PowerControlPanel.this.btQuit.setEnabled(false);
            PowerControlPanel.this.pwrPanel.disablePanel();
            PowerControlPanel.this.repaint();
        }
    }
}

