/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.lsst.ccs.CommandHelper;
import org.lsst.ccs.ComponentConfigurationEnvironment;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.LookupInjectUtils;
import org.lsst.ccs.PersistencyService;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.SubstitutionTokenUtils;
import org.lsst.ccs.bus.alerts.InfrastructureAlert;
import org.lsst.ccs.bus.data.AgentAlerts;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandReply;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ClusterDeserializationErrorHandler;
import org.lsst.ccs.messaging.CommandExecutor;
import org.lsst.ccs.messaging.LogBusHandler;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.MessagingService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.utilities.logging.Log4JConfiguration;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.Scheduler;
import org.lsst.ccs.utilities.tracers.Names;

public class Agent
implements CommandExecutor,
ServiceLifecycle {
    private AgentInfo agentInfo;
    private final AtomicBoolean isAlive = new AtomicBoolean(true);
    protected final AtomicBoolean jvmShutdown = new AtomicBoolean(false);
    private static final Logger log;
    private static final java.util.logging.Logger agentLog;
    private static final java.util.logging.Logger generalLogger;
    private static volatile Agent environmentAgent;
    protected LogBusHandler logBusHandler;
    private final Scheduler scheduler;
    protected final Object commandExecutorLock = new Object();
    private final ExecutorService queryExecutor;
    protected final Set<RunningCommand> currentQueries;
    private final ExecutorService actionExecutor;
    protected volatile RunningCommand currentAction;
    private final ExecutorService signalExecutor;
    protected final Set<RunningCommand> currentSignals;
    private final ThreadGroup commandGroup = new ThreadGroup("Command Threads");
    private final ThreadLocal<RunningCommand> currentCommand = new ThreadLocal();
    private final ThreadLocal<CommandHelper> currentCommandHelper = new ThreadLocal();
    private ComponentLookup componentLookupService;
    protected volatile boolean treeComponentInitialized = false;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private AgentPeriodicTaskService agentPeriodicTaskService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private ConfigurationService subsystemConfigurationEnvironment;
    private PersistencyService subsystemPersistencyService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private AgentLockService agentLockService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private MessagingService messagingService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private AgentCommandDictionaryService agentCommandDictionaryService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private AgentPropertiesService agentPropertiesService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private DataProviderDictionaryService dataProviderDictionaryService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final List<AgentService> agentServices = new ArrayList<AgentService>();
    private final Map<Class, AgentService> agentServicesByClass = new HashMap<Class, AgentService>();
    public static final String AGENT_RUNTIMEINFO_TASK = "runtimeInfo";
    public static final String AGENT_DESCRIPTION = "agentDescription";

    public Agent(String name, AgentInfo.AgentType agentType) {
        switch (agentType) {
            case CONSOLE: 
            case LISTENER: {
                name = Names.almostUniqueAgentName((String)name);
                break;
            }
        }
        this.agentInfo = new AgentInfo(name, agentType);
        this.setAgentName(name);
        this.scheduler = new Scheduler("Scheduler for " + name, 15);
        this.scheduler.setLogger(log);
        this.queryExecutor = Executors.newCachedThreadPool(this.createThreadFactory("CommandExecutor (QUERY)"));
        this.currentQueries = ConcurrentHashMap.newKeySet(3);
        this.actionExecutor = Executors.newSingleThreadExecutor(this.createThreadFactory("CommandExecutor (ACTION)"));
        this.signalExecutor = Executors.newCachedThreadPool(this.createThreadFactory("CommandExecutor (SIGNAL)"));
        this.currentSignals = ConcurrentHashMap.newKeySet(3);
        String ccsLaunchScript = this.getCCSLaunchScript();
        if (ccsLaunchScript != null) {
            agentLog.log(Level.INFO, "Launching CCS application: {0}.", new Object[]{ccsLaunchScript});
        }
        agentLog.log(Level.INFO, "Using java version {0} from installtion directory {1}", new Object[]{System.getProperty("java.version"), System.getProperty("java.home")});
    }

    @Override
    public void preInit() {
        ClearAlertHandler agentClearAlertHadler = new ClearAlertHandler(){

            @Override
            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        AlertService alertService = this.getAgentService(AlertService.class);
        alertService.registerAlert(InfrastructureAlert.COMMAND_EXECUTION_FAILURE.getAlert(), agentClearAlertHadler);
        alertService.registerAlert(AgentAlerts.ClusterAlert.getAlert(), agentClearAlertHadler);
        this.stateService.updateInternalState(new AgentState[]{OperationalState.ENGINEERING_OK});
        this.agentPropertiesService.setAgentProperty(AGENT_DESCRIPTION, this.getDescription());
    }

    protected final void populateComponentLookup(ComponentLookup lookup) {
        if (this.treeComponentInitialized) {
            throw new RuntimeException("populateComponentLookup must be called exactly once");
        }
        this.treeComponentInitialized = true;
        this.componentLookupService = lookup;
        SubstitutionTokenUtils.addSubstitutionToken((String)"description", (String)this.getDescription());
        agentLog.log(Level.INFO, "Starting Agent {0} from description {1}.", new Object[]{this.getName(), this.getDescription()});
        ComponentNode agentComponentNode = this.componentLookupService.getTopComponentNode();
        ServiceLoader<AgentService> agentServiceLoader = ServiceLoader.load(AgentService.class);
        for (AgentService agentService : agentServiceLoader) {
            if (!agentService.startForAgent(this.agentInfo)) continue;
            agentLog.log(Level.FINEST, "Starting service {0}", agentService.getAgentServiceName());
            this.componentLookupService.addComponentNodeToLookup(agentComponentNode, new ComponentNode(agentService.getAgentServiceName(), (Object)agentService));
        }
        this.subsystemPersistencyService = PersistencyService.create(this);
        LookupInjectUtils.injectComponents(this.componentLookupService, true);
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, ServiceLifecycle.class, n -> n.preBuild(), null);
        agentLog.log(Level.INFO, "Starting HasLifecycle::build step");
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, HasLifecycle.class, n -> n.build(), n -> n.postBuild());
        LookupInjectUtils.injectComponents(this.componentLookupService, true);
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, ServiceLifecycle.class, n -> n.afterBuild(), null);
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, ServiceLifecycle.class, n -> n.preInit(), null);
        agentLog.log(Level.INFO, "Starting HasLifecycle::init step");
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, HasLifecycle.class, n -> n.init(), n -> n.postInit());
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, ServiceLifecycle.class, n -> n.afterInit(), null);
    }

    @Override
    public void preStart() {
        Agent.setEnvironmentAgent(this);
    }

    public final List<AgentService> getAgentServices() {
        return this.agentServices;
    }

    public final <T extends AgentService> T getAgentService(Class<T> agentClass) {
        AgentService foundService;
        if (!this.agentServicesByClass.containsKey(agentClass)) {
            for (AgentService service : this.agentServices) {
                if (!agentClass.isInstance(service)) continue;
                this.agentServicesByClass.put(agentClass, service);
            }
        }
        if ((foundService = this.agentServicesByClass.get(agentClass)) == null) {
            throw new RuntimeException("Service of type " + agentClass + " does not exist in this Agent");
        }
        return (T)((AgentService)agentClass.cast(foundService));
    }

    public final ComponentLookup getComponentLookup() {
        return this.componentLookupService;
    }

    protected CommandHelper createHelper() {
        CommandHelper currentHelper = this.currentCommandHelper.get();
        return currentHelper == null ? new CommandHelper(this) : currentHelper;
    }

    public CommandHelper helper() {
        return this.createHelper();
    }

    public final void setAgentName(String alias) {
        if (this.treeComponentInitialized) {
            throw new RuntimeException("Too late to change the Agent name.");
        }
        if (alias != null) {
            this.agentInfo = new AgentInfo(alias, this.agentInfo.getType(), this.agentInfo.getAgentProperties());
        }
        SubstitutionTokenUtils.addSubstitutionToken((String)"alias", (String)this.agentInfo.getName());
    }

    public final void initAgent() {
        if (!this.treeComponentInitialized) {
            this.populateComponentLookup(new ComponentLookup(new ComponentNode(this.getName(), (Object)this)));
        }
    }

    public void startAgent() {
        this.initAgent();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.jvmShutdown.set(true);
            try {
                if (this.stateService.getState(PhaseState.class) != null && !this.stateService.isInState((Enum)PhaseState.OFF_LINE)) {
                    this.shutdownAgent();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, ServiceLifecycle.class, ServiceLifecycle::preStart, null);
        AlertService alertService = this.getAgentService(AlertService.class);
        this.messagingService.getMessagingAccess().setClusterDeserializationErrorHandler((ClusterDeserializationErrorHandler)new AgentClusterDeserializationErrorHandler(alertService));
        agentLog.log(Level.INFO, "Starting HasLifecycle::start step");
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, HasLifecycle.class, HasLifecycle::start, null);
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, HasLifecycle.class, HasLifecycle::postStart, null);
        this.getAgentInfo().setAgentOperationalTime();
        agentLog.log(Level.INFO, "Agent is going OPERATIONAL");
        this.stateService.updateInternalState(new AgentState[]{PhaseState.OPERATIONAL});
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, ServiceLifecycle.class, ServiceLifecycle::afterStart, null);
    }

    private void terminate() {
        if (this.isAlive.getAndSet(false)) {
            Handler[] handlers;
            agentLog.log(Level.FINE, "Subsystem {0} final shutdown", this.getName());
            if (this.logBusHandler != null) {
                generalLogger.removeHandler((Handler)this.logBusHandler);
                this.logBusHandler.close();
            }
            this.scheduler.shutdownNow();
            this.queryExecutor.shutdownNow();
            this.actionExecutor.shutdownNow();
            this.signalExecutor.shutdownNow();
            this.messagingService.getMessagingAccess().shutdownBusAccess();
            java.util.logging.Logger rootLogger = java.util.logging.Logger.getLogger("");
            for (Handler h : handlers = rootLogger.getHandlers()) {
                h.close();
            }
        }
    }

    @Command(name="shutdown", description="shutdown", type=Command.CommandType.ACTION, category=Command.CommandCategory.CORE)
    public Object shutdownAgent() throws Exception {
        return this.shutdownAgent(true);
    }

    protected Object shutdownAgent(boolean goOffline) throws Exception {
        agentLog.log(this.getAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.CONSOLE) > 0 ? Level.INFO : Level.FINE, "{0} is shutting down", this.getName());
        this.stateService.updateInternalState(new AgentState[]{PhaseState.CLOSING});
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, ServiceLifecycle.class, ServiceLifecycle::preShutdown, null);
        TreeWalkerUtils.proceduralWalk(this.getComponentLookup(), null, HasLifecycle.class, HasLifecycle::shutdown, HasLifecycle::postShutdown);
        this.messagingService.getMessagingAccess().setClusterDeserializationErrorHandler(ClusterDeserializationErrorHandler.DEFAULT);
        if (goOffline) {
            this.stateService.updateInternalState(new AgentState[]{PhaseState.OFF_LINE});
        }
        if (Thread.currentThread().getThreadGroup() != this.commandGroup) {
            this.terminate();
        }
        return new ShutdownResult();
    }

    public Logger getLogger() {
        return log;
    }

    public final String getName() {
        return this.agentInfo.getName();
    }

    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public int getCommandCount(Command.CommandType ... types) {
        if (types.length == 0) {
            return this.currentQueries.size() + (this.currentAction == null ? 0 : 1) + this.currentSignals.size();
        }
        int out = 0;
        for (Command.CommandType type : types) {
            out += this.getCommandCount(type);
        }
        return out;
    }

    @Command(description="is the system in engineering mode ?", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE)
    public boolean isInEngineeringMode() {
        Enum em = this.stateService.getState(OperationalState.class);
        return em != null && em.compareTo(OperationalState.ENGINEERING_OK) >= 0;
    }

    @Command(description="Print component lookup", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public String printComponentNodeTree() {
        StringBuilder sb = new StringBuilder();
        TreeWalkerUtils.proceduralNodeWalk(this.componentLookupService, null, n -> sb.append(n.getPath()).append("\n"), null);
        return sb.toString();
    }

    public AgentMessagingLayer getMessagingAccess() {
        return this.messagingService.getMessagingAccess();
    }

    private static void setEnvironmentAgent(Agent a) {
        if (environmentAgent == null) {
            environmentAgent = a;
        } else if ("false".equals(BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.testcontext", "false"))) {
            throw new RuntimeException("*** Should not have two agents running in same JVM: " + environmentAgent.getDescription() + " " + environmentAgent.getName());
        }
    }

    public static AgentMessagingLayer getEnvironmentMessagingAccess() {
        if (environmentAgent == null) {
            throw new IllegalStateException("The environment has not been initialized yet");
        }
        return Agent.environmentAgent.messagingService.getMessagingAccess();
    }

    public static AgentLockService getEnvironmentLockService() {
        if (environmentAgent == null) {
            throw new IllegalStateException("The environment has not been initialized yet");
        }
        return environmentAgent.getAgentService(AgentLockService.class);
    }

    public void sendStatusMessage(StatusMessage msg) {
        this.messagingService.getMessagingAccess().sendStatusMessage(msg);
    }

    public void initLogBusHandler() {
        if (this.logBusHandler == null) {
            this.logBusHandler = new LogBusHandler(this.messagingService.getMessagingAccess());
            generalLogger.addHandler((Handler)this.logBusHandler);
        }
    }

    public final void publishSubsystemDataOnStatusBus(KeyValueData keyValueData) {
        StatusSubsystemData statusData = new StatusSubsystemData(keyValueData);
        this.dataProviderDictionaryService.publishingTrendingData(statusData);
        this.sendStatusMessage((StatusMessage)statusData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommandRequest(CommandRequest request) {
        Object object = this.commandExecutorLock;
        synchronized (object) {
            try {
                PhaseState phase = (PhaseState)this.stateService.getState(PhaseState.class);
                if (phase == null || phase == PhaseState.OFF_LINE) {
                    CommandNack nack = new CommandNack(request, (Serializable)((Object)("Cannot accept command: OFF_LINE or NULL phase state " + this.currentAction)));
                    agentLog.log(Level.WARNING, "sending nack {0}", nack);
                    if (this.messagingService.isConnectedToTheBuses()) {
                        this.messagingService.getMessagingAccess().sendCommandReply((CommandReply)nack);
                    }
                    return;
                }
                String destination = request.getDestination();
                BasicCommand basicCommand = request.getBasicCommand();
                CommandSet commandSet = this.agentCommandDictionaryService.getCommandSet(destination);
                if (commandSet == null) {
                    throw new RuntimeException("Unknown destination " + destination);
                }
                DictionaryCommand dictionaryCommand = commandSet.getCommandDictionary().findCommand(basicCommand);
                if (dictionaryCommand == null) {
                    throw new RuntimeException("Could not find command " + basicCommand + " from " + request.getOriginAgentInfo().getName());
                }
                Command.CommandType type = dictionaryCommand.getType();
                if (this.stateService.getState(OperationalState.class) == OperationalState.NORMAL && dictionaryCommand.getLevel() != 0) {
                    CommandNack nack = new CommandNack(request, (Serializable)((Object)("In NORMAL OperationalMode only level 0 commands are accepted. Requested command level is : " + dictionaryCommand.getLevel())));
                    agentLog.log(Level.WARNING, "sending nack {0}", nack);
                    this.messagingService.getMessagingAccess().sendCommandReply((CommandReply)nack);
                    return;
                }
                AgentLock lock = request.getLock();
                agentLog.log(type.equals((Object)Command.CommandType.QUERY) ? Level.FINE : Level.INFO, () -> {
                    String component;
                    StringBuilder logMessage = new StringBuilder("Received command from ").append(request.getOriginAgentInfo().getName());
                    if (lock != null) {
                        logMessage.append(" (user ").append(lock.getOwner()).append(")");
                    }
                    String string = component = destination.contains("/") ? destination.substring(destination.indexOf(47)) : null;
                    if (component != null && !component.isEmpty()) {
                        logMessage.append(" component ").append(component);
                    }
                    logMessage.append(": ").append((String)request.getEncodedData());
                    return logMessage.toString();
                });
                String message = this.agentLockService.validateLock(dictionaryCommand, lock, request.getLevel());
                if (message != null) {
                    agentLog.warning(message);
                    throw new RuntimeException(message);
                }
                switch (type) {
                    case QUERY: {
                        RunningCommand runningCommand = new RunningCommand(request, dictionaryCommand, commandSet);
                        this.currentQueries.add(runningCommand);
                        this.queryExecutor.submit(runningCommand.getTask());
                        break;
                    }
                    case CONFIGURATION: {
                        if (this.stateService.getState(OperationalState.class).compareTo(OperationalState.ENGINEERING_OK) < 0) {
                            CommandNack nack = new CommandNack(request, (Serializable)((Object)"CONFIGURATION commands are only accepted in ENGINEERING mode"));
                            agentLog.log(Level.WARNING, "sending nack {0}", nack);
                            this.messagingService.getMessagingAccess().sendCommandReply((CommandReply)nack);
                            return;
                        }
                    }
                    case ACTION: {
                        RunningCommand runningCommand;
                        if (!this.stateService.isInState((Enum)CommandState.READY)) {
                            CommandNack nack = new CommandNack(request, (Serializable)((Object)"ACTION and CONFIGURATION commands are only accepted in READY state"));
                            agentLog.log(Level.WARNING, "{0} sending nack {1}", new Object[]{type, nack});
                            this.messagingService.getMessagingAccess().sendCommandReply((CommandReply)nack);
                            return;
                        }
                        this.stateService.updateInternalState(new AgentState[]{CommandState.ACTIVE});
                        this.currentAction = runningCommand = new RunningCommand(request, dictionaryCommand, commandSet);
                        this.actionExecutor.submit(runningCommand.getTask());
                        break;
                    }
                    case SIGNAL: {
                        long dueTime;
                        long currentTime = dueTime = System.currentTimeMillis();
                        DictionaryArgument[] arguments = dictionaryCommand.getArguments();
                        if (basicCommand.getArguments().length > 0 && "Long".equalsIgnoreCase(arguments[0].getSimpleType())) {
                            String argAsString = String.valueOf(basicCommand.getArguments()[0]);
                            Long expectedMaxDelay = Long.valueOf(argAsString);
                            dueTime = currentTime + expectedMaxDelay;
                        }
                        for (RunningCommand rc : this.currentSignals) {
                            if (rc.timeout >= dueTime) continue;
                            CommandNack nack = new CommandNack(request, (Serializable)((Object)"SIGNAL with shorter deadline is already running"));
                            agentLog.log(Level.WARNING, "{0} sending nack {1}", new Object[]{type, nack});
                            this.messagingService.getMessagingAccess().sendCommandReply((CommandReply)nack);
                            return;
                        }
                        this.stateService.updateInternalState(new AgentState[]{CommandState.ACTIVE});
                        agentLog.log(Level.FINE, "Received Signal from {0} for running action {1}", new Object[]{request.getOriginAgentInfo().getName(), this.currentAction});
                        RunningCommand runningCommand = new RunningCommand(request, dictionaryCommand, commandSet);
                        this.currentSignals.add(runningCommand);
                        this.signalExecutor.submit(runningCommand.getTask());
                        break;
                    }
                    default: {
                        assert (false) : "Unknown command type :" + type;
                        break;
                    }
                }
            }
            catch (EmbeddedObjectDeserializationException ex) {
                CommandNack nack = new CommandNack(request, (Serializable)((Object)ex));
                agentLog.log(Level.SEVERE, "sending nack " + nack, ex);
                this.messagingService.getMessagingAccess().sendCommandReply((CommandReply)nack);
            }
            catch (RuntimeException | CommandArgumentMatchException t) {
                CommandNack nack = new CommandNack(request, (Serializable)t);
                agentLog.log(Level.SEVERE, "Error processing command request ", t);
                this.messagingService.getMessagingAccess().sendCommandReply((CommandReply)nack);
            }
        }
    }

    private ThreadFactory createThreadFactory(String name) {
        return run -> {
            Thread thread = new Thread(this.commandGroup, run, name);
            thread.setUncaughtExceptionHandler((t, x) -> agentLog.log(Level.SEVERE, "Uncaught exception in command thread " + t.getName(), x));
            return thread;
        };
    }

    public boolean sendNack(Serializable reason) {
        RunningCommand command = this.currentCommand.get();
        if (command != null && command.dictionaryCommand.isAutoAck()) {
            throw new RuntimeException("sendNack cannot be invoked while executing a command that is not annotated with \"autoAck=false\".");
        }
        if (command == null || command.reply != null) {
            return false;
        }
        command.reply = new CommandNack(command.request, reason);
        agentLog.log(Level.WARNING, "sending nack {0}", command.reply);
        this.messagingService.getMessagingAccess().sendCommandReply(command.reply);
        return true;
    }

    public boolean sendAck(Duration timeout) {
        RunningCommand command = this.currentCommand.get();
        if (command != null && command.dictionaryCommand.isAutoAck()) {
            throw new RuntimeException("sendAck cannot be invoked while executing a command that is not annotated with \"autoAck=false\".");
        }
        if (command == null || command.reply != null) {
            return false;
        }
        command.reply = new CommandAck(command.request, timeout);
        this.messagingService.getMessagingAccess().sendCommandReply(command.reply);
        return true;
    }

    String getCurrentRunningCommandName() {
        RunningCommand rc = this.currentCommand.get();
        return rc != null ? rc.getCommandRequest().getBasicCommand().getCommand() : "unknown";
    }

    boolean isExternalCommandInvocation() {
        return this.currentCommand.get() != null;
    }

    public RunningCommand getCurrentAction() {
        return this.currentAction;
    }

    @Deprecated
    public ComponentConfigurationEnvironment getComponentConfigurationEnvironment(Object obj) {
        ComponentNode node = this.getComponentLookup().getComponentNodeForObject(obj);
        if (node == null) {
            throw new IllegalArgumentException("Could not find a component node for object " + obj);
        }
        String name = node.getPath();
        return this.getComponentConfigurationEnvironmentByName(name);
    }

    @Deprecated
    public ComponentConfigurationEnvironment getComponentConfigurationEnvironmentByName(String name) {
        return this.subsystemConfigurationEnvironment.getComponentConfigurationEnvironment(name);
    }

    public PersistencyService getAgentPersistenceService() {
        return this.subsystemPersistencyService;
    }

    public String getDescription() {
        ComponentNode topNode = this.getComponentLookup().getTopComponentNode();
        String descName = (String)topNode.getTag("descriptionName");
        if (descName != null && !descName.isEmpty() && descName.contains(".")) {
            descName = descName.substring(descName.lastIndexOf(".") + 1);
        }
        if (descName == null) {
            String className = this.getClass().getSimpleName();
            if (className.isEmpty()) {
                className = this.getClass().getSuperclass().getSimpleName();
            }
            descName = className;
        }
        return descName;
    }

    private int getCommandCount(Command.CommandType type) {
        switch (type) {
            case QUERY: {
                return this.currentQueries.size();
            }
            case CONFIGURATION: 
            case ACTION: {
                RunningCommand current = this.currentAction;
                if (current.type == null) {
                    return 0;
                }
                return current.type == type ? 1 : 0;
            }
            case SIGNAL: {
                return this.currentSignals.size();
            }
        }
        assert (false) : "Unknown command type " + type;
        return 0;
    }

    public String vetoTransitionToNormalMode() {
        return null;
    }

    private String getCCSLaunchScript() {
        String appFullPath = System.getenv("CCS_APP_FULL_PATH");
        if (appFullPath != null) {
            String appArguments = System.getenv("CCS_APP_ARGS");
            if (appArguments != null && !appArguments.isEmpty()) {
                appFullPath = appFullPath + " " + appArguments;
            }
            return appFullPath;
        }
        return null;
    }

    static {
        Log4JConfiguration.initialize();
        log = Logger.getLogger((String)"org.lsst.ccs.subsystem");
        agentLog = java.util.logging.Logger.getLogger("org.lsst.ccs.agent");
        generalLogger = java.util.logging.Logger.getLogger("org.lsst.ccs");
        environmentAgent = null;
    }

    private class AgentClusterDeserializationErrorHandler
    implements ClusterDeserializationErrorHandler {
        private final AlertService alertService;
        private final AlertState alertState;
        private long lastRaisedAlertTimestamp = 0L;
        private long waitTimePeriod = Duration.ofMinutes(1L).toMillis();

        public AgentClusterDeserializationErrorHandler(AlertService alertService) {
            this.alertService = alertService;
            this.alertState = AlertState.WARNING;
        }

        public void process(String address, RuntimeException exc) {
            long thisErrorTimestamp = System.currentTimeMillis();
            if (thisErrorTimestamp - this.lastRaisedAlertTimestamp > this.waitTimePeriod) {
                HashMap<String, String> alertData = new HashMap<String, String>();
                alertData.put("sender", address);
                alertData.put("receiver", Agent.this.getName());
                this.alertService.raiseAlert(AgentAlerts.ClusterAlert.getAlert(alertData), this.alertState, Agent.this.getName() + " and " + address + " are running incompatible core versions");
                agentLog.log(Level.WARNING, "cluster deserialization exception", exc);
                this.lastRaisedAlertTimestamp = thisErrorTimestamp;
            }
        }
    }

    public class ShutdownResult
    implements Serializable {
        public String toString() {
            return "OK";
        }
    }

    public final class RunningCommand {
        protected final CommandRequest request;
        protected final Command.CommandType type;
        protected final CommandSet commandSet;
        protected final DictionaryCommand dictionaryCommand;
        protected final long timeout;
        protected Serializable result;
        protected CommandReply reply;
        private boolean isShutdownCommand = false;
        private final FutureTask<Object> task;

        RunningCommand(CommandRequest request, DictionaryCommand dictionaryCommand, CommandSet commandSet) {
            this(request, dictionaryCommand, commandSet, 0L);
        }

        RunningCommand(CommandRequest request, DictionaryCommand dictionaryCommand, CommandSet commandSet, long timeout) {
            this.request = request;
            this.dictionaryCommand = dictionaryCommand;
            this.type = dictionaryCommand.getType();
            this.commandSet = commandSet;
            this.timeout = timeout;
            this.task = new FutureTask<Object>(() -> {
                Agent.this.currentCommand.set(this);
                Agent.this.currentCommandHelper.set(new CommandHelper(Agent.this));
                if (dictionaryCommand.isAutoAck()) {
                    this.reply = new CommandAck(request, dictionaryCommand.getTimeout());
                    Agent.this.messagingService.getMessagingAccess().sendCommandReply(this.reply);
                }
                BasicCommand basicCommand = request.getBasicCommand();
                try {
                    if (basicCommand.getOptions().hasOption(AgentCommandDictionaryService.withLockOption)) {
                        basicCommand.getOptions().removeOption(AgentCommandDictionaryService.withLockOption);
                    }
                    this.result = (Serializable)commandSet.invoke(basicCommand);
                    agentLog.log(dictionaryCommand.getType().equals((Object)Command.CommandType.QUERY) ? Level.FINE : Level.INFO, "Command execution result:{0}", this.result);
                }
                catch (Exception t) {
                    agentLog.log(Level.INFO, "Command execution error:" + basicCommand.getCommand() + Arrays.toString(basicCommand.getArguments()), t);
                    this.result = t;
                }
                if (this.result != null && this.result instanceof ShutdownResult) {
                    this.isShutdownCommand = true;
                    this.result = this.result.toString();
                }
                Object t = Agent.this.commandExecutorLock;
                synchronized (t) {
                    switch (this.type) {
                        case QUERY: {
                            Agent.this.currentQueries.remove(this);
                            break;
                        }
                        case CONFIGURATION: 
                        case ACTION: {
                            Agent.this.currentAction = null;
                            if (!Agent.this.currentSignals.isEmpty()) break;
                            Agent.this.stateService.updateInternalState(new AgentState[]{CommandState.READY});
                            break;
                        }
                        case SIGNAL: {
                            Agent.this.currentSignals.remove(this);
                            if (Agent.this.currentAction != null || !Agent.this.currentSignals.isEmpty()) break;
                            Agent.this.stateService.updateInternalState(new AgentState[]{CommandState.READY});
                            break;
                        }
                        default: {
                            assert (false) : "Unknown command type :" + this.type;
                            break;
                        }
                    }
                }
                if (this.reply == null) {
                    this.reply = new CommandAck(request, dictionaryCommand.getTimeout());
                    Agent.this.messagingService.getMessagingAccess().sendCommandReply(this.reply);
                }
                if (!(this.reply instanceof CommandNack)) {
                    this.reply = new CommandResult(request, this.result);
                    Agent.this.messagingService.getMessagingAccess().sendCommandReply(this.reply);
                }
                if (Agent.this.stateService.isInState((Enum)PhaseState.OFF_LINE) && Agent.this.currentAction == null && Agent.this.currentSignals.isEmpty() && this.isShutdownCommand) {
                    Thread shutdownThread = new Thread(() -> Agent.this.terminate(), "Agent shutdown thread");
                    shutdownThread.start();
                }
                Agent.this.currentCommand.set(null);
                Agent.this.currentCommandHelper.set(null);
                return this.result;
            });
        }

        private FutureTask<Object> getTask() {
            return this.task;
        }

        public CommandRequest getCommandRequest() {
            return this.request;
        }

        public Command.CommandType getType() {
            return this.type;
        }

        public CommandReply getReply() {
            return this.reply;
        }

        public void cancel() {
            this.task.cancel(true);
        }

        public String toString() {
            return "Command(" + this.type.name() + ") from " + this.request.getOriginAgentInfo().getName() + ": " + (String)this.request.getEncodedData();
        }
    }
}

