/*
 * Decompiled with CFR 0.152.
 */
package com.wittams.gritty;

import com.wittams.gritty.Style;
import com.wittams.gritty.StyledRunConsumer;
import com.wittams.gritty.Util;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.log4j.Logger;

public class ScrollBuffer
implements StyledRunConsumer {
    private static final Logger logger = Logger.getLogger(ScrollBuffer.class);
    private static final int BUF_SIZE = 8192;
    private static final int RUN_SIZE = 128;
    List<Section> completeSections = new ArrayList<Section>();
    Section currentSection;
    int currentRun;
    int bufPos;
    private int totalLines;

    public ScrollBuffer() {
        this.newSection();
    }

    private void newSection() {
        this.currentSection = new Section();
        this.currentRun = -1;
        this.bufPos = 0;
    }

    public synchronized String getLines() {
        final StringBuffer sb = new StringBuffer();
        StyledRunConsumer consumer = new StyledRunConsumer(){

            @Override
            public void consumeRun(int x, int y, Style style, char[] buf, int start, int len) {
                if (x == 0) {
                    sb.append('\n');
                }
                sb.append(buf, start, len);
            }
        };
        int currentLine = -this.totalLines;
        for (Section s : this.completeSections) {
            currentLine = s.pumpRunsComplete(currentLine, currentLine, 0, consumer);
        }
        this.currentSection.pumpRunsCurrent(currentLine, currentLine, 0, consumer, this.bufPos);
        return sb.toString();
    }

    @Override
    public synchronized void consumeRun(int x, int y, Style style, char[] buf, int start, int len) {
        boolean isNewLine;
        ++this.currentRun;
        boolean bl = isNewLine = x == 0;
        if (isNewLine) {
            ++this.totalLines;
        }
        this.bufPos = this.currentSection.putRun(this.currentRun, this.bufPos, isNewLine, style, buf, start, len);
        if (this.bufPos < 0) {
            this.completeSections.add(this.currentSection);
            this.newSection();
            ++this.currentRun;
            this.bufPos = this.currentSection.putRun(this.currentRun, this.bufPos, isNewLine, style, buf, start, len);
            if (this.bufPos < 0) {
                logger.error((Object)"Can not put run in new section, bailing out");
            }
        }
    }

    public int getLineCount() {
        return this.totalLines;
    }

    public void pumpRuns(int firstLine, int height, StyledRunConsumer consumer) {
        int currentLine = -this.currentSection.getLineCount();
        int lastLine = firstLine + height;
        if (currentLine > firstLine) {
            int i;
            for (i = this.completeSections.size() - 1; i >= 0 && (currentLine -= this.completeSections.get(i).getLineCount()) > firstLine; --i) {
            }
            for (i = Math.max(i, 0); i < this.completeSections.size(); ++i) {
                int startLine = Math.max(firstLine, currentLine);
                Section s = this.completeSections.get(i);
                currentLine = s.pumpRunsComplete(currentLine, startLine, lastLine, consumer);
                if (currentLine >= lastLine) break;
            }
        }
        if (currentLine < lastLine) {
            this.currentSection.pumpRunsCurrent(currentLine, Math.max(firstLine, currentLine), lastLine, consumer, this.bufPos);
        }
    }

    static class Section {
        int width;
        char[] buf = new char[8192];
        int[] runStarts = new int[128];
        Style[] runStyles = new Style[128];
        BitSet lineStarts = new BitSet(128);

        Section() {
        }

        public void setLineStart(int currentRun) {
        }

        public int putRun(int currentRun, int bufPos, boolean isNewLine, Style style, char[] otherBuf, int start, int len) {
            if (bufPos + len >= this.buf.length) {
                this.complete(currentRun, bufPos);
                return -1;
            }
            this.ensureArrays(currentRun);
            this.lineStarts.set(currentRun, isNewLine);
            this.runStarts[currentRun] = bufPos;
            this.runStyles[currentRun] = style;
            System.arraycopy(otherBuf, start, this.buf, bufPos, len);
            return bufPos + len;
        }

        private void ensureArrays(int currentRun) {
            if (currentRun >= this.runStarts.length) {
                this.runStarts = Util.copyOf(this.runStarts, this.runStarts.length * 2);
                this.runStyles = Util.copyOf(this.runStyles, this.runStyles.length * 2);
            }
        }

        public void complete(int currentRun, int bufPos) {
            this.runStarts = Util.copyOf(this.runStarts, currentRun);
            this.runStyles = Util.copyOf(this.runStyles, currentRun);
            this.buf = Util.copyOf(this.buf, bufPos);
            this.lineStarts = this.lineStarts.get(0, currentRun);
        }

        public int pumpRunsComplete(int firstLine, int startLine, int endLine, StyledRunConsumer consumer) {
            return this.pumpRunsImpl(firstLine, startLine, endLine, consumer, this.buf.length);
        }

        public int pumpRunsCurrent(int firstLine, int startLine, int endLine, StyledRunConsumer consumer, int bufPos) {
            return this.pumpRunsImpl(firstLine, startLine, endLine, consumer, bufPos);
        }

        private int pumpRunsImpl(int firstLine, int startLine, int endLine, StyledRunConsumer consumer, int bufferEnd) {
            int x = 0;
            int y = firstLine - 1;
            for (int i = 0; i < this.runStarts.length; ++i) {
                int runEnd;
                if (this.lineStarts.get(i)) {
                    x = 0;
                    ++y;
                }
                if (y < startLine) continue;
                if (y > endLine) break;
                int runStart = this.runStarts[i];
                boolean last = false;
                if (i == this.runStarts.length - 1 || this.runStarts[i + 1] == 0) {
                    runEnd = bufferEnd;
                    last = true;
                } else {
                    runEnd = this.runStarts[i + 1];
                }
                consumer.consumeRun(x, y, this.runStyles[i], this.buf, runStart, runEnd - runStart);
                x += runEnd - runStart;
                if (last) break;
            }
            return y;
        }

        int getLineCount() {
            return this.lineStarts.cardinality();
        }
    }
}

