/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending.dataselection;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.plugins.trending.dataselection.DataType;
import org.lsst.ccs.gconsole.util.swing.Utilities;

public final class DataTypeDialog
extends JPanel {
    private final JPanel panel;
    private final JLabel label;
    private final JRadioButton useRawRadio;
    private final JRadioButton useStatRadio;
    private final JTextField nBinsField;
    private final JTextField nameField;
    private final JCheckBox nBinsCheck;
    private final JCheckBox saveCheck;
    private DataType outType;
    private final JButton okButton;
    private boolean defaultName = true;

    private DataTypeDialog(DataType seed) {
        if (seed == null) {
            seed = DataType.DEFAULT;
        }
        this.okButton = new JButton("  OK  ");
        this.setLayout(new BoxLayout(this, 1));
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.setAlignmentX(0.0f);
        this.panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" DATA "), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        Box row = Box.createHorizontalBox();
        row.setAlignmentX(0.0f);
        row.add(new JLabel("Data source: "));
        ButtonGroup group = new ButtonGroup();
        this.useRawRadio = new JRadioButton("Raw");
        group.add(this.useRawRadio);
        row.add(this.useRawRadio);
        this.useStatRadio = new JRadioButton("Statistical");
        group.add(this.useStatRadio);
        row.add(this.useStatRadio);
        row.add(Box.createHorizontalGlue());
        this.panel.add(row);
        row = Box.createHorizontalBox();
        row.setAlignmentX(0.0f);
        this.nBinsCheck = new JCheckBox("Plot approximately");
        this.nBinsField = new JTextField(3);
        row.add(this.nBinsCheck);
        this.nBinsField.setMaximumSize(new Dimension(this.nBinsField.getPreferredSize().width, this.nBinsField.getPreferredSize().height));
        this.nBinsField.setInputVerifier(Utilities.BLACK_VERIFIER);
        row.add(this.nBinsField);
        this.label = new JLabel(" data points.");
        row.add(this.label);
        row.add(Box.createHorizontalGlue());
        this.panel.add(row);
        this.panel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(this.panel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        Box saveBox = Box.createVerticalBox();
        saveBox.setAlignmentX(0.0f);
        saveBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Remember As "), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.nameField = new JTextField();
        this.nameField.setColumns(30);
        saveBox.add(this.nameField);
        saveBox.add(Box.createRigidArea(new Dimension(0, 5)));
        this.saveCheck = new JCheckBox("Remember between sessions");
        saveBox.add(this.saveCheck);
        this.add(saveBox);
        if (seed.getRaw().booleanValue()) {
            this.useRawRadio.setSelected(true);
            this.nBinsCheck.setEnabled(false);
            this.nBinsField.setEnabled(false);
            this.nBinsField.setText("");
            this.label.setEnabled(false);
        } else {
            this.useStatRadio.setSelected(true);
            this.nBinsCheck.setEnabled(true);
            this.label.setEnabled(true);
            int n = seed.getBins();
            if (n == 0) {
                this.nBinsCheck.setSelected(false);
                this.nBinsField.setEnabled(false);
                this.nBinsField.setText("");
            } else {
                this.nBinsCheck.setSelected(true);
                this.nBinsField.setEnabled(true);
                this.nBinsField.setText(Integer.toString(n));
            }
            this.saveCheck.setSelected(seed.isPersistent());
            this.adjustName();
            this.nameField.setText(seed.getName());
        }
        this.nBinsField.addCaretListener(e -> {
            String text = this.nBinsField.getText().trim();
            boolean valid = true;
            if (!text.isEmpty()) {
                try {
                    int value = Integer.parseInt(text);
                    valid = value > 0;
                }
                catch (NumberFormatException x) {
                    valid = false;
                }
            }
            this.nBinsField.setForeground(valid ? Color.BLACK : Color.RED);
            this.adjustName();
        });
        this.useRawRadio.addActionListener(e -> {
            this.nBinsCheck.setEnabled(false);
            this.nBinsCheck.setSelected(false);
            this.nBinsField.setEnabled(false);
            this.nBinsField.setText("");
            this.label.setEnabled(false);
            this.nameField.setEnabled(false);
            this.saveCheck.setEnabled(false);
            this.adjustName();
        });
        this.useStatRadio.addActionListener(e -> {
            this.nBinsCheck.setEnabled(true);
            this.nBinsField.setEnabled(false);
            this.nBinsField.setText("30");
            this.label.setEnabled(true);
            this.adjustName();
        });
        this.nBinsCheck.addActionListener(e -> {
            if (this.nBinsCheck.isSelected()) {
                this.nBinsField.setEnabled(true);
                this.nBinsField.grabFocus();
            } else {
                this.nBinsField.setEnabled(false);
            }
            this.adjustName();
        });
    }

    public static DataType defineDataType(JComponent parent, DataType seed) {
        DataTypeDialog tsp = new DataTypeDialog(seed);
        tsp.okButton.addActionListener(e -> {
            tsp.outType = tsp.getType();
            Window w = SwingUtilities.getWindowAncestor(tsp);
            if (w != null) {
                w.setVisible(false);
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> {
            Window w = SwingUtilities.getWindowAncestor(tsp);
            if (w != null) {
                w.setVisible(false);
            }
        });
        JOptionPane.showOptionDialog(parent, tsp, "Select data type", 2, -1, null, new Object[]{tsp.okButton, cancelButton}, null);
        return tsp.outType;
    }

    private DataType getType() {
        String name = this.nameField.getText().trim();
        if (name.isEmpty()) {
            name = null;
        }
        boolean persistent = this.saveCheck.isSelected();
        boolean raw = this.useRawRadio.isSelected();
        if (raw) {
            return DataType.RAW;
        }
        if (this.nBinsCheck.isSelected()) {
            try {
                int bins = Integer.parseInt(this.nBinsField.getText());
                if (bins < 1) {
                    throw new NumberFormatException();
                }
                return new DataType(name, raw, bins, persistent);
            }
            catch (NumberFormatException x) {
                return null;
            }
        }
        return DataType.DEFAULT;
    }

    private void adjustName() {
        DataType type = this.getType();
        if (type == null) {
            this.nameField.setText("");
            this.okButton.setEnabled(false);
        } else {
            if (type == DataType.RAW || type == DataType.DEFAULT) {
                this.nameField.setEnabled(false);
                this.saveCheck.setEnabled(false);
                this.saveCheck.setSelected(false);
            } else {
                type.setName(null);
                this.nameField.setEnabled(true);
                this.saveCheck.setEnabled(true);
            }
            this.nameField.setText(type.getName());
            this.okButton.setEnabled(true);
        }
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(() -> {
            DataType tw = null;
            do {
                tw = DataTypeDialog.defineDataType(null, tw);
                System.out.println(tw);
            } while (tw != null);
        });
    }
}

