/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.kafka.avro;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.kafka.avro.AvroSchemaMapper;
import org.lsst.ccs.camera.kafka.avro.GenericRecordManager;
import org.lsst.ccs.camera.kafka.avro.KafkaProxyBridge;
import org.lsst.ccs.camera.kafka.avro.Topic;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class PublishSchemaRecords {
    private static final Scheduler scheduler = new Scheduler("abc", 10);

    public static void main(String[] args) throws Exception {
        KafkaProxyBridge proxy = new KafkaProxyBridge();
        List<String> allTopics = proxy.listTopics();
        Random r = new Random();
        for (Camera c : Camera.values()) {
            AvroSchemaMapper mapper = new AvroSchemaMapper(c);
            mapper.buildSchemasForLocalDictionaries();
            GenericRecordManager recordManager = new GenericRecordManager(mapper);
            for (int i = 0; i < 10; ++i) {
                long timestamp = System.currentTimeMillis();
                for (String path : mapper.getAvailablePaths()) {
                    String type = mapper.getTopicFieldForPath(path).getType();
                    if (!type.equals("double")) continue;
                    recordManager.addKeyValueForPath(path, r.nextDouble(), timestamp);
                }
            }
            ArrayList<ScheduledFuture> futures = new ArrayList<ScheduledFuture>();
            for (Topic t : recordManager.getTopicsWithData()) {
                if (!allTopics.contains(t.getFullName())) continue;
                Schema schema = mapper.getSchemaForTopic(t);
                ArrayList<GenericRecord> l = null;
                for (GenericRecord gr : recordManager.getRecordsForTopic(t)) {
                    if (l == null) {
                        l = new ArrayList<GenericRecord>();
                    }
                    l.add(gr);
                    if (l.size() != 50) continue;
                    ArrayList tmpList = new ArrayList(l);
                    futures.add(scheduler.schedule(() -> proxy.publishRecordsForSchema(schema, tmpList), 0L, TimeUnit.MILLISECONDS));
                    l = null;
                }
                if (l == null) continue;
                ArrayList tmpList = new ArrayList(l);
                futures.add(scheduler.schedule(() -> proxy.publishRecordsForSchema(schema, tmpList), 0L, TimeUnit.MILLISECONDS));
            }
            for (ScheduledFuture f : futures) {
                f.get();
            }
        }
        scheduler.shutdown();
    }
}

