/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ChecksumUtils;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.bus.annotations.DoNotTrend;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.DictionaryWriter;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.BusMessagePreProcessor;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.DataDictionaryByType;
import org.lsst.ccs.services.DataDictionaryCompro;
import org.lsst.ccs.services.DataDictionaryOrdered;
import org.lsst.ccs.services.DataProviderDictionaryImpl;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.services.MessagingService;
import org.lsst.ccs.services.RemoteDictionaryDAO;

public final class DataProviderDictionaryService
implements ServiceLifecycle,
HasLifecycle,
AgentService,
BusMessagePreProcessor {
    private static final Logger log = Logger.getLogger("org.lsst.ccs.services.data.dictionary");
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentCommandDictionaryService agentCommandDictionaryService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MessagingService messagingService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    private static final String USE_REMOTE_DATA_DICTIONARY = "use.remote.data.dictionary";
    private final List<DataProviderDictionaryListener> listeners = new CopyOnWriteArrayList<DataProviderDictionaryListener>();
    private ClientSideDataProviderDictionaryBookkeeper bookkeeper;
    private final ConcurrentHashMap<AgentInfo, DataProviderDictionary> agentDictionaries = new ConcurrentHashMap();
    private DataProviderDictionary dataProviderDictionary = new DataProviderDictionaryImpl();
    private byte[] serializedDataProviderDictionary;
    private final DataProviderDictionaryCommands dictionaryCommands = new DataProviderDictionaryCommands();
    private AgentPresenceListener dictionaryServiceAgentPresenceManager;
    private volatile boolean canAddToDictionary = true;
    private long dictionaryChecksum = -1L;
    private RemoteDictionaryDAO remoteDAO;
    private volatile ConcurrentMessagingUtils cmu;
    private volatile boolean checkDataRegistration = true;
    private List<String> unregisteredData = new ArrayList<String>();
    private List<Integer> periodicData = new ArrayList<Integer>();
    private final Map<Integer, PublishedTrendingData> publishedTrendingData = new ConcurrentHashMap<Integer, PublishedTrendingData>();
    private ScheduledFuture<TrendingPublication> trendingPublicationFuture;
    private final List<AgentInfo> processingDictionaries = new CopyOnWriteArrayList<AgentInfo>();
    private final ReentrantLock dictionaryWaitLock = new ReentrantLock(true);
    private volatile LinkedHashMap<Condition, AgentInfo> dictionaryWaitList;
    private static final Map<Class<?>, Class<?>> WRAPPER_TYPE_MAP = new HashMap(16);

    @Override
    public String getAgentServiceName() {
        return "dataProviderDictionaryService";
    }

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        return agentInfo.isGraphicalConsole() || agentInfo.isAgentWorkerOrService();
    }

    @Override
    public void preBuild() {
        Properties p = BootstrapResourceUtils.getBootstrapSystemProperties();
        if (p.getProperty("org.lsst.ccs.remote.dictionary", "false").toLowerCase().equals("true")) {
            log.log(Level.INFO, "Using remote service for Data Dictionary");
            this.remoteDAO = new RemoteDictionaryDAO(this.agent.getDescription(), "dictionaries");
            this.agentPropertiesService.setAgentProperty(USE_REMOTE_DATA_DICTIONARY, "true");
        }
    }

    @Override
    public void init() {
        this.agentCommandDictionaryService.addCommandSetToObject(this.dictionaryCommands, this.agent);
    }

    private static boolean isServiceOrGraphicalConsole(AgentInfo agentInfo) {
        return agentInfo.getType().compareTo((Enum)AgentInfo.AgentType.SERVICE) >= 0 || agentInfo.isGraphicalConsole();
    }

    @Override
    public void afterInit() {
        String string;
        Object dataTypeAttr;
        TreeWalkerUtils.proceduralWalk(this.agent.getComponentLookup(), null, HasDataProviderInfos.class, hasDataProviderInfos -> {
            List<DataProviderInfo> sortedList = hasDataProviderInfos.getDataProviderInfos();
            for (DataProviderInfo dataProviderInfo : sortedList) {
                ((DataProviderDictionaryImpl)this.dataProviderDictionary).addDataProviderInfo(dataProviderInfo);
            }
        }, hasDataProviderInfos -> hasDataProviderInfos.finalizeDictionary());
        HashMap<String, ArrayList<DataProviderInfo>> pathOfConfigurationsWithoutUnitsMap = new HashMap<String, ArrayList<DataProviderInfo>>();
        for (DataProviderInfo dataProviderInfo : this.dataProviderDictionary.getDataProviderInfos()) {
            String dataTypeAttr2 = dataProviderInfo.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE);
            if (dataTypeAttr2 == null || !dataTypeAttr2.equals(DataProviderInfo.Type.CONFIGURATION.name()) || dataProviderInfo.getAttributeValue(DataProviderInfo.Attribute.UNITS) != null) continue;
            ArrayList<DataProviderInfo> configs = (ArrayList<DataProviderInfo>)pathOfConfigurationsWithoutUnitsMap.get(dataProviderInfo.getPath());
            if (configs == null) {
                configs = new ArrayList<DataProviderInfo>();
                pathOfConfigurationsWithoutUnitsMap.put(dataProviderInfo.getPath(), configs);
            }
            configs.add(dataProviderInfo);
        }
        for (Map.Entry entry : pathOfConfigurationsWithoutUnitsMap.entrySet()) {
            String path = (String)entry.getKey();
            String monitoringChannel = null;
            for (DataProviderInfo info : this.dataProviderDictionary.getDataProviderInfos()) {
                dataTypeAttr = info.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE);
                if (dataTypeAttr == null || !((String)dataTypeAttr).equals(DataProviderInfo.Type.MONITORING.name()) && !((String)dataTypeAttr).equals(DataProviderInfo.Type.TRENDING.name()) || !info.getPath().equals(path)) continue;
                monitoringChannel = info;
                break;
            }
            if (monitoringChannel == null || monitoringChannel.getAttributeValue(DataProviderInfo.Attribute.UNITS) == null) continue;
            for (DataProviderInfo configPar : (List)entry.getValue()) {
                configPar.addAttribute(DataProviderInfo.Attribute.UNITS, monitoringChannel.getAttributeValue(DataProviderInfo.Attribute.UNITS));
            }
        }
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        this.canAddToDictionary = false;
        switch (string = props.getProperty("org.lsst.ccs.datadictionary.server", "small")) {
            case "ordered": {
                Object d = new DataDictionaryOrdered(this.dataProviderDictionary);
                if (DataProviderDictionary.equals((DataProviderDictionary)d, (DataProviderDictionary)this.dataProviderDictionary, (boolean)true)) {
                    this.dataProviderDictionary = d;
                    break;
                }
                log.warning("Data dictionary conversion to ordered failed.");
                break;
            }
            case "small": {
                Object d = new DataDictionaryByType(this.dataProviderDictionary, data -> new DataDictionaryCompro((List<DataProviderInfo>)data));
                if (DataProviderDictionary.equals((DataProviderDictionary)d, (DataProviderDictionary)this.dataProviderDictionary, (boolean)false)) {
                    this.dataProviderDictionary = d;
                    break;
                }
                log.warning("Data dictionary conversion to small failed.");
            }
        }
        this.dictionaryChecksum = ChecksumUtils.evaluateChecksum((Object)this.dataProviderDictionary);
        AgentInfo agentInfo = this.agent.getAgentInfo();
        agentInfo.getAgentProperties().setProperty(this.getDictionaryChecksumProperty(), String.valueOf(this.dictionaryChecksum));
        String dictionaryType = null;
        if (agentInfo.isGraphicalConsole()) {
            dictionaryType = "console";
        } else if (agentInfo.isScriptingConsole()) {
            dictionaryType = "scripting";
        } else if (agentInfo.getType() == AgentInfo.AgentType.CONSOLE) {
            dictionaryType = "shell";
        }
        if (dictionaryType != null) {
            agentInfo.getAgentProperties().setProperty(this.getDictionaryTypeProperty(), dictionaryType);
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            dataTypeAttr = null;
            try (GZIPOutputStream gzipOut = new GZIPOutputStream(bos);){
                try (ObjectOutputStream oos = new ObjectOutputStream(gzipOut);){
                    oos.writeObject(this.dataProviderDictionary);
                    oos.flush();
                }
                this.serializedDataProviderDictionary = bos.toByteArray();
            }
            catch (Throwable throwable) {
                dataTypeAttr = throwable;
                throw throwable;
            }
            finally {
                if (bos != null) {
                    if (dataTypeAttr != null) {
                        try {
                            bos.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)dataTypeAttr).addSuppressed(throwable);
                        }
                    } else {
                        bos.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Problem serializing the dictionaries.", ioe);
        }
        if (DataProviderDictionaryService.isServiceOrGraphicalConsole(this.agent.getAgentInfo())) {
            this.bookkeeper = new ClientSideDataProviderDictionaryBookkeeper();
            this.messagingService.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this.bookkeeper, BusMessageFilterFactory.messageClass(StatusDataProviderDictionary.class));
            this.messagingService.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this.bookkeeper);
        }
        if (this.remoteDAO != null) {
            String dictionaryName = this.buildDataDictionaryName(agentInfo);
            if (this.bookkeeper != null) {
                this.bookkeeper.addCompressedDictionary(dictionaryName, this.serializedDataProviderDictionary);
            }
            try {
                this.remoteDAO.writeDictionaryIfNeeded(dictionaryName, this.serializedDataProviderDictionary);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Failed to save data dictionary to remote server.", e);
            }
        }
        if (this.agent.getAgentInfo().isAgentWorkerOrService()) {
            this.dictionaryServiceAgentPresenceManager = new DictionaryServiceAgentPresenceListener();
            this.messagingService.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(this.dictionaryServiceAgentPresenceManager);
        }
        if ("true".equals((String)this.agent.getComponentLookup().getTopComponentNode().getTag("writeDataDictionary"))) {
            DictionaryWriter.writeObjectToFile(this.serializedDataProviderDictionary, this.agent.getName() + "_dataDictionary.ser");
            System.exit(0);
        }
        this.agent.getScheduler().schedule(() -> {
            this.checkDataRegistration = false;
            return false;
        }, 5L, TimeUnit.MINUTES);
    }

    private String getDictionaryChecksumProperty() {
        return this.getClass().getSimpleName() + ":checksum";
    }

    private String getDictionaryTypeProperty() {
        return this.getClass().getSimpleName() + ":type";
    }

    private String buildDataDictionaryName(AgentInfo ai) {
        String dictType = ai.getAgentProperty(this.getDictionaryTypeProperty());
        String description = dictType != null ? dictType : ai.getAgentProperty("agentDescription");
        return "data/" + description + "/" + ai.getAgentProperty(this.getDictionaryChecksumProperty()) + ".ser";
    }

    public long getDictionaryChecksum() {
        return this.dictionaryChecksum;
    }

    @Override
    public void shutdown() {
        if (this.agent.getAgentInfo().isAgentWorkerOrService()) {
            this.messagingService.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener(this.dictionaryServiceAgentPresenceManager);
        }
    }

    public void addDataProviderInfoToDictionary(DataProviderInfo info) {
        if (!this.canAddToDictionary) {
            throw new RuntimeException("Cannot add to DataProviderDictionary after the HasLifecycle::init phase");
        }
        ((DataProviderDictionaryImpl)this.dataProviderDictionary).addDataProviderInfo(info);
    }

    public DataProviderDictionary getDataProviderDictionary() {
        return this.dataProviderDictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataProviderDictionary getDataProviderDictionaryForAgent(String agentName) {
        if (this.agent.getName().equals(agentName)) {
            return this.getDataProviderDictionary();
        }
        ConcurrentHashMap<AgentInfo, DataProviderDictionary> concurrentHashMap = this.agentDictionaries;
        synchronized (concurrentHashMap) {
            for (Map.Entry<AgentInfo, DataProviderDictionary> e : this.agentDictionaries.entrySet()) {
                if (!e.getKey().getName().equals(agentName)) continue;
                return e.getValue();
            }
        }
        return null;
    }

    public void addMetadataForObject(KeyValueDataList data, String metadataName, String metadataValue, Object origin) {
        ComponentNode n = this.agent.getComponentLookup().getComponentNodeForObject(origin);
        if (n == null) {
            throw new RuntimeException("Cannot publish metadata for an Object that is not in the lookup tree.");
        }
        data.addData(n.getPath() + "/" + metadataName, (Serializable)((Object)String.valueOf(metadataValue)), KeyValueData.KeyValueDataType.KeyValueMetaData);
    }

    @Deprecated
    public void purge(AgentInfo agent) {
    }

    @Deprecated
    public void purge() {
    }

    private void addDataProviderInfoForKeyValueData(KeyValueData kvd, List<DataProviderInfo> infos) {
        Serializable obj = kvd.getValue();
        String path = kvd.getKey();
        Class<?> clazz = obj.getClass();
        if (!(clazz.isPrimitive() || clazz.isArray() || clazz.equals(String.class) || Map.class.isAssignableFrom(clazz) || List.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || clazz.equals(BitSet.class) || clazz.equals(Boolean.class) || clazz.isEnum())) {
            infos.addAll(this.registerClass(clazz, path, Collections.EMPTY_LIST, Collections.EMPTY_LIST, obj));
        }
    }

    public void registerData(KeyValueData kvd, boolean isPeriodic) {
        Serializable value = kvd.getValue();
        ArrayList<DataProviderInfo> infos = new ArrayList<DataProviderInfo>();
        this.addDataProviderInfoForKeyValueData(kvd, infos);
        HashMap<String, DataProviderInfo> classDataInfo = new HashMap<String, DataProviderInfo>();
        for (DataProviderInfo info : infos) {
            classDataInfo.put(info.getFullPath(), info);
        }
        StatusSubsystemData ssd = new StatusSubsystemData(kvd);
        KeyValueDataList list = ssd.getEncodedData();
        for (KeyValueData d : list) {
            DataProviderInfo dataInfo;
            String path = d.getKey();
            String parentPath = null;
            int lastIndx = path.lastIndexOf("/");
            if (lastIndx > 0) {
                parentPath = path.substring(0, lastIndx);
            }
            if ((dataInfo = (DataProviderInfo)classDataInfo.get(path)) == null) {
                dataInfo = (DataProviderInfo)classDataInfo.get(parentPath);
            }
            this.doTheRegistration(d, dataInfo);
        }
        if (isPeriodic) {
            this.periodicData.add(this.calculateHashCodeForData(list));
        }
    }

    public void registerData(KeyValueData kvd) {
        this.registerData(kvd, false);
    }

    public void registerClass(Class clazz) {
        this.registerClass(clazz, "");
    }

    public void registerClass(Class clazz, String path) {
        List<DataProviderInfo> res = this.registerClass(clazz, path, Collections.EMPTY_LIST, Collections.EMPTY_LIST, null);
        for (DataProviderInfo info : res) {
            ((DataProviderDictionaryImpl)this.dataProviderDictionary).addDataProviderInfo(info);
        }
    }

    private List<DataProviderInfo> registerClass(Class clazz, String path, List<Annotation> inputClassAttributes, List<Annotation> inputClassTrend, Object obj) {
        ArrayList<DataProviderInfo> result = new ArrayList<DataProviderInfo>();
        if (!this.canAddToDictionary) {
            throw new RuntimeException("Cannot register a Class after the HasLifecycle::init phase");
        }
        if (!path.isEmpty() && !path.endsWith("/")) {
            path = path + "/";
        }
        List<Field> dataFields = this.getDataFieldsForClass(clazz);
        List<Annotation> classAttributes = this.getAnnotationsForClass(clazz, DataAttributes.class);
        classAttributes.addAll(inputClassAttributes);
        List<Annotation> classTrend = this.getAnnotationsForClass(clazz, DoNotTrend.class);
        classTrend.addAll(inputClassTrend);
        for (Field f : dataFields) {
            DataAttributes attributes = f.getAnnotation(DataAttributes.class);
            DoNotTrend trend = f.getAnnotation(DoNotTrend.class);
            String dataName = f.getName();
            if (dataName.startsWith("this$")) continue;
            String fullPath = !path.isEmpty() ? path + dataName : dataName;
            DataProviderInfo info = new DataProviderInfo(fullPath, DataProviderInfo.Type.TRENDING, fullPath);
            String units = "";
            String description = "";
            if (attributes != null) {
                if (!attributes.units().isEmpty()) {
                    units = attributes.units();
                }
                if (!attributes.description().isEmpty()) {
                    description = attributes.description();
                }
            }
            if (!classAttributes.isEmpty()) {
                ListIterator<Annotation> iter = classAttributes.listIterator(classAttributes.size());
                while (iter.hasPrevious()) {
                    DataAttributes attr = (DataAttributes)iter.previous();
                    if (units.isEmpty()) {
                        units = attr.units();
                    }
                    if (!description.isEmpty()) continue;
                    description = attr.description();
                }
            }
            if (!units.isEmpty()) {
                info.addAttribute(DataProviderInfo.Attribute.UNITS, units);
            }
            if (!description.isEmpty()) {
                info.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, description);
            }
            if (trend != null || !classTrend.isEmpty()) {
                info.addAttribute(DataProviderInfo.Attribute.DO_NOT_TREND, "true");
            }
            Type fieldType = f.getGenericType();
            info.addAttribute(DataProviderInfo.Attribute.TYPE, fieldType.getTypeName());
            Class<?> fieldClass = f.getType();
            if (!(fieldClass.isPrimitive() || fieldClass.isArray() || fieldClass.equals(String.class) || Map.class.isAssignableFrom(fieldClass) || List.class.isAssignableFrom(fieldClass) || Number.class.isAssignableFrom(fieldClass) || fieldClass.equals(BitSet.class) || fieldClass.equals(Boolean.class) || fieldClass.isEnum())) {
                String innerClassPath = path + "/" + dataName;
                innerClassPath = innerClassPath.replace("//", "/");
                Object fieldObj = null;
                try {
                    if (obj != null) {
                        fieldObj = f.get(obj);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                result.addAll(this.registerClass(fieldClass, innerClassPath, classAttributes, classTrend, fieldObj));
            } else {
                result.add(info);
            }
            if (obj == null || !Map.class.isAssignableFrom(fieldClass)) continue;
            try {
                f.setAccessible(true);
                Map map = (Map)f.get(obj);
                for (Object key : map.keySet()) {
                    Object val = map.get(key);
                    String innerClassPath = path + "/" + dataName + "/" + key;
                    innerClassPath = innerClassPath.replace("//", "/");
                    result.addAll(this.registerClass(val.getClass(), innerClassPath, classAttributes, classTrend, val));
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
        }
        return result;
    }

    private List<Field> getDataFieldsForClass(Class clazz) {
        Field[] fields;
        ArrayList<Field> listFields = new ArrayList<Field>();
        if (clazz.getAnnotation(SkipEncoding.class) != null) {
            return listFields;
        }
        Class superClazz = clazz.getSuperclass();
        if (superClazz != null && !Object.class.equals(superClazz)) {
            listFields.addAll(this.getDataFieldsForClass(superClazz));
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            int modifiers;
            if (field.getAnnotation(SkipEncoding.class) != null || Modifier.isStatic(modifiers = field.getModifiers()) || Modifier.isTransient(modifiers)) continue;
            listFields.add(field);
        }
        return listFields;
    }

    private List<Annotation> getAnnotationsForClass(Class clazz, Class annotationClazz) {
        Object a;
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        Class superClazz = clazz.getSuperclass();
        if (superClazz != null && !Object.class.equals(superClazz)) {
            annotations.addAll(this.getAnnotationsForClass(superClazz, annotationClazz));
        }
        if ((a = clazz.getAnnotation(annotationClazz)) != null) {
            annotations.add((Annotation)a);
        }
        return annotations;
    }

    private void doTheRegistration(KeyValueData kvd, DataProviderInfo classDataInfo) {
        Serializable value;
        DataProviderInfo info = new DataProviderInfo(kvd.getKey(), DataProviderInfo.Type.TRENDING, kvd.getKey());
        if (classDataInfo != null) {
            for (DataProviderInfo.Attribute attr : classDataInfo.getAttributes()) {
                info.addAttribute(attr, classDataInfo.getAttributeValue(attr));
            }
        }
        if ((value = kvd.getValue()) != null) {
            try {
                Class cls = DataProviderDictionaryService.getBasicTypeFromWrapper(value.getClass());
                info.addAttribute(DataProviderInfo.Attribute.TYPE, cls.getTypeName());
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Exception when registering data type for path: " + kvd.getKey() + ".", e);
            }
        } else {
            log.log(Level.WARNING, "Registering null value when registering path {0}. Cannot determine its type", kvd.getKey());
        }
        ((DataProviderDictionaryImpl)this.dataProviderDictionary).addDataProviderInfo(info);
    }

    public void publishingTrendingData(StatusSubsystemData ssd) {
        this.agent.getScheduler().schedule(() -> this.processTrendingData(ssd, System.currentTimeMillis()), 0L, TimeUnit.NANOSECONDS);
    }

    public int calculateHashCodeForData(StatusSubsystemData ssd) {
        return this.calculateHashCodeForData(ssd.getEncodedData());
    }

    public int calculateHashCodeForData(KeyValueDataList kvdl) {
        int hashCode = 0;
        for (KeyValueData kvd : kvdl) {
            if (kvd.getType().equals((Object)KeyValueData.KeyValueDataType.KeyValueMetaData)) continue;
            hashCode += kvd.getKey().hashCode();
        }
        return hashCode;
    }

    private void processTrendingData(StatusSubsystemData data, long published) {
        if (!this.checkDataRegistration) {
            return;
        }
        KeyValueDataList dataList = data.getEncodedData();
        ArrayList<String> dataToRegister = new ArrayList<String>();
        for (KeyValueData kvd : dataList) {
            String dataKey;
            if (kvd.getType().equals((Object)KeyValueData.KeyValueDataType.KeyValueMetaData) || this.getDataProviderDictionary().getDataProviderInfoForPath(kvd.getKey()) != null || this.unregisteredData.contains(dataKey = kvd.getKey())) continue;
            dataToRegister.add(dataKey);
            this.unregisteredData.add(dataKey);
        }
        if (!dataToRegister.isEmpty()) {
            log.log(Level.WARNING, "The following data has not been registered with the Data Dictionary: {0}\nTo register the data use method DataProviderDictionaryService::registerData(KeyValueData) before or during the HasLifetime::init phase.", dataToRegister);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePublishedInformation(int hashCode, KeyValueData data, long publishedMillis) {
        this.updatePublishedInformation(hashCode, data, publishedMillis);
        Map<Integer, PublishedTrendingData> map = this.publishedTrendingData;
        synchronized (map) {
            if (!this.publishedTrendingData.containsKey(hashCode)) {
                log.log(Level.WARNING, "Added new keyValueData for key " + data.getKey() + " with hash " + hashCode + " new size: " + (this.publishedTrendingData.size() + 1));
            }
            this.publishedTrendingData.computeIfAbsent(hashCode, hc -> new PublishedTrendingData(data, publishedMillis)).updateInnerData(data, publishedMillis);
            log.log(Level.INFO, "Updated hashCode: " + hashCode + " published at " + publishedMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataProviderDictionaryListener(DataProviderDictionaryListener listener) {
        ConcurrentHashMap<AgentInfo, DataProviderDictionary> concurrentHashMap = this.agentDictionaries;
        synchronized (concurrentHashMap) {
            for (Map.Entry<AgentInfo, DataProviderDictionary> entry : this.agentDictionaries.entrySet()) {
                listener.dataProviderDictionaryUpdate(new DataProviderDictionaryEvent(entry.getKey(), DataProviderDictionaryEvent.EventType.ADDED, entry.getValue()));
            }
            this.listeners.add(listener);
        }
    }

    public void removeDataProviderDictionaryListener(DataProviderDictionaryListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyDataProviderDictionaryListeners(DataProviderDictionaryEvent evt) {
        for (DataProviderDictionaryListener listener : this.listeners) {
            try {
                listener.dataProviderDictionaryUpdate(evt);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Caught exception notifying dictionary listerer " + listener.getClass(), e);
            }
        }
    }

    public Bus getBus() {
        return Bus.STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusMessage preProcessMessage(BusMessage msg) {
        AgentInfo ai = msg.getOriginAgentInfo();
        if (!this.agent.getName().equals(ai.getName()) && this.remoteDAO != null && !this.agentDictionaries.containsKey(ai)) {
            log.log(Level.FINE, "Data: Processing message for {0}", ai.getName());
            if ((ai.isAgentWorkerOrService() || ai.isGraphicalConsole()) && ai.getAgentProperty(USE_REMOTE_DATA_DICTIONARY, "false").equals("true")) {
                List<AgentInfo> list = this.processingDictionaries;
                synchronized (list) {
                    if (this.processingDictionaries.contains(ai)) {
                        return msg;
                    }
                    this.processingDictionaries.add(ai);
                }
                this.agent.getScheduler().schedule(() -> {
                    log.log(Level.FINE, "Data: Scheduling dict fetching for {0} ", new Object[]{ai.getName()});
                    StatusDataProviderDictionary statusMsg = this.bookkeeper.getDataProviderDictionaryForAgent(ai);
                    long start = System.currentTimeMillis();
                    DataProviderDictionary dict = statusMsg.getDataProviderDictionary();
                    long delta = System.currentTimeMillis() - start;
                    log.log(Level.FINE, "Data: Unzipping the dictionary for {0} took {1} ms.", new Object[]{ai.getName(), delta});
                    if (dict != null) {
                        this.bookkeeper.addDataProviderDictionary(ai, dict);
                    } else {
                        log.log(Level.FINE, "Data: Requesting data dictionary for agent {0}", ai.getName());
                        this.bookkeeper.getConcurrentMessagingUtils().sendAsynchronousCommand(new CommandRequest(ai.getName(), "publishDataProviderDictionary"));
                    }
                }, 0L, TimeUnit.NANOSECONDS);
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DataProviderDictionary waitForAgentDictionary(AgentInfo agentInfo, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.agent.getName().equals(agentInfo.getName())) {
            return this.getDataProviderDictionary();
        }
        if (!this.processingDictionaries.contains(agentInfo)) {
            return this.agentDictionaries.get(agentInfo);
        }
        long start = System.currentTimeMillis();
        long deadline = TimeUnit.MILLISECONDS.convert(timeout, unit) + System.currentTimeMillis();
        if (!this.dictionaryWaitLock.tryLock(timeout, unit)) {
            return this.agentDictionaries.get(agentInfo);
        }
        try {
            DataProviderDictionary dict = this.agentDictionaries.get(agentInfo);
            if (dict != null) {
                long delta = System.currentTimeMillis() - start;
                log.log(Level.FINE, "Data: Dictionary wait: returning dictionary immediately in {0} ms", delta);
                DataProviderDictionary dataProviderDictionary = dict;
                return dataProviderDictionary;
            }
            Condition condition = this.dictionaryWaitLock.newCondition();
            if (this.dictionaryWaitList == null) {
                this.dictionaryWaitList = new LinkedHashMap(20);
            }
            this.dictionaryWaitList.put(condition, agentInfo);
            while (this.dictionaryWaitList != null && this.dictionaryWaitList.containsKey(condition) && condition.await(timeout = deadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS)) {
            }
        }
        finally {
            this.dictionaryWaitLock.unlock();
        }
        long delta = System.currentTimeMillis() - start;
        log.log(Level.FINE, "Data: Dictionary wait for {0}: returning dictionary after wait in {1} ms", new Object[]{agentInfo.getName(), delta});
        return this.agentDictionaries.get(agentInfo);
    }

    private void dictionaryWaitNotify(AgentInfo ai) {
        this.agent.getScheduler().schedule(() -> {
            try {
                this.dictionaryWaitLock.lockInterruptibly();
                try {
                    if (this.dictionaryWaitList == null) {
                        return;
                    }
                    Iterator<Map.Entry<Condition, AgentInfo>> it = this.dictionaryWaitList.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<Condition, AgentInfo> entry = it.next();
                        AgentInfo agentInfo = entry.getValue();
                        if (!ai.equals((Object)agentInfo)) continue;
                        entry.getKey().signal();
                        it.remove();
                    }
                    if (this.dictionaryWaitList.isEmpty()) {
                        this.dictionaryWaitList = null;
                    }
                }
                finally {
                    this.dictionaryWaitLock.unlock();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }, 0L, TimeUnit.NANOSECONDS);
    }

    private static Class getBasicTypeFromWrapper(Class cls) {
        if (WRAPPER_TYPE_MAP.containsKey(cls)) {
            return WRAPPER_TYPE_MAP.get(cls);
        }
        return cls;
    }

    static {
        WRAPPER_TYPE_MAP.put(Integer.class, Integer.TYPE);
        WRAPPER_TYPE_MAP.put(Byte.class, Byte.TYPE);
        WRAPPER_TYPE_MAP.put(Character.class, Character.TYPE);
        WRAPPER_TYPE_MAP.put(Boolean.class, Boolean.TYPE);
        WRAPPER_TYPE_MAP.put(Double.class, Double.TYPE);
        WRAPPER_TYPE_MAP.put(Float.class, Float.TYPE);
        WRAPPER_TYPE_MAP.put(Long.class, Long.TYPE);
        WRAPPER_TYPE_MAP.put(Short.class, Short.TYPE);
        WRAPPER_TYPE_MAP.put(Void.class, Void.TYPE);
    }

    private class ClientSideDataProviderDictionaryBookkeeper
    implements StatusMessageListener,
    AgentPresenceListener {
        private final String dictionaryImplementation = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.datadictionary.client", "");
        private final Map<String, byte[]> compressedDicts = new ConcurrentHashMap<String, byte[]>();

        private ClientSideDataProviderDictionaryBookkeeper() {
        }

        protected void addCompressedDictionary(String dictionaryName, byte[] dict) {
            this.compressedDicts.put(dictionaryName, dict);
        }

        private StatusDataProviderDictionary getDataProviderDictionaryForAgent(AgentInfo ai) {
            String dictionaryName = DataProviderDictionaryService.this.buildDataDictionaryName(ai);
            byte[] dict = this.compressedDicts.get(dictionaryName);
            if (dict != null) {
                log.log(Level.FINE, "Data: Dictionary already present for {0}", ai.getName());
            } else {
                long start = System.currentTimeMillis();
                try {
                    dict = DataProviderDictionaryService.this.remoteDAO.getDictionary(dictionaryName);
                    this.addCompressedDictionary(dictionaryName, dict);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                long delta = System.currentTimeMillis() - start;
                log.log(Level.FINE, "Data: Fetching data dicionary from remote server for {0} took {1} ms", new Object[]{ai.getName(), delta});
            }
            if (dict != null) {
                StatusDataProviderDictionary msg = new StatusDataProviderDictionary(dict, "gzip");
                msg.setOriginAgentInfo(ai);
                return msg;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnected(AgentInfo ... agents) {
            ConcurrentHashMap concurrentHashMap = DataProviderDictionaryService.this.agentDictionaries;
            synchronized (concurrentHashMap) {
                for (AgentInfo agent : agents) {
                    DataProviderDictionary dict = (DataProviderDictionary)DataProviderDictionaryService.this.agentDictionaries.remove(agent);
                    log.log(Level.FINE, "Data: Removed data dictionary for {0} null={1}", new Object[]{agent.getName(), dict == null});
                    if (dict == null) continue;
                    DataProviderDictionaryService.this.notifyDataProviderDictionaryListeners(new DataProviderDictionaryEvent(agent, DataProviderDictionaryEvent.EventType.REMOVED, dict));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStatusMessage(StatusMessage msg) {
            if (DataProviderDictionaryService.this.agent.getName().equals(msg.getOriginAgentInfo().getName())) {
                return;
            }
            AgentInfo agentInfo = msg.getOriginAgentInfo();
            ConcurrentHashMap concurrentHashMap = DataProviderDictionaryService.this.agentDictionaries;
            synchronized (concurrentHashMap) {
                DataProviderDictionary dict;
                if (!DataProviderDictionaryService.this.agentDictionaries.containsKey(agentInfo) && (dict = ((StatusDataProviderDictionary)msg).getDataProviderDictionary()) != null) {
                    this.addDataProviderDictionary(agentInfo, dict);
                }
            }
        }

        private ConcurrentMessagingUtils getConcurrentMessagingUtils() {
            if (DataProviderDictionaryService.this.cmu == null) {
                DataProviderDictionaryService.this.cmu = new ConcurrentMessagingUtils(DataProviderDictionaryService.this.agent.getMessagingAccess());
            }
            return DataProviderDictionaryService.this.cmu;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addDataProviderDictionary(AgentInfo agent, DataProviderDictionary dictionary) {
            ConcurrentHashMap concurrentHashMap = DataProviderDictionaryService.this.agentDictionaries;
            synchronized (concurrentHashMap) {
                if (!DataProviderDictionaryService.this.agentDictionaries.containsKey(agent)) {
                    switch (this.dictionaryImplementation) {
                        case "small": {
                            if (dictionary instanceof DataDictionaryByType) break;
                            log.log(Level.FINE, "Data: Converting data dictionary for {0} from {1} to DataDictionaryByType<DataDictionaryCompro>", new Object[]{agent.getName(), dictionary.getClass().getSimpleName()});
                            dictionary = new DataDictionaryByType(dictionary, data -> new DataDictionaryCompro((List<DataProviderInfo>)data));
                            break;
                        }
                        case "fast": {
                            if (dictionary instanceof DataProviderDictionaryImpl) break;
                            log.log(Level.FINE, "Data: Converting data dictionary for {0} from {1} to DataProviderDictionaryImpl", new Object[]{agent.getName(), dictionary.getClass().getSimpleName()});
                            DataProviderDictionaryImpl dict = new DataProviderDictionaryImpl();
                            dictionary.getDataProviderInfos().forEach(dpi -> dict.addDataProviderInfo((DataProviderInfo)dpi));
                            break;
                        }
                        default: {
                            log.log(Level.FINE, "Data: Storing data dictionary of type {0} from {1}", new Object[]{dictionary.getClass().getSimpleName(), agent.getName()});
                        }
                    }
                    DataProviderDictionaryService.this.agentDictionaries.put(agent, dictionary);
                    DataProviderDictionaryService.this.agentDictionaries.notifyAll();
                    DataProviderDictionaryService.this.notifyDataProviderDictionaryListeners(new DataProviderDictionaryEvent(agent, DataProviderDictionaryEvent.EventType.ADDED, dictionary));
                    DataProviderDictionaryService.this.dictionaryWaitNotify(agent);
                    DataProviderDictionaryService.this.processingDictionaries.remove(agent);
                }
            }
        }
    }

    public static class DataProviderDictionaryEvent {
        private final EventType eventType;
        private final AgentInfo agentInfo;
        private final DataProviderDictionary dictionary;

        DataProviderDictionaryEvent(AgentInfo agentInfo, EventType eventType, DataProviderDictionary dictionary) {
            this.eventType = eventType;
            this.agentInfo = agentInfo;
            this.dictionary = dictionary;
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public AgentInfo getAgentInfo() {
            return this.agentInfo;
        }

        public DataProviderDictionary getDictionary() {
            return this.dictionary;
        }

        public static enum EventType {
            ADDED,
            REMOVED;

        }
    }

    public static interface DataProviderDictionaryListener {
        public void dataProviderDictionaryUpdate(DataProviderDictionaryEvent var1);
    }

    class DictionaryServiceAgentPresenceListener
    implements AgentPresenceListener {
        private boolean forcePublication;

        DictionaryServiceAgentPresenceListener() {
            boolean bl = DataProviderDictionaryService.this.remoteDAO != null ? !DataProviderDictionaryService.this.remoteDAO.isDictionaryAvailable(DataProviderDictionaryService.this.buildDataDictionaryName(DataProviderDictionaryService.this.agent.getAgentInfo())) : (this.forcePublication = true);
            if (this.forcePublication) {
                log.log(Level.INFO, "There will be forced publication of the Data Dictionary");
            }
        }

        public void connecting(AgentInfo ... agents) {
            for (AgentInfo info : agents) {
                if (!DataProviderDictionaryService.isServiceOrGraphicalConsole(info) || info.getAgentProperty(DataProviderDictionaryService.USE_REMOTE_DATA_DICTIONARY, "false").equals("true") && !this.forcePublication) continue;
                log.log(Level.INFO, "Spontaneous publication of full data dictionary for agent {0}", new Object[]{info.getName()});
                DataProviderDictionaryService.this.dictionaryCommands.publishDataProviderDictionaryForAgent();
                return;
            }
        }

        public void connected(AgentInfo ... agents) {
            for (AgentInfo info : agents) {
                if (!DataProviderDictionaryService.isServiceOrGraphicalConsole(info)) continue;
                DataProviderDictionaryService.this.dictionaryCommands.publishDataProviderCurrentDataForAgent(agents);
                return;
            }
        }
    }

    public class DataProviderDictionaryCommands {
        private void publishDataProviderDictionaryForAgent() {
            if (DataProviderDictionaryService.this.serializedDataProviderDictionary == null) {
                throw new RuntimeException("The DataProviderInfo dictionary is not ready yet for publication");
            }
            DataProviderDictionaryService.this.agent.sendStatusMessage((StatusMessage)new StatusDataProviderDictionary(DataProviderDictionaryService.this.serializedDataProviderDictionary, "gzip"));
        }

        @Command(description="Publish on the status bus the Agent's dictionary of data.", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public void publishDataProviderDictionary() {
            this.publishDataProviderDictionaryForAgent();
            this.publishDataProviderCurrentDataForAgent(new AgentInfo[0]);
        }

        private void publishDataProviderCurrentDataForAgent(AgentInfo ... agentInfos) {
            TreeWalkerUtils.proceduralWalk(DataProviderDictionaryService.this.agent.getComponentLookup(), null, HasDataProviderInfos.class, hasDataProviderInfos -> hasDataProviderInfos.publishDataProviderCurrentData(agentInfos), null);
        }

        @Command(description="Publish on the status bus the Agent's current data.", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public void publishDataProviderCurrentData() {
            this.publishDataProviderCurrentDataForAgent(new AgentInfo[0]);
        }

        @Command(description="Show the trending data in a group", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
        public String printDataProviderDictionary() {
            StringBuilder sb = new StringBuilder();
            for (DataProviderInfo info : DataProviderDictionaryService.this.dataProviderDictionary.getDataProviderInfos()) {
                sb.append(info.toString()).append("\n");
            }
            return sb.toString();
        }
    }

    private class TrendingPublication
    implements Callable {
        private volatile boolean terminated = false;
        private final long requestedPublication = System.currentTimeMillis();

        private TrendingPublication() {
        }

        public Object call() throws Exception {
            int count = 0;
            for (Map.Entry e : DataProviderDictionaryService.this.publishedTrendingData.entrySet()) {
                if (this.terminated) {
                    return null;
                }
                PublishedTrendingData ptd = (PublishedTrendingData)e.getValue();
                if (ptd.getPublishedMillis() > this.requestedPublication) {
                    log.log(Level.INFO, "Skipping publication for : " + ptd.getPublishedData().getKey() + ": already published.");
                    continue;
                }
                DataProviderDictionaryService.this.agent.publishMonitoringDataOnStatusBus(((PublishedTrendingData)e.getValue()).getPublishedData());
                ++count;
                DataProviderDictionaryService.this.updatePublishedInformation((Integer)e.getKey(), ptd.getPublishedData(), System.currentTimeMillis());
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            log.log(Level.INFO, "Forced publication of " + count + " trending messages.");
            return null;
        }

        void terminate() {
            this.terminated = true;
        }
    }

    private class PublishedTrendingData {
        private volatile KeyValueData data;
        private volatile long publishedMillis;

        PublishedTrendingData(KeyValueData data, long publishedMillis) {
            this.updateInnerData(data, publishedMillis);
        }

        KeyValueData getPublishedData() {
            return this.data;
        }

        long getPublishedMillis() {
            return this.publishedMillis;
        }

        final void updateInnerData(KeyValueData data, long publishedMillis) {
            this.data = data;
            this.publishedMillis = publishedMillis;
        }
    }
}

