/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.vacuum.states;

public enum TurboState {
    STOP("Pump not running"),
    WAIT_INTLK("Pump blocked by external interlock"),
    STARTING("Pump speeding up from stop to normal"),
    AUTOTUNING("Pump frequency reduced due to stress"),
    BRAKING("Pump braking"),
    NORMAL("Pump running at requested setting"),
    FAIL("Pump failure, check failure code");

    private final String description;

    private TurboState(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static TurboState getState(int ord) {
        TurboState state = null;
        for (TurboState st : TurboState.values()) {
            if (st.ordinal() != ord) continue;
            state = st;
            break;
        }
        if (state == null) {
            throw new IllegalArgumentException("Invalid Turbo Status value " + ord + " for TurboState.getState");
        }
        return state;
    }
}

