/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.utilities;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.Agent;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.daq.utilities.FitsHeaderKeywordData;

public class FitsServiceHeaderCommands {
    private final Agent agent;

    public FitsServiceHeaderCommands(Agent agent) {
        this.agent = agent;
    }

    @Command(type=Command.CommandType.ACTION, description="Set a header keyword value shared by all extensions")
    public void setHeaderKeyword(String name, Serializable value) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(name, value);
        this.setNamedHeaderKeywords("all", map);
    }

    @Command(type=Command.CommandType.ACTION, description="Set a header keyword value shared by all extensions")
    public void setHeaderKeywords(Map<String, Serializable> headersMap) {
        this.setNamedHeaderKeywords("all", headersMap);
    }

    @Command(type=Command.CommandType.ACTION, description="Set a primary header keyword value")
    public void setPrimaryHeaderKeyword(String name, Serializable value) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(name, value);
        this.setNamedHeaderKeywords("primary", map);
    }

    @Command(type=Command.CommandType.ACTION, description="Set primary header keyword values")
    public void setPrimaryHeaderKeywords(Map<String, Serializable> headersMap) {
        this.setNamedHeaderKeywords("primary", headersMap);
    }

    @Command(type=Command.CommandType.ACTION, description="Set a header keyword value for a given CCD extension")
    public void setHeaderKeywordForCCD(String ccdId, String name, Serializable value, @Argument(defaultValue="false") boolean sticky) {
        FitsHeaderKeywordData data = new FitsHeaderKeywordData(ccdId);
        data.addHeaderKeywordValue(ccdId, name, value, sticky);
        this.agent.publishSubsystemDataOnStatusBus(data.getKeyValueData());
    }

    @Command(type=Command.CommandType.ACTION, description="Set header keyword values on a named HDU")
    public void setNamedHeaderKeywords(String hduName, Map<String, Serializable> headersMap) {
        FitsHeaderKeywordData data = new FitsHeaderKeywordData();
        for (Map.Entry<String, Serializable> e : headersMap.entrySet()) {
            data.addHeaderKeywordValue(hduName, e.getKey(), e.getValue(), false);
        }
        this.agent.publishSubsystemDataOnStatusBus(data.getKeyValueData());
    }
}

