/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.data;

import java.io.Serializable;
import org.lsst.ccs.drivers.reb.Status;

public class StatusData
implements Serializable {
    private final int version;
    private final int linkStat;
    private final int cerrCount;
    private final int ldwnCount;
    private final int lerrCount;
    private final int buffStat;
    private final int[] rxCount = new int[4];
    private final int[] txCount = new int[4];
    private final int sentCount;
    private final int discCount;
    private final int truncCount;
    private final int format;
    private static final long serialVersionUID = 1862820319013212211L;

    public StatusData(Status stat) {
        this.version = stat.getVersion();
        this.linkStat = stat.getLinkStatus();
        this.cerrCount = stat.getCellErrorCount();
        this.ldwnCount = stat.getLinkDownCount();
        this.lerrCount = stat.getLinkErrorCount();
        this.buffStat = stat.getVcBufferStatus();
        System.arraycopy(stat.getVcRxCounts(), 0, this.rxCount, 0, this.rxCount.length);
        System.arraycopy(stat.getVcTxCounts(), 0, this.txCount, 0, this.txCount.length);
        this.sentCount = stat.getSentCount();
        this.discCount = stat.getDiscCount();
        this.truncCount = stat.getTruncCount();
        this.format = stat.getFormat();
    }

    public String toString() {
        int j;
        StringBuilder str = new StringBuilder("Status Block:\n");
        str.append(String.format("  Version            = %08x  ", this.version));
        str.append(String.format("  Link Status        = %08x\n", this.linkStat));
        str.append(String.format("  Cell error count   = %-8s  ", this.cerrCount));
        str.append(String.format("  Link down count    = %s\n", this.ldwnCount));
        str.append(String.format("  Link error count   = %-8s  ", this.lerrCount));
        str.append(String.format("  VC buffer status   = %08x\n", this.buffStat));
        str.append(String.format("  VC rcve counts     =", new Object[0]));
        for (j = 0; j < this.rxCount.length; ++j) {
            str.append(String.format(" %s", this.rxCount[j]));
        }
        str.append("\n");
        str.append(String.format("  VC xmit counts     =", new Object[0]));
        for (j = 0; j < this.txCount.length; ++j) {
            str.append(String.format(" %s", this.txCount[j]));
        }
        str.append("\n");
        str.append(String.format("  Sent image count   = %-8s  ", this.sentCount));
        str.append(String.format("  Disc. image count  = %s\n", this.discCount));
        str.append(String.format("  Trunc. image count = %-8s  ", this.truncCount));
        str.append(String.format("  Image format       = %s", this.format));
        return str.toString();
    }
}

