/*
 * Decompiled with CFR 0.152.
 */
package DDS;

import DDS.DataReaderQosHolder;
import DDS.DataWriterQosHolder;
import DDS.DomainParticipantFactory;
import DDS.DomainParticipantQosHolder;
import DDS.NamedDataReaderQosHolder;
import DDS.NamedDataWriterQosHolder;
import DDS.NamedDomainParticipantQosHolder;
import DDS.NamedPublisherQosHolder;
import DDS.NamedSubscriberQosHolder;
import DDS.NamedTopicQosHolder;
import DDS.PublisherQosHolder;
import DDS.QosProviderInterface;
import DDS.SubscriberQosHolder;
import DDS.TopicQosHolder;
import java.io.Closeable;
import java.io.IOException;
import org.opensplice.dds.dcps.QosProviderBase;

public class QosProvider
extends QosProviderBase
implements QosProviderInterface,
Closeable {
    private static final long serialVersionUID = -4512906977859245929L;
    private long qosProviderObject = 0L;

    public QosProvider(String uri, String profile) throws NullPointerException {
        long qosProvider = 0L;
        qosProvider = this.jniQosProviderNew(uri, profile);
        if (qosProvider == 0L) {
            throw new NullPointerException("Could not create QosProvider; jniQosProviderNew(...) failed.");
        }
        this.qosProviderObject = qosProvider;
    }

    @Override
    public int get_participant_qos(DomainParticipantQosHolder participantQos, String id) {
        int result;
        if (participantQos == null) {
            result = 3;
        } else {
            NamedDomainParticipantQosHolder qos = new NamedDomainParticipantQosHolder();
            result = this.jniGetParticipantQos(this.qosProviderObject, qos, id);
            if (result == 0) {
                participantQos.value = qos.value.domainparticipant_qos;
            }
        }
        return result;
    }

    @Override
    public int get_topic_qos(TopicQosHolder topicQos, String id) {
        int result;
        if (topicQos == null) {
            result = 3;
        } else {
            NamedTopicQosHolder qos = new NamedTopicQosHolder();
            result = this.jniGetTopicQos(this.qosProviderObject, qos, id);
            if (result == 0) {
                topicQos.value = qos.value.topic_qos;
            }
        }
        return result;
    }

    @Override
    public int get_subscriber_qos(SubscriberQosHolder subscriberQos, String id) {
        int result;
        if (subscriberQos == null) {
            result = 3;
        } else {
            NamedSubscriberQosHolder qos = new NamedSubscriberQosHolder();
            result = this.jniGetSubscriberQos(this.qosProviderObject, qos, id);
            if (result == 0) {
                subscriberQos.value = qos.value.subscriber_qos;
            }
        }
        return result;
    }

    @Override
    public int get_datareader_qos(DataReaderQosHolder datareaderQos, String id) {
        int result;
        if (datareaderQos == null) {
            result = 3;
        } else {
            NamedDataReaderQosHolder qos = new NamedDataReaderQosHolder();
            result = this.jniGetDatareaderQos(this.qosProviderObject, qos, id);
            if (result == 0) {
                datareaderQos.value = qos.value.datareader_qos;
            }
        }
        return result;
    }

    @Override
    public int get_publisher_qos(PublisherQosHolder publisherQos, String id) {
        int result;
        if (publisherQos == null) {
            result = 3;
        } else {
            NamedPublisherQosHolder qos = new NamedPublisherQosHolder();
            result = this.jniGetPublisherQos(this.qosProviderObject, qos, id);
            if (result == 0) {
                publisherQos.value = qos.value.publisher_qos;
            }
        }
        return result;
    }

    @Override
    public int get_datawriter_qos(DataWriterQosHolder datawriterQos, String id) {
        int result;
        if (datawriterQos == null) {
            result = 3;
        } else {
            NamedDataWriterQosHolder qos = new NamedDataWriterQosHolder();
            result = this.jniGetDatawriterQos(this.qosProviderObject, qos, id);
            if (result == 0) {
                datawriterQos.value = qos.value.datawriter_qos;
            }
        }
        return result;
    }

    private native long jniQosProviderNew(String var1, String var2);

    private native void jniQosProviderFree(long var1);

    private native int jniGetParticipantQos(long var1, NamedDomainParticipantQosHolder var3, String var4);

    private native int jniGetTopicQos(long var1, NamedTopicQosHolder var3, String var4);

    private native int jniGetSubscriberQos(long var1, NamedSubscriberQosHolder var3, String var4);

    private native int jniGetDatareaderQos(long var1, NamedDataReaderQosHolder var3, String var4);

    private native int jniGetPublisherQos(long var1, NamedPublisherQosHolder var3, String var4);

    private native int jniGetDatawriterQos(long var1, NamedDataWriterQosHolder var3, String var4);

    @Override
    public void close() throws IOException {
        this.jniQosProviderFree(this.qosProviderObject);
        this.qosProviderObject = 0L;
    }

    static {
        DomainParticipantFactory.get_instance();
    }
}

