/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.sal.xml.maker;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpressionException;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.sal.classes.SALClassDescriptionMaker;
import org.lsst.ccs.camera.sal.xml.MakeXMLConfiguration;
import org.lsst.ccs.camera.sal.xml.XMLMaker2;
import org.lsst.ccs.camera.sal.xml.maker.OrderedProperties;
import org.lsst.ccs.camera.sal.xml.maker.XMLUtils;
import org.lsst.ccs.camera.sal.xml.util.ChecksumExtractorUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class MakeAllXML {
    private static final Logger LOG = Logger.getLogger(MakeAllXML.class.getName());

    public static void main(String[] args) throws Exception {
        System.setProperty("no.missing.sal.class.warning", "true");
        File outputLocation = new File(args[0]);
        File checksumOutputLocation = new File(args[1]);
        MakeAllXML.makeAllComCamXML(new File(outputLocation, "/CCCamera/"), checksumOutputLocation);
        MakeAllXML.makeAllMainCameraXML(new File(outputLocation, "/MTCamera/"), checksumOutputLocation);
        MakeAllXML.makeAllAuxTelXML(new File(outputLocation, "/ATCamera/"), checksumOutputLocation);
    }

    private static void makeAllAuxTelXML(File outputLocation, File checksumOutputLocation) throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        MakeAllXML.makeAllXML(outputLocation, Camera.AUXTEL, checksumOutputLocation);
    }

    private static void makeAllComCamXML(File outputLocation, File checksumOutputLocation) throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        MakeAllXML.makeAllXML(outputLocation, Camera.COMCAM, checksumOutputLocation);
    }

    private static void makeAllMainCameraXML(File outputLocation, File checksumOutputLocation) throws IOException, ParserConfigurationException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        MakeAllXML.makeAllXML(outputLocation, Camera.MAIN_CAMERA, checksumOutputLocation);
    }

    private static void makeAllXML(File outputLocation, Camera camera, File checksumOutputLocation) throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        XMLMaker2 maker = new XMLMaker2(false);
        outputLocation.mkdirs();
        MakeAllXML.makeAllXMLForConfiguration(outputLocation, MakeXMLConfiguration.getInstance(camera, XMLMaker2.SALType.TELEMETRY), maker);
        MakeAllXML.makeAllXMLForConfiguration(outputLocation, MakeXMLConfiguration.getInstance(camera, XMLMaker2.SALType.SETTINGS_APPLIED), maker);
        for (XMLMaker2.SALType type : XMLMaker2.SALType.values()) {
            MakeXMLConfiguration xmlConfig = MakeXMLConfiguration.getInstance(camera, type);
            for (MakeXMLConfiguration.DictionaryConfiguration dictConfig : xmlConfig.getOrderedListOfDictionaryConfigurations()) {
                File outputFileName = new File(outputLocation, xmlConfig.getXMLFileNameForAgent(dictConfig.getAgentName()));
                MakeXMLConfiguration agentConfig = MakeXMLConfiguration.getInstance(camera, type, dictConfig.getAgentName(), dictConfig.getDictionary());
                Document document = maker.createXML(agentConfig);
                maker.writeXML(new StreamResult(outputFileName), document);
                LOG.log(Level.INFO, "Wrote {0}", outputFileName);
            }
            MakeAllXML.writeAllXMLChecksums(xmlConfig, checksumOutputLocation);
        }
    }

    private static void makeAllXMLForConfiguration(File outputLocation, MakeXMLConfiguration config, XMLMaker2 maker) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException, TransformerException {
        File outputFileName = new File(outputLocation, config.getXMLFileName());
        Document document = maker.createXML(config);
        if (config.getSALType() == XMLMaker2.SALType.SETTINGS_APPLIED) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(outputFileName);
            XMLUtils xmlUtils = new XMLUtils();
            xmlUtils.replacePartOfDocument(doc, document, "CONFIGURATION", "ENDCONFIGURATION");
            document = doc;
        }
        maker.writeXML(new StreamResult(outputFileName), document);
        System.out.println("Wrote " + outputFileName);
    }

    public static String getChecksumsFile(Camera camera, XMLMaker2.SALType saltype) {
        return MakeXMLConfiguration.getInstance(camera, saltype).getXMLFileName().replace(".xml", ".properties");
    }

    public static String getChecksumsMessage(Camera camera, XMLMaker2.SALType saltype) {
        return String.format("Camera: %s SALType: %s", new Object[]{camera, saltype});
    }

    private static void writeAllXMLChecksums(MakeXMLConfiguration xmlConfig, File checksumOutputLocation) throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, XPathExpressionException {
        Camera camera = xmlConfig.getCamera();
        XMLMaker2.SALType saltype = xmlConfig.getSALType();
        Map<String, Long> computed = MakeAllXML.computeChecksumsForAllXML(camera, saltype);
        String fileName = xmlConfig.getXMLFileName().replace(".xml", ".properties");
        checksumOutputLocation.mkdirs();
        File checksumFile = new File(checksumOutputLocation, fileName);
        System.out.println("Updating checksum file " + checksumFile.getAbsolutePath());
        OrderedProperties.store(computed, new PrintStream(checksumFile), MakeAllXML.getChecksumsMessage(camera, saltype));
    }

    public static Map<String, Long> computeChecksumsForAllXML(Camera camera, XMLMaker2.SALType saltype) throws ParserConfigurationException, TransformerException, IOException, ClassNotFoundException, XPathExpressionException {
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        XMLMaker2 maker = new XMLMaker2(false);
        ChecksumExtractorUtils utils = new ChecksumExtractorUtils();
        MakeXMLConfiguration config = MakeXMLConfiguration.getInstance(camera, saltype);
        List<MakeXMLConfiguration.DictionaryConfiguration> dictConfigs = config.getOrderedListOfDictionaryConfigurations();
        for (MakeXMLConfiguration.DictionaryConfiguration dictConfig : dictConfigs) {
            SALClassDescriptionMaker descriptionMaker = new SALClassDescriptionMaker(dictConfig, config.getMapping());
            if (descriptionMaker.getSALClassDescriptions().isEmpty()) continue;
            Document document = maker.createDocument(config.getSALType());
            maker.generateXML(document, descriptionMaker);
            long checkSum = ChecksumExtractorUtils.checkXML(maker, document);
            result.put(dictConfig.getComponentName(), checkSum);
            result.putAll(utils.extractChecksums(document));
        }
        return result;
    }

    public static Map<String, Long> extractChecksumsForXMLFile(String xmlFile) {
        String fileName = xmlFile.replace(".xml", ".properties");
        if (fileName.contains("/")) {
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        }
        LinkedHashMap<String, Long> read = new LinkedHashMap<String, Long>();
        try (InputStream in = MakeAllXML.class.getResourceAsStream(fileName);){
            OrderedProperties.load(read, in);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read checksums ");
        }
        return read;
    }
}

