/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Vector;
import org.freehep.graphicsio.pdf.PDFByteWriter;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFName;
import org.freehep.graphicsio.pdf.PDFRef;

public class PDF {
    private int generationNumber = 0;
    private Hashtable<String, PDFRef> refsByName = new Hashtable();
    private Vector<PDFRef> refsByNumber = new Vector();
    private Vector<Integer> xrefsByNumber = new Vector();
    private int startXref = 0;
    protected PDFByteWriter out;

    PDF(PDFByteWriter out) {
        this.out = out;
        this.refsByNumber.addElement(new PDFRef("Dummy", 0, 0));
        this.xrefsByNumber.addElement(new Integer(999999));
    }

    public PDFName name(String name) {
        return new PDFName(name);
    }

    public PDFRef ref(String name) {
        if (name == null) {
            return null;
        }
        PDFRef ref = this.refsByName.get(name);
        if (ref == null) {
            int refNumber = this.refsByNumber.size();
            ref = new PDFRef(name, refNumber, this.generationNumber);
            this.refsByName.put(name, ref);
            this.refsByNumber.add(ref);
            this.xrefsByNumber.add(null);
        }
        return ref;
    }

    public PDFRef[] ref(String[] names) {
        PDFRef[] refs = new PDFRef[names.length];
        for (int i = 0; i < names.length; ++i) {
            refs[i] = this.ref(names[i]);
        }
        return refs;
    }

    protected void setXRef(int objectNumber, int offset) {
        this.xrefsByNumber.set(objectNumber, new Integer(offset));
    }

    protected void xref() throws IOException {
        DecimalFormat offsetFormat = new DecimalFormat("0000000000");
        DecimalFormat linkFormat = new DecimalFormat("00000");
        this.startXref = this.out.getCount();
        this.out.printPlain("xref");
        this.out.println();
        this.out.printPlain("0 " + this.xrefsByNumber.size());
        this.out.println();
        this.out.printPlain(offsetFormat.format(0L) + " " + linkFormat.format(65535L) + " f\r\n");
        for (int i = 1; i < this.xrefsByNumber.size(); ++i) {
            Integer offsetObject = this.xrefsByNumber.get(i);
            if (offsetObject != null) {
                int offset = offsetObject;
                this.out.printPlain(offsetFormat.format(offset) + " " + linkFormat.format(0L) + " n\r\n");
                continue;
            }
            PDFRef ref = this.refsByNumber.get(i);
            System.err.println("PDFWriter: PDFRef '" + ref.getName() + "' is used but not defined.");
        }
        this.out.println();
    }

    protected void trailer(String rootName, String docInfoName) throws IOException {
        this.out.println("trailer");
        PDFDictionary dictionary = new PDFDictionary(this, this.out);
        dictionary.entry("Size", this.refsByName.size());
        dictionary.entry("Root", this.ref(rootName));
        if (docInfoName != null) {
            dictionary.entry("Info", this.ref(docInfoName));
        }
        dictionary.close();
        this.out.println();
    }

    protected void startxref() throws IOException {
        this.out.println("startxref");
        this.out.println(this.startXref);
        this.out.println();
    }
}

