/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IHistogramFactory;
import hep.aida.IProfile1D;
import hep.aida.IProfile2D;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.test.AidaTestCase;
import java.io.IOException;
import java.util.Random;
import junit.framework.Assert;

public class TestProfile
extends AidaTestCase {
    public TestProfile(String testName) {
        super(testName);
    }

    public void testProfileCopy() throws IOException {
        Random r = this.getRandomNumberGenerator();
        IAnalysisFactory af = IAnalysisFactory.create();
        ITreeFactory tf = af.createTreeFactory();
        ITree tree1 = tf.create();
        IHistogramFactory hf1 = af.createHistogramFactory(tree1);
        ITree tree2 = tf.create();
        IHistogramFactory hf2 = af.createHistogramFactory(tree2);
        IProfile1D p1 = hf1.createProfile1D("p1", "Test Profile 1d", 36, -4.3, 5.0);
        IProfile2D p2 = hf1.createProfile2D("p2", "Test Profile 2d", 36, -4.3, 5.0, 3, -1.0, 1.0);
        int entries = 100;
        for (int i = 0; i < entries; ++i) {
            double xval = r.nextGaussian();
            double yval = r.nextDouble();
            double zval = r.nextGaussian();
            p1.fill(xval, zval);
            p2.fill(xval, yval, zval);
        }
        IProfile1D p1New = hf2.createCopy("p1", p1);
        IProfile2D p2New = hf2.createCopy("p2", p2);
        AidaTestCase.assertEquals(p1, p1New);
        AidaTestCase.assertEquals(p2, p2New);
    }

    public void testNaN() throws IOException {
        Random r = this.getRandomNumberGenerator();
        IAnalysisFactory af = IAnalysisFactory.create();
        ITreeFactory tf = af.createTreeFactory();
        ITree tree = tf.create();
        IHistogramFactory hf = af.createHistogramFactory(tree);
        IProfile1D p1 = hf.createProfile1D("p1", "Test Profile 1d", 36, -4.3, 5.0);
        IProfile2D p2 = hf.createProfile2D("p2", "Test Profile 2d", 36, -4.3, 5.0, 3, -1.0, 1.0);
        int entries = 100;
        for (int i = 0; i < entries; ++i) {
            double xval = r.nextGaussian();
            double yval = r.nextDouble();
            double zval = r.nextGaussian();
            p1.fill(xval, zval);
            p2.fill(xval, yval, zval);
        }
        double mean = p1.mean();
        double rms = p1.rms();
        double meanx = p2.meanX();
        double rmsx = p2.rmsX();
        double meany = p2.meanY();
        double rmsy = p2.rmsY();
        p1.fill(Double.NaN, 1.0);
        p2.fill(0.0, 1.0, 3.0, Double.NaN);
        Assert.assertEquals((int)p1.nanEntries(), (int)1);
        Assert.assertEquals((int)p2.nanEntries(), (int)1);
        AidaTestCase.assertEqualsDouble(p1.mean(), mean, 0.0);
        AidaTestCase.assertEqualsDouble(p1.rms(), rms, 0.0);
        AidaTestCase.assertEqualsDouble(p2.meanX(), meanx, 0.0);
        AidaTestCase.assertEqualsDouble(p2.rmsX(), rmsx, 0.0);
        AidaTestCase.assertEqualsDouble(p2.meanY(), meany, 0.0);
        AidaTestCase.assertEqualsDouble(p2.rmsY(), rmsy, 0.0);
    }
}

