/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling.data;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;

@SkipEncoding
public class JsonFile
extends AdditionalFile {
    private final Object data;
    private final String dataName;
    private static final long serialVersionUID = 1L;

    public JsonFile(String fileName, String fileType, ImageName obsId, String dataName, Object data) {
        super(fileName, fileType, obsId);
        this.dataName = dataName;
        this.data = data;
    }

    @Override
    public void writeFile(OutputStream out) throws IOException {
        LinkedHashMap<String, Object> jsonData = new LinkedHashMap<String, Object>();
        jsonData.put("fileName", super.getFileName());
        jsonData.put("fileType", super.getFileType());
        jsonData.put("obsId", super.getObsId().toString());
        jsonData.put(this.dataName, this.data);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.writerWithDefaultPrettyPrinter().writeValue(out, jsonData);
    }
}

