/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentPropertyPredicate;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.localdb.statusdb.BatchPersister;
import org.lsst.ccs.localdb.statusdb.CloseMetaData;
import org.lsst.ccs.localdb.statusdb.StatusDataPersister;
import org.lsst.ccs.localdb.statusdb.model.DataGroup;
import org.lsst.ccs.localdb.statusdb.model.DataPath;
import org.lsst.ccs.localdb.statusdb.model.MetaDataData;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.services.AgentPeriodicTaskService;

public class MetaDataPersister
extends BatchPersister<Object> {
    private static final Logger LIVE_MD_LOG = Logger.getLogger("org.lsst.ccs.localdb.statusdb.metadata");
    private static Map<String, MetaDataData> LIVE_METADATA;
    private AgentPropertyPredicate predicate;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupName
    private String name;

    public MetaDataPersister() {
        super(6000, true, 1, -1);
    }

    public void build() {
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(this.name, (Runnable)this).withIsFixedRate(false).withPeriod(Duration.ofSeconds(1L)));
    }

    @Override
    public void init() {
        super.init();
        MetaDataPersister.initializeIfNeeded();
    }

    public void shutdown() {
        MetaDataPersister.terminateIfNeeded();
        super.shutdown();
    }

    public boolean acceptAgentInfo(AgentInfo t) {
        return this.predicate == null ? true : this.predicate.test(t);
    }

    @Override
    public void persist(Object obj, Session sess) {
        if (obj instanceof MetaDataData) {
            this.persistMetaData((MetaDataData)obj, sess);
        } else if (obj instanceof CloseMetaData) {
            this.closeMetaData((CloseMetaData)obj, sess);
        }
    }

    public void queueImmediateMetaData(long tStamp, DataPath name, String metadata, String value) {
        MetaDataData md = new MetaDataData(tStamp);
        md.setName(metadata);
        md.setValue(value);
        DataGroup dg = new DataGroup(name.getAgentName(), name.getDataName());
        md.setDataGroup(dg);
        this.log.log(Level.FINER, "Queuing metadata {0} with value {1}.", new Object[]{MetaDataPersister.getMetaDataDataUniqueKey(md), md.getValue()});
        this.addToQueue(md);
    }

    private synchronized boolean needsPersisting(MetaDataData md) {
        MetaDataData oldMetaData = LIVE_METADATA.get(MetaDataPersister.getMetaDataDataUniqueKey(md));
        if (oldMetaData != null && oldMetaData.getValue().equals(md.getValue())) {
            LIVE_MD_LOG.log(Level.FINEST, "Metadata {0} does not need persisting since its value {1} is identical to the existing one in the live map {2}.", new Object[]{MetaDataPersister.getMetaDataDataUniqueKey(md), md.getValue(), oldMetaData.getValue()});
            return false;
        }
        return true;
    }

    private void persistMetaData(MetaDataData md, Session sess) {
        DataGroup dg;
        String uniqueKey = MetaDataPersister.getMetaDataDataUniqueKey(md);
        this.log.log(Level.FINE, "Persisting metadata {0} with value {1}.", new Object[]{uniqueKey, md.getValue()});
        MetaDataData oldMetaData = LIVE_METADATA.get(uniqueKey);
        if (oldMetaData != null) {
            if (oldMetaData.getValue().equals(md.getValue())) {
                this.log.log(Level.FINER, "Metadata {0} does not need persisting since its value {1} is identical to the existing one in the live map {2}.", new Object[]{uniqueKey, md.getValue(), oldMetaData.getValue()});
                return;
            }
            this.log.log(Level.FINEST, "Closing old metadata {0} with value {1}; new value {2}.", new Object[]{uniqueKey, oldMetaData.getValue(), md.getValue()});
            oldMetaData.setEndTime(md.getStartTime());
            LIVE_METADATA.remove(uniqueKey);
            sess.update((Object)oldMetaData);
        }
        if ((dg = md.getDataGroup()).getId() == 0L) {
            dg = StatusDataPersister.getDataGroup(dg.getAgentName(), dg.getGroupName(), sess);
            md.setDataGroup(dg);
        }
        LIVE_METADATA.put(uniqueKey, md);
        sess.persist((Object)md);
    }

    private void closeMetaData(CloseMetaData cmd, Session sess) {
        long time = System.currentTimeMillis();
        for (MetaDataData md : LIVE_METADATA.values()) {
            if (!md.getDataGroup().getAgentName().equals(cmd.agentName)) continue;
            md.setEndTime(time);
            LIVE_METADATA.remove(MetaDataPersister.getMetaDataDataUniqueKey(md));
            sess.update((Object)md);
        }
    }

    private static synchronized void initializeIfNeeded() {
        if (LIVE_METADATA == null) {
            LIVE_METADATA = new ConcurrentHashMap<String, MetaDataData>();
            try (Session sess = StatusdbUtils.getSessionFactory().openSession();){
                Transaction tx = sess.beginTransaction();
                Query q = sess.createQuery("from MetaDataData md where endTime = -1 order by startTime desc");
                List res = q.list();
                for (MetaDataData md : res) {
                    String uniqueKey = MetaDataPersister.getMetaDataDataUniqueKey(md);
                    MetaDataData existingMetaData = LIVE_METADATA.get(uniqueKey);
                    if (existingMetaData != null) {
                        LIVE_MD_LOG.log(Level.INFO, "Metadata {0} already belongs to the live map. This should not have happened.", new Object[]{uniqueKey});
                        md.setEndTime(existingMetaData.getStartTime());
                        sess.update((Object)md);
                        continue;
                    }
                    LIVE_METADATA.put(uniqueKey, md);
                }
                tx.commit();
            }
            LIVE_MD_LOG.log(Level.INFO, "Loaded {0} live metadata fields ", new Object[]{LIVE_METADATA.size()});
        }
    }

    private static synchronized void terminateIfNeeded() {
        if (LIVE_METADATA != null) {
            int size = LIVE_METADATA.size();
            try (Session sess = StatusdbUtils.getSessionFactory().openSession();){
                Transaction tx = sess.beginTransaction();
                long endTime = System.currentTimeMillis();
                for (MetaDataData md : LIVE_METADATA.values()) {
                    md.setEndTime(endTime);
                    sess.update((Object)md);
                }
                tx.commit();
            }
            LIVE_METADATA = null;
            LIVE_MD_LOG.log(Level.INFO, "Closed {0} live metadata fields ", new Object[]{size});
        }
    }

    private static String getMetaDataDataUniqueKey(MetaDataData md) {
        return md.getDataGroup().getAgentName() + "-" + md.getDataGroup().getGroupName() + "-" + md.getName();
    }
}

