/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.util;

import hep.aida.ICloud;
import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IFunction;
import hep.aida.IHistogram;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.ITuple;
import hep.aida.ref.tuple.Tuple;
import java.util.Random;

public abstract class MCUtils {
    private static double scaleMaxHeight = 1.2;

    public static void generateMCDistribution(IHistogram hist, IFunction f, int entries) {
        long seed = System.currentTimeMillis();
        MCUtils.generateMCDistribution(hist, f, entries, seed);
    }

    public static void generateMCDistribution(IHistogram hist, IFunction f, int entries, long seed) {
        int dim = f.dimension();
        double[] xMin = null;
        double[] xMax = null;
        if (dim == 1) {
            xMin = new double[]{((IHistogram1D)hist).axis().lowerEdge()};
            xMax = new double[]{((IHistogram1D)hist).axis().upperEdge()};
        } else if (dim == 2) {
            xMin = new double[]{((IHistogram2D)hist).xAxis().lowerEdge(), ((IHistogram2D)hist).yAxis().lowerEdge()};
            xMax = new double[]{((IHistogram2D)hist).xAxis().upperEdge(), ((IHistogram2D)hist).yAxis().upperEdge()};
        } else if (dim == 3) {
            xMin = new double[]{((IHistogram3D)hist).xAxis().lowerEdge(), ((IHistogram3D)hist).yAxis().lowerEdge(), ((IHistogram3D)hist).zAxis().lowerEdge()};
            xMax = new double[]{((IHistogram3D)hist).xAxis().upperEdge(), ((IHistogram3D)hist).yAxis().upperEdge(), ((IHistogram3D)hist).zAxis().upperEdge()};
        }
        MCUtils.generateMCDistribution(hist, f, entries, xMin, xMax, seed);
    }

    public static void generateMCDistribution(IHistogram hist, IFunction f, int entries, double[] min, double[] max) {
        long seed = System.currentTimeMillis();
        MCUtils.generateMCDistribution(hist, f, entries, min, max, seed);
    }

    public static void generateMCDistribution(IHistogram hist, IFunction f, int entries, double[] min, double[] max, long seed) {
        int evEntries = entries / 10;
        if (evEntries < 100) {
            evEntries = entries;
        }
        double maxHeight = MCUtils.evaluateMaxHeight(f, min, max, evEntries);
        MCUtils.generateMCDistribution(hist, f, entries, min, max, seed, maxHeight);
    }

    public static void generateMCDistribution(IHistogram hist, IFunction f, int entries, double[] min, double[] max, long seed, double maxHeight) {
        int dim = f.dimension();
        double[] x = new double[dim + 1];
        double[] point = null;
        Random rand = new Random(seed);
        try {
            for (int i = 0; i < entries; ++i) {
                point = MCUtils.getValidPoint(f, min, max, maxHeight, x, rand);
                if (dim == 1) {
                    ((IHistogram1D)hist).fill(point[0]);
                }
                if (dim == 2) {
                    ((IHistogram2D)hist).fill(point[0], point[1]);
                }
                if (dim != 3) continue;
                ((IHistogram3D)hist).fill(point[0], point[1], point[2]);
            }
        }
        catch (MaxHeightException e) {
            System.out.println("\nWARNING: \t" + e.getMessage());
            System.out.println("         \tSet maxHeight=" + maxHeight * scaleMaxHeight + " and re-fill histogram\n");
            hist.reset();
            MCUtils.generateMCDistribution(hist, f, entries, min, max, seed, maxHeight * scaleMaxHeight);
        }
    }

    public static void generateMCDistribution(ICloud cloud, IFunction f, int entries, double[] min, double[] max) {
        long seed = System.currentTimeMillis();
        MCUtils.generateMCDistribution(cloud, f, entries, min, max, seed);
    }

    public static void generateMCDistribution(ICloud cloud, IFunction f, int entries, double[] min, double[] max, long seed) {
        int evEntries = entries / 10;
        if (evEntries < 100) {
            evEntries = entries;
        }
        double maxHeight = MCUtils.evaluateMaxHeight(f, min, max, evEntries);
        MCUtils.generateMCDistribution(cloud, f, entries, min, max, seed, maxHeight * scaleMaxHeight);
    }

    public static void generateMCDistribution(ICloud cloud, IFunction f, int entries, double[] min, double[] max, double maxHeight) {
        long seed = System.currentTimeMillis();
        MCUtils.generateMCDistribution(cloud, f, entries, min, max, seed, maxHeight);
    }

    public static void generateMCDistribution(ICloud cloud, IFunction f, int entries, double[] min, double[] max, long seed, double maxHeight) {
        int dim = f.dimension();
        double[] x = new double[dim + 1];
        double[] point = null;
        Random rand = new Random(seed);
        try {
            for (int i = 0; i < entries; ++i) {
                point = MCUtils.getValidPoint(f, min, max, maxHeight, x, rand);
                if (dim == 1) {
                    ((ICloud1D)cloud).fill(point[0]);
                    continue;
                }
                if (dim == 2) {
                    ((ICloud2D)cloud).fill(point[0], point[1]);
                    continue;
                }
                if (dim != 3) continue;
                ((ICloud3D)cloud).fill(point[0], point[1], point[2]);
            }
        }
        catch (MaxHeightException e) {
            System.out.println("\nWARNING: \t" + e.getMessage());
            System.out.println("         \tSet maxHeight=" + maxHeight * scaleMaxHeight + " and re-fill histogram\n");
            cloud.reset();
            MCUtils.generateMCDistribution(cloud, f, entries, min, max, seed, maxHeight * scaleMaxHeight);
        }
    }

    public static ITuple generateMCTuple(IFunction f, int entries, double[] min, double[] max) {
        int evEntries = entries / 10;
        if (evEntries < 100) {
            evEntries = entries;
        }
        double maxHeight = MCUtils.evaluateMaxHeight(f, min, max, evEntries);
        return MCUtils.generateMCTuple(f, entries, min, max, maxHeight * scaleMaxHeight);
    }

    public static ITuple generateMCTuple(IFunction f, int entries, double[] min, double[] max, double maxHeight) {
        long seed = System.currentTimeMillis();
        return MCUtils.generateMCTuple(f, entries, min, max, seed, maxHeight);
    }

    public static ITuple generateMCTuple(IFunction f, int entries, double[] min, double[] max, long seed) {
        int evEntries = entries / 10;
        if (evEntries < 100) {
            evEntries = entries;
        }
        double maxHeight = MCUtils.evaluateMaxHeight(f, min, max, evEntries);
        return MCUtils.generateMCTuple(f, entries, min, max, seed, maxHeight * scaleMaxHeight);
    }

    public static ITuple generateMCTuple(IFunction f, int entries, double[] min, double[] max, long seed, double maxHeight) {
        int dim = f.dimension();
        String[] columnNames = new String[dim + 1];
        Class[] columnTypes = new Class[dim + 1];
        for (int i = 0; i < dim; ++i) {
            columnNames[i] = "x[" + i + "]";
            columnTypes[i] = Double.TYPE;
        }
        columnNames[dim] = "value";
        columnTypes[dim] = Double.TYPE;
        String name = "";
        String title = "Generated from " + f.title();
        Tuple tuple = new Tuple(name, title, columnNames, columnTypes, "");
        double[] x = new double[dim + 1];
        double[] point = null;
        Random rand = new Random(seed);
        try {
            for (int i = 0; i < entries; ++i) {
                point = MCUtils.getValidPoint(f, min, max, maxHeight, x, rand);
                for (int j = 0; j < dim + 1; ++j) {
                    tuple.fill(j, point[j]);
                }
                tuple.addRow();
            }
        }
        catch (MaxHeightException e) {
            System.out.println("\nWARNING: \t" + e.getMessage());
            System.out.println("         \tSet maxHeight=" + maxHeight * scaleMaxHeight + " and re-fill ITuple\n");
            tuple.reset();
            return MCUtils.generateMCTuple(f, entries, min, max, seed, maxHeight * scaleMaxHeight);
        }
        return tuple;
    }

    private static double[] getValidPoint(IFunction f, double[] min, double[] max, double maxHeight, double[] x, Random rand) {
        if (rand == null) {
            rand = new Random();
        }
        double y = 0.0;
        double functionValue = 0.0;
        int dim = f.dimension();
        do {
            for (int j = 0; j < dim; ++j) {
                x[j] = min[j] + (max[j] - min[j]) * rand.nextDouble();
            }
            x[dim] = f.value(x);
            if (!(x[dim] > maxHeight)) continue;
            String message = "" + x[0];
            for (int j = 1; j < dim; ++j) {
                message = message + ", " + x[j];
            }
            message = "f( " + message + " ) = " + functionValue + ", maxHeight = " + maxHeight;
            throw new MaxHeightException(message);
        } while (!(x[dim] > (y = maxHeight * rand.nextDouble())));
        return x;
    }

    private static double evaluateMaxHeight(IFunction f, double[] min, double[] max, int entries) {
        int dim = f.dimension();
        double[] x = new double[dim];
        Random rand = new Random();
        double maxHeight = 0.0;
        double tmp = 0.0;
        for (int i = 0; i < entries; ++i) {
            for (int j = 0; j < dim; ++j) {
                x[j] = min[j] + (max[j] - min[j]) * rand.nextDouble();
            }
            tmp = f.value(x);
            if (!(tmp > maxHeight)) continue;
            maxHeight = tmp;
        }
        return maxHeight;
    }

    private static class MaxHeightException
    extends RuntimeException {
        private MaxHeightException(String message) {
            super(message);
        }
    }
}

