/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.freehep.jas.flavors.ObjectFlavor;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.PlotRegionDropHandler;
import org.freehep.jas.services.Plotter;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;
import org.lsst.ccs.gconsole.plugins.trending.RestSource;
import org.lsst.ccs.gconsole.plugins.trending.Trend;
import org.lsst.ccs.gconsole.plugins.trending.TrendPlotter;
import org.lsst.ccs.gconsole.services.aggregator.ChannelSelector;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;
import org.lsst.ccs.gconsole.util.swing.SearchDialog;
import org.lsst.ccs.gconsole.util.tree.SModel;
import org.lsst.ccs.gconsole.util.tree.SNode;
import org.lsst.ccs.gconsole.util.tree.STree;
import org.lsst.ccs.gconsole.util.tree.Sort;

public final class ControlPanel
extends JPanel
implements Persistable,
HasPopupItems {
    private static final String DEFAULT_NAME = "Trending";
    public static final String CATEGORY = "TrendingControlPanel";
    private final LsstTrendingPlugin plugin = Console.getConsole().getSingleton(LsstTrendingPlugin.class);
    private final Descriptor descriptor;
    private final STree<Object> tree;
    private AgentChannelsFilter filter;
    private final ChangeListener trendingSourceListener = e -> this.updateFromTrendingSource();
    private final Action actShow;
    private final Action actPlot;
    private final Action actOverlay;
    private final Action actNewPlot;
    private final Action actNewPage;
    private final Action actRefresh;
    private Object currentSelection;

    public ControlPanel() {
        this((Descriptor)null);
    }

    public ControlPanel(Descriptor desc) {
        super(new BorderLayout());
        this.descriptor = desc == null ? new Descriptor() : desc.clone();
        String name = desc == null ? DEFAULT_NAME : desc.getName();
        this.setName(name == null ? DEFAULT_NAME : name);
        SModel tModel = new SModel();
        SModel.Descriptor d = this.descriptor.getTreeModel();
        if (d != null) {
            tModel.restore(d);
        }
        this.tree = new STree(tModel);
        this.add(this.tree, "Center");
        this.actShow = new AbstractAction("Show"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ControlPanel.this.currentSelection instanceof Trend.Descriptor) {
                    ControlPanel.this.plugin.plot((Trend.Descriptor)ControlPanel.this.currentSelection, TrendPlotter.Option.EXIST, TrendPlotter.Option.NEWPAGE);
                }
            }
        };
        this.actPlot = new AbstractAction("Plot"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ControlPanel.this.currentSelection instanceof Trend.Descriptor) {
                    ControlPanel.this.plugin.plot((Trend.Descriptor)ControlPanel.this.currentSelection, new TrendPlotter.Option[0]);
                }
            }
        };
        this.actPlot.putValue("SHORT_DESCRIPTION", "Plot in the currently selected region.");
        this.actOverlay = new AbstractAction("Overlay"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ControlPanel.this.currentSelection instanceof Trend.Descriptor) {
                    ControlPanel.this.plugin.plot((Trend.Descriptor)ControlPanel.this.currentSelection, TrendPlotter.Option.OVERLAY);
                }
            }
        };
        this.actOverlay.putValue("SHORT_DESCRIPTION", "Overlay on the currently selected plot.");
        this.actNewPlot = new AbstractAction("New Plot"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ControlPanel.this.currentSelection instanceof Trend.Descriptor) {
                    ControlPanel.this.plugin.plot((Trend.Descriptor)ControlPanel.this.currentSelection, TrendPlotter.Option.NEWPLOT);
                }
            }
        };
        this.actNewPlot.putValue("SHORT_DESCRIPTION", "Plot in a new region.");
        this.actNewPage = new AbstractAction("New Page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ControlPanel.this.currentSelection instanceof Trend.Descriptor) {
                    ControlPanel.this.plugin.plot((Trend.Descriptor)ControlPanel.this.currentSelection, TrendPlotter.Option.NEWPAGE);
                }
            }
        };
        this.actNewPage.putValue("SHORT_DESCRIPTION", "Plot on a new page.");
        this.actRefresh = new AbstractAction("Refresh"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ControlPanel.this.currentSelection instanceof Trend.Descriptor) {
                    ControlPanel.this.plugin.refresh((Trend.Descriptor)ControlPanel.this.currentSelection);
                }
            }
        };
        this.actRefresh.putValue("SHORT_DESCRIPTION", "Refresh plots for this channel.");
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath path = ControlPanel.this.tree.getPathForLocation(e.getX(), e.getY());
                if (path != null && e.getClickCount() == 2) {
                    switch (ControlPanel.this.plugin.getPreferences().getDoubleClick()) {
                        case -1: {
                            ControlPanel.this.actShow.actionPerformed(null);
                            break;
                        }
                        case -2: {
                            ControlPanel.this.actPlot.actionPerformed(null);
                            break;
                        }
                        case -3: {
                            ControlPanel.this.actNewPlot.actionPerformed(null);
                            break;
                        }
                        case -4: {
                            ControlPanel.this.actNewPage.actionPerformed(null);
                            break;
                        }
                        default: {
                            ControlPanel.this.actShow.actionPerformed(null);
                        }
                    }
                }
            }
        };
        this.tree.addMouseListener(ml);
        this.tree.addTreeSelectionListener(e -> {
            this.currentSelection = this.tree.getSelectedUserObject();
        });
        this.tree.setDragEnabled(true);
        this.tree.setTransferHandler(new TreeTransferHandler());
    }

    public void start() {
        Persistable.Descriptor filterDesc;
        if (this.filter == null && (filterDesc = this.descriptor.getFilter()) != null) {
            PersistenceService serv = this.plugin.getConsole().getSingleton(PersistenceService.class);
            this.filter = (AgentChannelsFilter)serv.make(filterDesc);
        }
        this.plugin.getTrendingSource().addListener(this.trendingSourceListener);
        this.updateFromTrendingSource();
        this.plugin.getTrendingSource().refresh();
    }

    public void stop() {
        this.plugin.getTrendingSource().removeListener(this.trendingSourceListener);
    }

    private void updateFromTrendingSource() {
        String name = this.descriptor.getName();
        if (name == null) {
            if (this.filter != null) {
                name = this.filter.getName();
            }
            if (name == null) {
                name = DEFAULT_NAME;
            }
        }
        if (!name.equals(this.getName())) {
            this.setName(name);
        }
        Console.getConsole().getPanelManager().set(this, Panel.TITLE, name);
        RestSource source = this.plugin.getTrendingSource();
        List<String> channels = source.getChannels();
        LinkedHashMap path2desc = new LinkedHashMap(channels.size() * 2);
        if (this.filter == null) {
            channels.forEach(path -> path2desc.put(path, new Trend.Descriptor((String)path)));
        } else {
            channels = ChannelSelector.filterPaths(this.filter, channels);
            List<String> allowedDisplayPaths = this.filter.getDisplayChannels();
            channels.forEach(path -> {
                List<String> displayPaths = this.filter.getDisplayPaths((String)path);
                if (allowedDisplayPaths != null) {
                    displayPaths.retainAll(allowedDisplayPaths);
                }
                displayPaths.forEach(dp -> path2desc.put(path, new Trend.Descriptor((String)path, (String)dp)));
            });
        }
        if (((SModel)this.tree.getModel()).getRoot() != null && ((DefaultMutableTreeNode)((SModel)this.tree.getModel()).getRoot()).getChildCount() > 0) {
            this.descriptor.setTree(this.tree.save());
        }
        ((SModel)this.tree.getModel()).update(path2desc);
        this.tree.restore(this.descriptor.getTree());
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component component, Point point) {
        JMenu m;
        if (this.tree.getModel() == null) {
            return menu;
        }
        AbstractAction act = new AbstractAction("Refresh"){

            @Override
            public void actionPerformed(ActionEvent e) {
                RestSource source = ControlPanel.this.plugin.getTrendingSource();
                if (source != null) {
                    source.refresh();
                }
            }
        };
        menu.insert(act, 0);
        act = new AbstractAction("Save..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                PersistenceService service = ControlPanel.this.plugin.getConsole().getSingleton(PersistenceService.class);
                service.saveAs(ControlPanel.this.save(), "Save trending control panel", null);
            }
        };
        menu.insert(act, 0);
        act = new AbstractAction("Search..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<String> paths = new ArrayList<String>(((SModel)ControlPanel.this.tree.getModel()).getData().keySet());
                if (!paths.isEmpty()) {
                    paths.sort(null);
                    SearchDialog d = new SearchDialog(paths, "Search for a trending channel", ControlPanel.this);
                    d.setDescription("Enter a search string, using unix wildcards.");
                    d.setMaxResults(200);
                    SearchDialog.Button b = new SearchDialog.Button(" Plot "){

                        private List<String> getPaths(SearchDialog dialog) {
                            List<String> ss = dialog.getSelected();
                            if (ss == null) {
                                return null;
                            }
                            if (ss.isEmpty()) {
                                ss = dialog.getMatches();
                            }
                            if (ss.isEmpty() || ss.size() > 6) {
                                return null;
                            }
                            return ss;
                        }

                        @Override
                        public void setEnabled(SearchDialog dialog) {
                            this.setEnabled(this.getPaths(dialog) != null);
                        }

                        @Override
                        public void actionPerformed(SearchDialog dialog) {
                            List<String> ss = this.getPaths(dialog);
                            if (ss == null) {
                                return;
                            }
                            ArrayList<Trend.Descriptor> tds = new ArrayList<Trend.Descriptor>(ss.size());
                            for (String path : ss) {
                                SNode node = (SNode)((SModel)ControlPanel.this.tree.getModel()).getPath(path).getLastPathComponent();
                                Object payload = node.getUserObject();
                                if (!(payload instanceof Trend.Descriptor)) continue;
                                tds.add((Trend.Descriptor)payload);
                            }
                            TrendPlotter.Descriptor plotDesc = new TrendPlotter.Descriptor();
                            plotDesc.setTrends(tds.toArray(new Trend.Descriptor[tds.size()]));
                            ControlPanel.this.plugin.show(plotDesc);
                            dialog.cancel();
                        }
                    };
                    d.addAction(b);
                    b = new SearchDialog.Button("Select"){

                        private String getPath(SearchDialog dialog) {
                            List<String> ss = dialog.getSelected();
                            if (ss == null) {
                                return null;
                            }
                            if (ss.isEmpty()) {
                                ss = dialog.getMatches();
                            }
                            return ss.size() == 1 ? ss.get(0) : null;
                        }

                        @Override
                        public void setEnabled(SearchDialog dialog) {
                            this.setEnabled(this.getPath(dialog) != null);
                        }

                        @Override
                        public void actionPerformed(SearchDialog dialog) {
                            String displayPath = this.getPath(dialog);
                            if (displayPath != null) {
                                ControlPanel.this.tree.setSelectedPath(displayPath);
                                ControlPanel.this.tree.scrollPathToVisible(ControlPanel.this.tree.getSelectionPath());
                            }
                            dialog.cancel();
                        }
                    };
                    d.addAction(b);
                    d.search();
                }
            }
        };
        menu.insert(act, 0);
        ActionListener newFilterL = e -> {
            PersistenceService serv = this.plugin.getConsole().getSingleton(PersistenceService.class);
            try {
                AgentChannelsFilter f = (AgentChannelsFilter)serv.make(null, "Filter trending channels", this.tree, "AgentChannelsFilter");
                if (f != null) {
                    this.filter = f;
                    this.updateFromTrendingSource();
                }
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        };
        if (this.filter == null) {
            JMenuItem it = new JMenuItem("Filter...");
            it.addActionListener(newFilterL);
            menu.insert(it, 0);
        } else {
            m = new JMenu("Filter");
            Object it = new JMenuItem("New...");
            ((AbstractButton)it).addActionListener(newFilterL);
            m.add((JMenuItem)it);
            if (this.filter instanceof Persistable) {
                it = new JMenuItem("Edit...");
                ((AbstractButton)it).addActionListener(e -> {
                    try {
                        PersistenceService serv = this.plugin.getConsole().getSingleton(PersistenceService.class);
                        AgentChannelsFilter f = (AgentChannelsFilter)((Object)serv.edit((Persistable)((Object)this.filter), "Filter trending channels", this.tree));
                        if (f != null) {
                            this.filter = f;
                            this.updateFromTrendingSource();
                        }
                    }
                    catch (CancellationException serv) {
                    }
                    catch (RuntimeException x) {
                        Console.getConsole().error("Failed to edit filter", x);
                    }
                });
                m.add((JMenuItem)it);
            }
            it = new JMenuItem("Remove");
            ((AbstractButton)it).addActionListener(e -> {
                this.filter = null;
                this.updateFromTrendingSource();
            });
            m.add((JMenuItem)it);
            menu.insert(m, 0);
        }
        m = new JMenu("Sort");
        for (Sort sort : Sort.values()) {
            TreeModel model = this.tree.getModel();
            JCheckBoxMenuItem it = new JCheckBoxMenuItem(sort.toString(), sort.equals(((SModel)model).save().getSort()));
            it.addActionListener(arg_0 -> this.lambda$modifyPopupMenu$8((SModel)model, sort, arg_0));
            m.add(it);
        }
        menu.insert(m, 0);
        TreePath tp = this.tree.getPathForLocation(point.x, point.y);
        if (tp != null) {
            this.tree.setSelectionPath(tp);
            if (this.currentSelection instanceof Trend.Descriptor) {
                menu.insert(new JSeparator(), 0);
                menu.insert(this.actRefresh, 0);
                menu.insert(this.actNewPage, 0);
                menu.insert(this.actNewPlot, 0);
                menu.insert(this.actOverlay, 0);
                menu.insert(this.actPlot, 0);
                menu.insert(this.actShow, 0);
            }
        }
        return menu;
    }

    @Override
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Descriptor save() {
        Persistable.Descriptor desc;
        if (this.filter instanceof Persistable && (desc = ((Persistable)((Object)this.filter)).save()) != null) {
            this.descriptor.setFilter(desc);
        }
        this.descriptor.setTree(this.tree.save());
        this.descriptor.setTreeModel(((SModel)this.tree.getModel()).save());
        return this.descriptor;
    }

    private /* synthetic */ void lambda$modifyPopupMenu$8(SModel model, Sort sort, ActionEvent e) {
        this.descriptor.setTree(this.tree.save());
        model.sort(sort);
        this.tree.restore(this.descriptor.getTree());
    }

    public static class Descriptor
    extends Persistable.Descriptor {
        private Persistable.Descriptor filter;
        private STree.Descriptor tree;
        private SModel.Descriptor treeModel;

        @Override
        public void setCategory(String category) {
        }

        @Override
        public String getCategory() {
            return ControlPanel.CATEGORY;
        }

        public Persistable.Descriptor getFilter() {
            return this.filter;
        }

        public void setFilter(Persistable.Descriptor filter) {
            this.filter = filter;
        }

        public STree.Descriptor getTree() {
            return this.tree;
        }

        public void setTree(STree.Descriptor tree) {
            this.tree = tree;
        }

        public SModel.Descriptor getTreeModel() {
            return this.treeModel;
        }

        public void setTreeModel(SModel.Descriptor treeModel) {
            this.treeModel = treeModel;
        }

        @Override
        public Descriptor clone() {
            Descriptor clone = (Descriptor)super.clone();
            if (this.filter != null) {
                clone.filter = this.filter.clone();
            }
            if (this.tree != null) {
                clone.tree = this.tree.clone();
            }
            if (this.treeModel != null) {
                clone.treeModel = this.treeModel.clone();
            }
            return clone;
        }
    }

    static class DummyPlotter
    implements Plotter {
        static final DummyPlotter INSTANCE = new DummyPlotter();

        DummyPlotter() {
        }

        public void plot(Object data, int mode) {
        }

        public void plot(Object data, int mode, Object style, String options) {
        }

        public void remove(Object data) {
        }

        public void clear() {
        }

        public Component viewable() {
            return null;
        }

        public List getData() {
            return null;
        }
    }

    private static class ChannelDropHandler
    implements PlotRegionDropHandler {
        private final LsstTrendingPlugin plugin;
        private PlotRegion region;

        public ChannelDropHandler(LsstTrendingPlugin plugin) {
            this.plugin = plugin;
        }

        public void setPlotRegion(PlotRegion region) {
            this.region = region;
        }

        public void dragEnter(DropTargetDragEvent dtde) {
        }

        public void dragOver(DropTargetDragEvent dtde) {
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        public void dragExit(DropTargetEvent dte) {
        }

        public void drop(DropTargetDropEvent dtde) {
            if (this.region == null) {
                return;
            }
            Transferable trans = dtde.getTransferable();
            Trend.Descriptor channel = null;
            for (DataFlavor flavor : trans.getTransferDataFlavors()) {
                Class<?> k = flavor.getRepresentationClass();
                if (!Trend.Descriptor.class.isAssignableFrom(k)) continue;
                try {
                    channel = (Trend.Descriptor)trans.getTransferData(flavor);
                    break;
                }
                catch (UnsupportedFlavorException | IOException exception) {
                    // empty catch block
                }
            }
            if (channel != null) {
                if (this.plugin.getPreferences().getDnd() == 1) {
                    this.plugin.plot(channel, this.region, TrendPlotter.Option.OVERLAY);
                } else {
                    this.plugin.plot(channel, this.region, new TrendPlotter.Option[0]);
                }
            } else {
                dtde.rejectDrop();
            }
            dtde.dropComplete(true);
        }
    }

    private static class Trans
    implements Transferable {
        private final LinkedHashMap<DataFlavor, Object> data = new LinkedHashMap(4);

        private Trans() {
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new ArrayList<DataFlavor>(this.data.keySet()).toArray(new DataFlavor[0]);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.data.keySet().contains(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.data.containsKey(flavor)) {
                return this.data.get(flavor);
            }
            throw new UnsupportedFlavorException(flavor);
        }

        public void addDataForClass(Class clazz, Object payload) {
            this.data.put((DataFlavor)new ObjectFlavor(clazz), payload);
        }
    }

    private class TreeTransferHandler
    extends TransferHandler {
        private TreeTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            Trans trans = new Trans();
            trans.addDataForClass(PlotRegionDropHandler.class, new ChannelDropHandler(ControlPanel.this.plugin));
            trans.addDataForClass(Plotter.class, DummyPlotter.INSTANCE);
            Object payload = ControlPanel.this.tree.getSelectedUserObject();
            if (payload instanceof Trend.Descriptor) {
                trans.addDataForClass(Trend.Descriptor.class, payload);
            }
            return trans;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 0x40000000;
        }
    }
}

