/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;

public class BoardDacs {
    public static final int VERSION_UNSUPP = -1;
    public static final int VERSION_REB0_0 = 0;
    public static final int VERSION_REB0_1 = 1;
    public static final int VERSION_REB3 = 3;
    public static final int VERSION_REB5 = 6;
    public static final int VERSION_WREB1 = 2;
    public static final int VERSION_WREB2 = 4;
    public static final int VERSION_WREB4 = 8;
    public static final int VERSION_GREB1 = 5;
    public static final int VERSION_GREB2 = 7;
    public static final int REG_BOARD_DACS = 0x400000;
    public static final int REG_BOARD_DACS_0 = 0x500001;
    public static final int OFF_CLOCK_RAILS = 0;
    public static final int OFF_CS_GATE = 16;
    public static final int OFF_HEATER = 16;
    public static final int OFF_CABAC_ALT = 256;
    public static final int OFF_BIAS_GATE = 256;
    public static final int OFF_BIAS_ERROR = 271;
    public static final int INC_STRIPS = 16;
    public static final int DACS_SET = 0;
    public static final int DACS_LOAD = 1;
    public static final int DAC_HAS_STRIP = 16;
    public static final int DAC_CLOCK_RAILS = 0;
    public static final int DAC_CS_GATE = 1;
    public static final int DAC_CABAC_ALT = 2;
    public static final int DAC_HEATER = 3;
    public static final int DAC_BIAS_GATE = 16;
    public static final int CHAN_SCLK_L = 0;
    public static final int CHAN_SCLK_L_SH = 1;
    public static final int CHAN_SCLK_H = 2;
    public static final int CHAN_SCLK_H_SH = 3;
    public static final int CHAN_RG_L = 4;
    public static final int CHAN_RG_L_SH = 5;
    public static final int CHAN_RG_H = 6;
    public static final int CHAN_RG_H_SH = 7;
    public static final int CHAN_PCLK_L = 8;
    public static final int CHAN_PCLK_L_SH = 9;
    public static final int CHAN_PCLK_H = 10;
    public static final int CHAN_PCLK_H_SH = 11;
    public static final int CHAN_OD = 12;
    public static final int CHAN_GD = 13;
    public static final int CHAN_RD = 14;
    public static final int CHAN_OG = 15;
    public static final int CHAN_OG_SH = 16;
    public static final int CHAN_CSGATE = 17;
    public static final int CHAN_HEATER = 18;
    public static final int CHAN_CSGATE_1 = 17;
    public static final int CHAN_CSGATE_2 = 19;
    public static final int CHAN_CSGATE_3 = 20;
    public static final int CHAN_HEATER_1 = 18;
    public static final int CHAN_HEATER_2 = 21;
    public static final int ERROR_MASK_GD = 1;
    public static final int ERROR_MASK_OD = 2;
    public static final int ERROR_MASK_RD = 4;
    public static final int ERROR_MASK_SIZE = 3;
    private static final Map<Integer, Integer> dacMapReb0 = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> chanMapReb0;
    private static final Map<Integer, Integer> dacMapReb3;
    private static final Map<Integer, Integer> chanMapReb3;
    private static final Map<Integer, Integer> dacMapWreb1;
    private static final Map<Integer, Integer> chanMapWreb1;
    private static final Map<Integer, Integer> chanMapWreb2;
    private static final Set<Integer> wrebStripSet;
    private static final Map<Integer, Integer> dacMapGreb1;
    private static final Map<Integer, Integer> chanMapGreb1;
    private static final Map<Integer, Map> chanMapMap;
    private static final Map<Integer, Map> dacMapMap;
    private static final Map<Integer, Integer> dacErrorMap;
    BaseSet bss;

    public BoardDacs(BaseSet bss) {
        this.bss = bss;
    }

    public int getVersion() {
        try {
            return this.bss.getVersion(6);
        }
        catch (REBException e) {
            return -1;
        }
    }

    public int getNumStrips() throws REBException {
        return this.bss.getNumStrips();
    }

    public void loadAll() throws REBException {
        this.loadGlobal();
        this.loadStrip();
    }

    public void loadGlobal() throws REBException {
        for (int dac : this.getDacMap(this.getVersion()).keySet()) {
            if ((dac & 0x10) != 0) continue;
            this.load(dac);
        }
    }

    public void loadStrip() throws REBException {
        for (int strip = 0; strip < this.getNumStrips(); ++strip) {
            this.loadStrip(strip);
        }
    }

    public void loadStrip(int strip) throws REBException {
        int version = this.getVersion();
        if (version == 2 || version == 4) {
            this.load(1);
            this.load(2);
        } else {
            for (int dac : this.getDacMap(version).keySet()) {
                if ((dac & 0x10) == 0) continue;
                this.load(strip, dac);
            }
        }
    }

    public void load(int dac) throws REBException {
        if ((dac & 0x10) == 0) {
            int version = this.getVersion();
            if (version == 0) {
                return;
            }
            this.bss.write(this.getBase(version, dac, false) + 1, 0);
        } else {
            for (int strip = 0; strip < this.getNumStrips(); ++strip) {
                this.load(strip, dac);
            }
        }
    }

    public void load(int strip, int dac) throws REBException {
        int version = this.getVersion();
        this.bss.write(this.getBase(version, dac, true) + this.getStripOffset(version, strip, true) + 1, 0);
    }

    public void set(int chan, int value) throws REBException {
        this.set(chan, value, false);
    }

    public void set(int chan, int value, boolean load) throws REBException {
        int version = this.getVersion();
        int desc = this.getDescriptor(version, chan, false);
        int dac = desc >> 8 & 0xFF;
        int addr = this.getBase(version, dac, false) + 0;
        if (dac == 3) {
            this.bss.write(addr, 3670017);
            this.bss.write(addr, (desc & 0xFF) << 16 | (value & 0xFFF) << 4);
        } else {
            this.bss.write(addr, (desc & 0xFF) << 12 | value & 0xFFF);
        }
        if (load) {
            this.load(dac);
        }
    }

    public void set(int strip, int chan, int value) throws REBException {
        this.set(strip, chan, value, false);
    }

    public void set(int strip, int chan, int value, boolean load) throws REBException {
        int version = this.getVersion();
        if (version == 2 || version == 4) {
            int desc = this.getWrebDescriptor(version, strip, chan);
            int dac = desc >> 8 & 0xFF;
            this.bss.write(this.getBase(version, dac, false) + 0, (desc & 0xFF) << 12 | value & 0xFFF);
            if (load) {
                this.load(dac);
            }
        } else {
            int errorMask;
            int desc = this.getDescriptor(version, chan, true);
            int dac = desc >> 8 & 0xFF;
            this.bss.write(this.getBase(version, dac, true) + this.getStripOffset(version, strip, false) + 0, (desc & 0xFF) << 12 | value & 0xFFF | (version == 7 ? strip << 16 : 0));
            if (this.bss.getVersion(13, true) == 2 && ((errorMask = desc >> 16 << 3 * this.bss.convertStripNum(strip)) & this.getErrors()) != 0) {
                throw new REBException("Error setting " + this.getChanName(chan, strip) + " below threshold: back bias switch is closed");
            }
            if (load) {
                this.load(strip, dac);
            }
        }
    }

    public int getErrors() throws REBException {
        this.bss.checkVersion(13, 2);
        return this.bss.read(4194575) & 0xFFFF;
    }

    public int getUnders() throws REBException {
        this.bss.checkVersion(13, 2);
        return this.bss.read(4194575) >> 16;
    }

    public String getUndersString() throws REBException {
        int underMask = this.getUnders();
        StringBuilder underString = new StringBuilder();
        for (int strip = 0; strip < 3; ++strip) {
            for (int chan : dacErrorMap.keySet()) {
                if ((dacErrorMap.get(chan) << 3 * this.bss.convertStripNum(strip) & underMask) == 0) continue;
                underString.append(" ").append(this.getChanName(chan, strip));
            }
        }
        return underString.toString();
    }

    private int getBase(int version, int dac, boolean hasStrip) throws REBException {
        Integer base = this.getDacMap(version).get(dac);
        if (base == null || (dac & 0x10) != 0 != hasStrip) {
            throw new REBException("Invalid DAC number (" + dac + ")");
        }
        return (version == 0 ? 0x500001 : 0x400000) + base;
    }

    private int getStripOffset(int version, int strip, boolean isLoad) throws REBException {
        if (strip < 0 || strip >= this.getNumStrips()) {
            throw new REBException("Invalid strip number (" + strip + ")");
        }
        return version == 5 ? (isLoad ? strip : 0) : (version == 7 ? 0 : 16 * this.bss.convertStripNum(strip));
    }

    private Map<Integer, Integer> getDacMap(int version) {
        return dacMapMap.get(version);
    }

    private Map<Integer, Integer> getChanMap(int version) {
        return chanMapMap.get(version);
    }

    private int getDescriptor(int version, int chan, boolean hasStrip) throws REBException {
        Map<Integer, Integer> chanMap = this.getChanMap(version);
        Integer desc = chanMap.get(chan);
        if (desc == null || (desc >> 8 & 0x10) != 0 != hasStrip) {
            throw new REBException("Invalid channel number (" + chan + ")");
        }
        return desc;
    }

    private int getWrebDescriptor(int version, int strip, int chan) throws REBException {
        if (strip != 0) {
            throw new REBException("Invalid strip number (" + strip + ")");
        }
        if (!wrebStripSet.contains(chan)) {
            throw new REBException("Invalid channel number (" + chan + ")");
        }
        return this.getChanMap(version).get(chan);
    }

    private String getChanName(int chan, int strip) throws REBException {
        return (chan == 13 ? "GD" : (chan == 12 ? "OD" : (chan == 14 ? "RD" : "XX"))) + strip;
    }

    static {
        dacMapReb0.put(0, 0);
        dacMapReb0.put(1, 16);
        chanMapReb0 = new HashMap<Integer, Integer>();
        chanMapReb0.put(0, 0);
        chanMapReb0.put(2, 1);
        chanMapReb0.put(4, 2);
        chanMapReb0.put(6, 3);
        chanMapReb0.put(8, 4);
        chanMapReb0.put(10, 5);
        chanMapReb0.put(18, 6);
        chanMapReb0.put(21, 7);
        chanMapReb0.put(17, 256);
        chanMapReb0.put(19, 257);
        chanMapReb0.put(20, 258);
        dacMapReb3 = new HashMap<Integer, Integer>();
        dacMapReb3.put(0, 0);
        dacMapReb3.put(3, 16);
        dacMapReb3.put(16, 256);
        chanMapReb3 = new HashMap<Integer, Integer>();
        chanMapReb3.put(2, 0);
        chanMapReb3.put(0, 2);
        chanMapReb3.put(1, 1);
        chanMapReb3.put(10, 3);
        chanMapReb3.put(8, 5);
        chanMapReb3.put(9, 4);
        chanMapReb3.put(6, 16);
        chanMapReb3.put(4, 18);
        chanMapReb3.put(5, 17);
        chanMapReb3.put(18, 768);
        chanMapReb3.put(13, 69632);
        chanMapReb3.put(12, 135169);
        chanMapReb3.put(16, 4098);
        chanMapReb3.put(15, 4099);
        chanMapReb3.put(14, 266244);
        chanMapReb3.put(17, 4101);
        dacMapWreb1 = new HashMap<Integer, Integer>();
        dacMapWreb1.put(0, 0);
        dacMapWreb1.put(1, 16);
        dacMapWreb1.put(2, 256);
        chanMapWreb1 = new HashMap<Integer, Integer>();
        chanMapWreb1.put(0, 0);
        chanMapWreb1.put(1, 1);
        chanMapWreb1.put(2, 2);
        chanMapWreb1.put(3, 3);
        chanMapWreb1.put(4, 4);
        chanMapWreb1.put(5, 5);
        chanMapWreb1.put(6, 6);
        chanMapWreb1.put(7, 7);
        chanMapWreb1.put(8, 16);
        chanMapWreb1.put(9, 17);
        chanMapWreb1.put(10, 18);
        chanMapWreb1.put(11, 19);
        chanMapWreb1.put(17, 256);
        chanMapWreb1.put(18, 260);
        chanMapWreb1.put(21, 261);
        chanMapWreb1.put(12, 262);
        chanMapWreb1.put(13, 512);
        chanMapWreb1.put(14, 513);
        chanMapWreb1.put(15, 514);
        chanMapWreb1.put(16, 515);
        chanMapWreb2 = new HashMap<Integer, Integer>();
        chanMapWreb2.put(0, 0);
        chanMapWreb2.put(1, 1);
        chanMapWreb2.put(2, 2);
        chanMapWreb2.put(3, 3);
        chanMapWreb2.put(4, 4);
        chanMapWreb2.put(5, 5);
        chanMapWreb2.put(6, 6);
        chanMapWreb2.put(7, 7);
        chanMapWreb2.put(8, 16);
        chanMapWreb2.put(9, 17);
        chanMapWreb2.put(10, 18);
        chanMapWreb2.put(11, 19);
        chanMapWreb2.put(17, 258);
        chanMapWreb2.put(18, 260);
        chanMapWreb2.put(12, 261);
        chanMapWreb2.put(13, 512);
        chanMapWreb2.put(14, 513);
        chanMapWreb2.put(15, 514);
        chanMapWreb2.put(16, 515);
        wrebStripSet = new HashSet<Integer>();
        wrebStripSet.add(13);
        wrebStripSet.add(14);
        wrebStripSet.add(15);
        wrebStripSet.add(16);
        wrebStripSet.add(12);
        wrebStripSet.add(17);
        dacMapGreb1 = new HashMap<Integer, Integer>();
        dacMapGreb1.put(0, 0);
        dacMapGreb1.put(16, 256);
        chanMapGreb1 = new HashMap<Integer, Integer>();
        chanMapGreb1.put(0, 0);
        chanMapGreb1.put(1, 1);
        chanMapGreb1.put(2, 2);
        chanMapGreb1.put(3, 3);
        chanMapGreb1.put(4, 4);
        chanMapGreb1.put(5, 5);
        chanMapGreb1.put(6, 6);
        chanMapGreb1.put(7, 7);
        chanMapGreb1.put(8, 16);
        chanMapGreb1.put(9, 17);
        chanMapGreb1.put(10, 18);
        chanMapGreb1.put(11, 19);
        chanMapGreb1.put(18, 20);
        chanMapGreb1.put(13, 69632);
        chanMapGreb1.put(14, 266241);
        chanMapGreb1.put(15, 4098);
        chanMapGreb1.put(16, 4099);
        chanMapGreb1.put(17, 4100);
        chanMapGreb1.put(12, 135173);
        chanMapMap = new HashMap<Integer, Map>();
        chanMapMap.put(0, chanMapReb0);
        chanMapMap.put(1, chanMapReb0);
        chanMapMap.put(3, chanMapReb3);
        chanMapMap.put(6, chanMapReb3);
        chanMapMap.put(2, chanMapWreb1);
        chanMapMap.put(4, chanMapWreb2);
        chanMapMap.put(8, chanMapGreb1);
        chanMapMap.put(5, chanMapGreb1);
        chanMapMap.put(7, chanMapGreb1);
        dacMapMap = new HashMap<Integer, Map>();
        dacMapMap.put(0, dacMapReb0);
        dacMapMap.put(1, dacMapReb0);
        dacMapMap.put(3, dacMapReb3);
        dacMapMap.put(6, dacMapReb3);
        dacMapMap.put(2, dacMapWreb1);
        dacMapMap.put(4, dacMapWreb1);
        dacMapMap.put(8, dacMapGreb1);
        dacMapMap.put(5, dacMapGreb1);
        dacMapMap.put(7, dacMapGreb1);
        dacErrorMap = new HashMap<Integer, Integer>();
        dacErrorMap.put(13, 1);
        dacErrorMap.put(12, 2);
        dacErrorMap.put(14, 4);
    }
}

