/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.type;

import java.nio.Buffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nom.tam.util.type.PrimitiveType;
import nom.tam.util.type.PrimitiveTypes;

public final class PrimitiveTypeHandler {
    private static final int MAX_TYPE_VALUE = 256;
    private static final int BIT_PIX_OFFSET = 64;
    private static PrimitiveType<?>[] byBitPix = new PrimitiveType[129];
    private static PrimitiveType<?>[] byType = new PrimitiveType[256];
    private static Map<Class<?>, PrimitiveType<? extends Buffer>> byClass;

    public static <B extends Buffer> PrimitiveType<B> nearestValueOf(int bitPix) {
        if (bitPix >= PrimitiveTypes.FLOAT.bitPix() && bitPix < 0) {
            return PrimitiveTypes.FLOAT;
        }
        if (bitPix >= PrimitiveTypes.DOUBLE.bitPix() && bitPix < PrimitiveTypes.FLOAT.bitPix()) {
            return PrimitiveTypes.DOUBLE;
        }
        if (bitPix > 0 && bitPix <= PrimitiveTypes.BYTE.bitPix()) {
            return PrimitiveTypes.BYTE;
        }
        if (bitPix > PrimitiveTypes.BYTE.bitPix() && bitPix <= PrimitiveTypes.SHORT.bitPix()) {
            return PrimitiveTypes.SHORT;
        }
        if (bitPix > PrimitiveTypes.SHORT.bitPix() && bitPix <= PrimitiveTypes.INT.bitPix()) {
            return PrimitiveTypes.INT;
        }
        if (bitPix > PrimitiveTypes.INT.bitPix() && bitPix <= PrimitiveTypes.LONG.bitPix()) {
            return PrimitiveTypes.LONG;
        }
        return PrimitiveTypes.UNKNOWN;
    }

    public static PrimitiveType<Buffer> valueOf(char type) {
        return PrimitiveTypeHandler.cast(byType[type]);
    }

    public static <B extends Buffer> PrimitiveType<B> valueOf(Class<?> clazz) {
        PrimitiveType<? extends Buffer> primitiveType = byClass.get(clazz);
        if (primitiveType == null) {
            for (Class<?> interf : clazz.getInterfaces()) {
                primitiveType = byClass.get(interf);
                if (primitiveType == null) continue;
                return PrimitiveTypeHandler.cast(primitiveType);
            }
            return PrimitiveTypeHandler.valueOf(clazz.getSuperclass());
        }
        return PrimitiveTypeHandler.cast(primitiveType);
    }

    public static PrimitiveType<Buffer> valueOf(int bitPix) {
        return PrimitiveTypeHandler.cast(byBitPix[bitPix + 64]);
    }

    private static <B extends Buffer> PrimitiveType<B> cast(PrimitiveType<?> primitiveType) {
        return primitiveType;
    }

    private static PrimitiveType<?>[] values() {
        return new PrimitiveType[]{PrimitiveTypes.BOOLEAN, PrimitiveTypes.BYTE, PrimitiveTypes.CHAR, PrimitiveTypes.DOUBLE, PrimitiveTypes.FLOAT, PrimitiveTypes.INT, PrimitiveTypes.LONG, PrimitiveTypes.SHORT, PrimitiveTypes.STRING, PrimitiveTypes.UNKNOWN};
    }

    private PrimitiveTypeHandler() {
    }

    static {
        HashMap initialByClass = new HashMap();
        for (PrimitiveType<?> type : PrimitiveTypeHandler.values()) {
            if (type.bitPix() != 0) {
                PrimitiveTypeHandler.byBitPix[type.bitPix() + 64] = type;
            }
            PrimitiveTypeHandler.byType[type.type()] = type;
            initialByClass.put(type.primitiveClass(), type);
            initialByClass.put(type.wrapperClass(), type);
            if (type.bufferClass() == null) continue;
            initialByClass.put(type.bufferClass(), type);
        }
        byClass = Collections.unmodifiableMap(initialByClass);
    }
}

