/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.elog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ElogEntry {
    private String author;
    private String category;
    private String formName = "default";
    private boolean formatted = false;
    private ArrayList<String> tags = new ArrayList();
    private Hashtable<String, String> formFields = new Hashtable();
    private Hashtable<String, byte[]> images = new Hashtable();
    private Hashtable<String, byte[]> attachments = new Hashtable();

    public void addTag(String tagName) {
        this.tags.add(tagName);
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setFormatted(boolean formatted) {
        this.formatted = formatted;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public void setFormField(String fieldName, String fieldValue) {
        this.formFields.put(fieldName, fieldValue);
    }

    public void addImage(String name, byte[] imageBytes) {
        this.images.put(name, imageBytes);
    }

    public void addAttachment(String name, byte[] attachmentBytes) {
        this.attachments.put(name, attachmentBytes);
    }

    public String getAuthor() {
        return this.author;
    }

    public String getCategory() {
        return this.category;
    }

    public String getFormName() {
        return this.formName;
    }

    public boolean isFormatted() {
        return this.formatted;
    }

    public Set<String> getImages() {
        return this.images.keySet();
    }

    public Set<String> getAttachments() {
        return this.attachments.keySet();
    }

    public static boolean isFileImage(String fileName) {
        String fn = fileName.toLowerCase();
        return fn.endsWith("gif") || fn.endsWith("jpeg") || fn.endsWith("png") || fn.endsWith("tiff") || fn.endsWith("jpg");
    }

    public void addFile(String name, File file) throws FileNotFoundException, IOException {
        boolean isImage = ElogEntry.isFileImage(name);
        FileInputStream fis = new FileInputStream(file);
        byte[] byteArray = IOUtils.toByteArray((InputStream)fis);
        if (isImage) {
            this.addImage(name, byteArray);
        } else {
            this.addAttachment(name, byteArray);
        }
    }

    public void removeAttachment(String name, boolean isImage) {
        if (isImage) {
            this.images.remove(name);
        } else {
            this.attachments.remove(name);
        }
    }

    public String toXML() {
        Element entryElement = new Element("entry");
        if (this.author != null) {
            entryElement.setAttribute("author", this.author);
        }
        if (this.category != null) {
            entryElement.setAttribute("category", this.category);
        }
        if (this.formatted) {
            entryElement.setAttribute("formatted", "formatted");
        }
        Element formElement = new Element("form");
        entryElement.addContent((Content)formElement);
        formElement.setAttribute("name", this.formName);
        for (String field : this.formFields.keySet()) {
            Element fieldElement = new Element("field");
            fieldElement.setAttribute("name", field);
            fieldElement.setText(this.formFields.get(field));
            formElement.addContent((Content)fieldElement);
        }
        for (String tag : this.tags) {
            Element tagElement = new Element("tag");
            tagElement.setAttribute("name", tag);
            entryElement.addContent((Content)tagElement);
        }
        for (String image : this.images.keySet()) {
            Element imageElement = new Element("attachment");
            imageElement.setAttribute("type", "image");
            imageElement.setAttribute("filename", image);
            imageElement.setText(new String(Base64.encodeBase64((byte[])this.images.get(image))));
            entryElement.addContent((Content)imageElement);
        }
        for (String attachment : this.attachments.keySet()) {
            Element attachmentElement = new Element("attachment");
            attachmentElement.setAttribute("type", "file");
            attachmentElement.setAttribute("filename", attachment);
            attachmentElement.setText(new String(Base64.encodeBase64((byte[])this.attachments.get(attachment))));
            entryElement.addContent((Content)attachmentElement);
        }
        Document myDocument = new Document(entryElement);
        XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
        String xmlString = outputter.outputString(myDocument).replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "").trim();
        return xmlString;
    }

    public void reset() {
        this.tags.clear();
        this.images.clear();
        this.attachments.clear();
        this.formFields.clear();
    }
}

