/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.Updatable;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

public class DisplayChannelMulti
implements DisplayChannel {
    private final String path;
    private ArrayList<AgentChannel> channels;
    private Updatable target;

    public DisplayChannelMulti(String path) {
        this.path = path;
        this.channels = new ArrayList(1);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Updatable getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Updatable target) {
        this.target = target;
    }

    @Override
    public List<AgentChannel> getChannels() {
        return Collections.unmodifiableList(this.channels);
    }

    @Override
    public void setChannel(AgentChannel channel) {
        this.channels = new ArrayList(1);
        if (channel != null) {
            this.channels.add(channel);
        }
    }

    @Override
    public void setChannels(Collection<AgentChannel> channels) {
        this.channels = new ArrayList<AgentChannel>(channels);
    }

    @Override
    public void addChannel(AgentChannel channel) {
        String p = channel.getPath();
        ListIterator<AgentChannel> it = this.channels.listIterator();
        while (it.hasNext()) {
            AgentChannel ch = it.next();
            if (ch == channel) {
                return;
            }
            if (!ch.getPath().equals(p)) continue;
            it.set(channel);
            return;
        }
        this.channels.add(channel);
        this.channels.trimToSize();
    }

    @Override
    public void appendChannel(AgentChannel channel) {
        this.channels.ensureCapacity(this.channels.size() + 1);
        this.channels.add(channel);
    }

    @Override
    public boolean removeChannel(String path) {
        ListIterator<AgentChannel> it = this.channels.listIterator();
        while (it.hasNext()) {
            AgentChannel ch = it.next();
            if (!ch.getPath().equals(path)) continue;
            it.remove();
            break;
        }
        return this.channels.isEmpty();
    }

    @Override
    public boolean purgeOfflineChannels(List<String> agentNames) {
        Iterator<AgentChannel> it = this.channels.iterator();
        while (it.hasNext()) {
            AgentChannel channel = it.next();
            if (!agentNames.contains(channel.getAgentName()) || !DataProviderState.OFF_LINE.equals(channel.get(AgentChannel.Key.STATE))) continue;
            it.remove();
        }
        this.channels.trimToSize();
        return this.channels.isEmpty();
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object obj) {
        return obj instanceof DisplayChannel && ((DisplayChannel)obj).getPath().equals(this.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }
}

