/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.provider.param.base;

import java.lang.reflect.Array;
import nom.tam.fits.compression.provider.param.api.ICompressColumnParameter;
import nom.tam.fits.compression.provider.param.base.CompressParameter;

public abstract class CompressColumnParameter<T, OPTION>
extends CompressParameter<OPTION>
implements ICompressColumnParameter {
    protected T column;
    private final Class<T> clazz;
    private int size;
    protected CompressColumnParameter<T, OPTION> original;

    protected CompressColumnParameter(String name, OPTION option, Class<T> clazz) {
        super(name, option);
        this.clazz = clazz;
    }

    public T column() {
        return this.column;
    }

    @Override
    public void column(Object columnValue, int sizeValue) {
        this.column = this.clazz.cast(columnValue);
        this.size = sizeValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final T initializedColumn() {
        if (this.original != null) {
            return this.original.initializedColumn();
        }
        int arraySize = this.size;
        Class<T> arrayClass = this.clazz;
        CompressColumnParameter compressColumnParameter = this;
        synchronized (compressColumnParameter) {
            if (this.column == null) {
                this.column = arrayClass.cast(Array.newInstance(arrayClass.getComponentType(), arraySize));
            }
        }
        return this.column;
    }

    protected final T originalColumn() {
        if (this.original != null) {
            return this.original.originalColumn();
        }
        return this.column;
    }

    public void setOriginal(CompressColumnParameter<T, OPTION> value) {
        this.original = value;
    }
}

