/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header;

import nom.tam.fits.header.FitsHeaderImpl;
import nom.tam.fits.header.IFitsHeader;

public enum InstrumentDescription implements IFitsHeader
{
    APERTURE(IFitsHeader.SOURCE.UNKNOWN, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "name of field of view aperture"),
    DATAMODE(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "pre-processor data mode"),
    DETNAM(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "name of the detector used to make the observation"),
    FILTER(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "name of filter used during the observation"),
    FILTERn(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "name of filters used during the observation"),
    GRATING(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "name of the grating used during the observation."),
    GRATINGn(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "name of gratings used during the observation."),
    OBS_MODE(IFitsHeader.SOURCE.HEASARC, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "instrumental mode of the observation"),
    SATURATE(IFitsHeader.SOURCE.STScI, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.INTEGER, "Data value at which saturation occurs");

    private final IFitsHeader key;

    private InstrumentDescription(IFitsHeader.SOURCE status, IFitsHeader.HDU hdu, IFitsHeader.VALUE valueType, String comment) {
        this.key = new FitsHeaderImpl(this.name(), status, hdu, valueType, comment);
    }

    @Override
    public String comment() {
        return this.key.comment();
    }

    @Override
    public IFitsHeader.HDU hdu() {
        return this.key.hdu();
    }

    @Override
    public String key() {
        return this.key.key();
    }

    @Override
    public IFitsHeader n(int ... number) {
        return this.key.n(number);
    }

    @Override
    public IFitsHeader.SOURCE status() {
        return this.key.status();
    }

    @Override
    public IFitsHeader.VALUE valueType() {
        return this.key.valueType();
    }
}

