/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.time.Instant;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.utilities.location.Location;

public class Camera {
    private final Store store;
    private final long camera;
    public static final int OPCODE_STEP = 31;

    Camera(Store store, long camera) {
        this.store = store;
        this.camera = camera;
    }

    public void setRegisterList(Location.LocationType rebType, int[] registerAddresses) throws DAQException {
        this.store.setRegisterList(this.camera, rebType, registerAddresses);
    }

    public Image triggerImage(ImageMetaData meta) throws DAQException {
        return new Image(this.store, this.store.triggerImage(this.camera, meta));
    }

    public Instant startSequencer(int opcode) throws DAQException {
        long timestampNanos = this.store.startSequencer(this.camera, opcode);
        return Instant.ofEpochSecond(timestampNanos / 1000000000L, timestampNanos % 1000000000L);
    }

    void detach() throws DAQException {
        this.store.detachCamera(this.camera);
    }
}

