/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.time.Instant;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.daq.ims.SourceMetaData;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.daq.ims.StoreImplementation;
import org.lsst.ccs.daq.ims.StoreSimulation;
import org.lsst.ccs.daq.ims.Version;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

class StoreSimulatedImplementation
implements StoreImplementation {
    StoreSimulation storeSimulation = StoreSimulation.instance();
    private final Random random = new Random();
    private final Version release = new Version("daq-simulation", this.toNanos(Instant.now()), false, 12345);
    private final SynchronousQueue<ImageMetaData> queue = new SynchronousQueue();
    private final Map<Location.LocationType, int[]> registerLists = new HashMap<Location.LocationType, int[]>();

    StoreSimulatedImplementation() {
    }

    @Override
    public long attachStore(String partition) throws DAQException {
        return 100L;
    }

    @Override
    public void detachStore(long store) throws DAQException {
    }

    @Override
    public long attachCamera(long store) throws DAQException {
        return 101L;
    }

    @Override
    public void detachCamera(long camera) throws DAQException {
    }

    @Override
    public long attachClient(String partition) throws DAQException {
        return 102L;
    }

    @Override
    public void detachClient(long client) throws DAQException {
    }

    @Override
    public int[][] readRegisters(long client, BitSet bitset, int[] addresses) throws DAQException {
        int[][] result = new int[100][addresses.length];
        LocationSet locations = new LocationSet(bitset);
        for (Location l : locations) {
            for (int i = 0; i < addresses.length; ++i) {
                result[l.index()][i] = this.storeSimulation.readRegister(l, addresses[i]);
            }
        }
        return result;
    }

    @Override
    public void writeRegisters(long client, BitSet bitset, int[] addresses, int[] values) throws DAQException {
        LocationSet locations = new LocationSet(bitset);
        for (Location l : locations) {
            for (int i = 0; i < addresses.length; ++i) {
                this.storeSimulation.writeRegister(l, addresses[i], values[i]);
            }
        }
    }

    @Override
    public long capacity(long store) throws DAQException {
        return 500000000000L;
    }

    @Override
    public long remaining(long store) throws DAQException {
        return 250000000000L;
    }

    @Override
    public void listFolders(long store, List<String> result) throws DAQException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int insertFolder(long store, String folderName) throws DAQException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removeFolder(long store, String folderName) throws DAQException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean findFolder(long store, String folderName) throws DAQException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void listImages(long store, String folderName, List<ImageMetaData> result) throws DAQException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int moveImageToFolder(long store, long id, String folderName) throws DAQException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int deleteImage(long store, long id) throws DAQException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SourceMetaData findSource(long store, long id, int location) throws DAQException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ImageMetaData addImageToFolder(long store, String imageName, String folderName, String annotation, int opcode, BitSet elements) throws DAQException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ImageMetaData findImage(long store, String imageName, String folderName) throws DAQException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long openSourceChannel(long store, long id, int index, boolean write) throws DAQException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SourceMetaData addSourceToImage(long store, long id, int index, byte type, String platform, int[] registerValues) throws DAQException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long attachStream(long store, int sourceTimeoutMicros) throws DAQException {
        return 11111L;
    }

    @Override
    public void detachStream(long stream) throws DAQException {
    }

    @Override
    public int waitForImage(Store callback, long store, long stream1, long stream2, int imageTimeoutMicros, int sourceTimeoutMicros) throws DAQException {
        try {
            ImageMetaData meta;
            ImageMetaData imageMetaData = meta = imageTimeoutMicros == 0 ? this.queue.take() : this.queue.poll(imageTimeoutMicros, TimeUnit.MICROSECONDS);
            if (meta == null) {
                return 68;
            }
            callback.imageCreatedCallback(meta);
            TimeUnit.MICROSECONDS.sleep(sourceTimeoutMicros / 2);
            callback.imageCompleteCallback(meta);
            return 0;
        }
        catch (InterruptedException ex) {
            throw new DAQException("Interrupt while waiting for image");
        }
    }

    @Override
    public String decodeException(int rc) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BitSet getConfiguredSources(long store) throws DAQException {
        return LocationSet.all().getBitSet();
    }

    @Override
    public Version getClientVersion() throws DAQException {
        return this.release;
    }

    @Override
    public void setRegisterList(long store, long camera, Location.LocationType type, int[] registerList) throws DAQException {
        this.registerLists.put(type, registerList);
    }

    @Override
    public ImageMetaData triggerImage(long store, long camera, ImageMetaData meta) throws DAQException {
        Instant now = Instant.now();
        long id = this.random.nextLong();
        this.storeSimulation.fireTrigger(meta.getOpcode(), meta, this.registerLists);
        ImageMetaData result = new ImageMetaData(id, this.release, now, meta);
        this.queue.offer(result);
        return result;
    }

    @Override
    public long startSequencer(long camera, int opcode) throws DAQException {
        Instant now = Instant.now();
        this.storeSimulation.fireTrigger(opcode, null, null);
        return this.toNanos(now);
    }

    private long toNanos(Instant instant) {
        return instant.getEpochSecond() * 1000000000L + (long)instant.getNano();
    }
}

