/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb.sim;

import java.util.Random;
import org.lsst.ccs.drivers.reb.sim.AddressSpace;
import org.lsst.ccs.drivers.reb.sim.RegisterSet;
import org.lsst.ccs.drivers.reb.sim.SequencerSimulation;
import org.lsst.ccs.drivers.reb.sim.SimulationException;

public class REB3Simulation
extends AddressSpace {
    private static final int MASK_RSET_STATUS = 1;
    private static final int MASK_RSET_SEQUENCER = 4;
    private static final int MASK_RSET_TEMP_ADCS = 16;
    private static final int MASK_RSET_TIME_BASE = 2;
    private static final int MASK_RSET_POWER_ADCS = 8;
    private static final int MASK_RSET_FAST_ADCS = 32;
    private static final int MASK_MBZ = -64;
    private static final int RESERVED = 0;
    private static final int NUM_STRIPS = 3;
    private volatile boolean timeEnabled;
    private long baseTime;
    private long enableTime;
    private final long[] triggerTime = new long[32];
    private long serial;
    private final Random random = new Random();
    private SequencerSimulation sequencer;
    private SensorsSimulation sensors;
    private AspicSimulation aspics;
    private boolean backBias = false;
    private final int[][] boardDacs = new int[3][6];
    private RTDSimulation rtds;
    private final boolean supportMultiMains;

    public REB3Simulation(int id, boolean supportMultiMains) {
        this.supportMultiMains = supportMultiMains;
        this.init(id);
    }

    private void init(int id) {
        this.add(new RegisterSet.ConstantRegister(0, 0));
        this.add(new RegisterSet.ConstantRegister(1, this.supportMultiMains ? 825774086 : -1340079869));
        this.add(new RegisterSet.ConstantRegister(2, id));
        this.add(new RegisterSet.ConstantRegister(3, 0));
        this.add(new TimeBaseRegisterSet(4));
        this.add(new RegisterSet.ConstantRegister(6, 0));
        this.add(new RegisterSet.ConstantRegister(7, 0));
        this.add(new StateRegister(8));
        this.add(new TriggerRegister(9));
        this.add(new RegisterSet.LongArrayRegisterSet(10, this.triggerTime));
        this.add(new StartRebSerialNumberRegister(0x800000));
        this.add(new SerialNumberRegister(0x800001));
        this.add(new BackBiasRegister(0xD00000));
        for (int stripe = 0; stripe < 3; ++stripe) {
            this.add(new BoardDacsRegister(stripe));
            this.add(new BoardDacsActivateRegister(stripe));
        }
        this.add(new UndersRegister());
        this.sensors = new SensorsSimulation(this);
        this.aspics = new AspicSimulation(this);
        this.sequencer = new SequencerSimulation(this);
        this.rtds = new RTDSimulation(this);
        this.sequencer.addStateListener((oldState, newState) -> {
            if (!newState.isRunning()) {
                this.triggerTime[2] = this.getTime();
            }
        });
    }

    private void setEnableTimer(boolean enabled) {
        if (this.timeEnabled != enabled) {
            if (enabled) {
                this.triggerTime[1] = this.getTime();
                this.enableTime = System.nanoTime();
                this.timeEnabled = true;
            } else {
                this.baseTime = this.getTime();
                this.timeEnabled = false;
                this.triggerTime[1] = this.getTime();
            }
        }
    }

    private void setStartSequencer(boolean enabled) {
        if (enabled) {
            this.triggerTime[2] = this.getTime();
            this.sequencer.start();
        }
    }

    private long getTime() {
        if (this.timeEnabled) {
            long nanosSinceEnabled = System.nanoTime() - this.enableTime;
            return this.baseTime + nanosSinceEnabled / 10L;
        }
        return this.baseTime;
    }

    public SequencerSimulation getSequencer() {
        return this.sequencer;
    }

    long getTriggerTime(int offset) {
        return this.triggerTime[offset];
    }

    private static class AspicSimulation {
        private int biasMux;
        private int samMux;
        private int adcMux;
        private int range;
        private final int[] aspicTemps = new int[6];

        AspicSimulation(AddressSpace addressSpace) {
            addressSpace.add(new AspicStartRegister(0x600100));
            addressSpace.add(new AspicMuxConfigRegister(0x600101));
            for (int offset = 0; offset < 6; ++offset) {
                addressSpace.add(new AspicTempRegister(offset));
            }
            addressSpace.add(new MuxReadRegister(0x601010));
            addressSpace.add(new RegisterSet.SimpleRegisterSet(0xB00000, 2){

                @Override
                int readSimple(int relativeAddress) {
                    return 0;
                }

                @Override
                void writeSimple(int relativeAddress, int value) {
                }
            });
        }

        private class MuxReadRegister
        extends RegisterSet.ReadOnlyRegister {
            MuxReadRegister(int address) {
                super(address);
            }

            @Override
            public int read() {
                int offset = AspicSimulation.this.range >= 5 ? 0 : 2048;
                return offset;
            }
        }

        private class AspicTempRegister
        extends RegisterSet.ReadOnlyRegister {
            private final int offset;

            AspicTempRegister(int offset) {
                super(0x601000 + offset);
                this.offset = offset;
            }

            @Override
            public int read() {
                return AspicSimulation.this.aspicTemps[this.offset];
            }
        }

        private class AspicMuxConfigRegister
        extends RegisterSet.WriteOnlyRegister {
            AspicMuxConfigRegister(int address) {
                super(address);
            }

            @Override
            public void write(int value) {
                AspicSimulation.this.range = value >>> 1 & 0xF;
                AspicSimulation.this.adcMux = value >>> 5 & 0xF;
                AspicSimulation.this.biasMux = value >>> 16 & 7;
                AspicSimulation.this.samMux = value >>> 19 & 7;
            }
        }

        private class AspicStartRegister
        extends RegisterSet.WriteOnlyRegister {
            AspicStartRegister(int address) {
                super(address);
            }

            @Override
            public void write(int value) {
            }
        }
    }

    private static class RTDSimulation {
        RTDSimulation(AddressSpace addressSpace) {
            addressSpace.add(new RegisterSet.WriteOnlyRegister(0x700000){

                @Override
                public void write(int value) {
                }
            });
            addressSpace.add(new RegisterSet.ReadOnlyRegister(0x700001){

                @Override
                public int read() {
                    return 0x400000;
                }
            });
            addressSpace.add(new RegisterSet.WriteOnlyRegister(0x700002){

                @Override
                public void write(int value) {
                }
            });
        }
    }

    private static class SensorsSimulation {
        SensorsSimulation(AddressSpace addressSpace) {
            addressSpace.add(new VoltageSensorRegister(0, 5.0f));
            addressSpace.add(new VoltageSensorRegister(2, 7.0f));
            addressSpace.add(new VoltageSensorRegister(4, 15.0f));
            addressSpace.add(new VoltageSensorRegister(6, 40.0f));
            addressSpace.add(new VoltageSensorRegister(8, -15.0f));
            addressSpace.add(new CurrentSensorRegister(1, 0.01f, 2.5E-5f));
            addressSpace.add(new CurrentSensorRegister(3, 0.01f, 2.5E-5f));
            addressSpace.add(new CurrentSensorRegister(5, 0.001f, 8.0E-6f));
            addressSpace.add(new CurrentSensorRegister(7, 0.001f, 8.0E-6f));
            addressSpace.add(new CurrentSensorRegister(9, 0.001f, 8.0E-6f));
            for (int offset = 0; offset < 11; ++offset) {
                addressSpace.add(new TemperatureSensorRegister(offset, 25.0f));
            }
        }

        private class TemperatureSensorRegister
        extends RegisterSet.ReadOnlyRegister {
            private final float temperature;
            private final float delta;
            private final Random r;

            TemperatureSensorRegister(int offset, float temperature) {
                super(0x600010 + offset);
                this.r = new Random();
                this.temperature = temperature;
                this.delta = 0.1f * temperature + 1.0f;
            }

            @Override
            public int read() {
                return (int)((double)(this.temperature + this.r.nextFloat() * this.delta) / 0.0078125);
            }
        }

        private class CurrentSensorRegister
        extends RegisterSet.ReadOnlyRegister {
            private final float current;
            private final float resolution;
            private final Random r;
            private final float delta;

            CurrentSensorRegister(int offset, float current, float resolution) {
                super(0x600000 + offset);
                this.r = new Random();
                this.current = current;
                this.resolution = resolution;
                this.delta = 0.1f * current;
            }

            @Override
            public int read() {
                return (int)((this.current + this.r.nextFloat() * this.delta) / this.resolution);
            }
        }

        private class VoltageSensorRegister
        extends RegisterSet.ReadOnlyRegister {
            private final Random r;
            private final float delta;
            private final float voltage;

            VoltageSensorRegister(int offset, float voltage) {
                super(0x600000 + offset);
                this.r = new Random();
                this.voltage = voltage;
                this.delta = 0.1f * voltage;
            }

            @Override
            public int read() {
                return (int)((double)(this.voltage + this.r.nextFloat() * this.delta) / 0.025);
            }
        }
    }

    private class UndersRegister
    extends RegisterSet.ReadOnlyRegister {
        UndersRegister() {
            super(4194575);
        }

        @Override
        public int read() {
            return 0x1FF0000;
        }
    }

    private class BoardDacsActivateRegister
    extends RegisterSet.WriteOnlyRegister {
        private final int stripe;

        BoardDacsActivateRegister(int stripe) {
            super(0x400000 + (stripe << 4) + 257);
            this.stripe = stripe;
        }

        @Override
        public void write(int value) {
        }
    }

    private class BoardDacsRegister
    extends RegisterSet.WriteOnlyRegister {
        private final int stripe;

        BoardDacsRegister(int stripe) {
            super(0x400000 + (stripe << 4) + 256);
            this.stripe = stripe;
        }

        @Override
        public void write(int value) {
            int o = value >>> 12 & 0xF;
            ((REB3Simulation)REB3Simulation.this).boardDacs[this.stripe][o] = value & 0xFFF;
        }
    }

    private class BackBiasRegister
    extends RegisterSet.Register {
        BackBiasRegister(int address) {
            super(address);
        }

        @Override
        public int read() {
            return REB3Simulation.this.backBias ? 1 : 0;
        }

        @Override
        public void write(int value) {
            REB3Simulation.this.backBias = (value & 1) != 0;
        }
    }

    private class SerialNumberRegister
    extends RegisterSet.ReadOnlyLongRegister {
        SerialNumberRegister(int address) {
            super(address);
        }

        @Override
        public long read() {
            return REB3Simulation.this.serial;
        }
    }

    private class StartRebSerialNumberRegister
    extends RegisterSet.WriteOnlyRegister {
        StartRebSerialNumberRegister(int address) {
            super(address);
        }

        @Override
        public void write(int value) {
            REB3Simulation.this.serial = REB3Simulation.this.random.nextLong() & 0xFFFFFFFFFFFFL;
            REB3Simulation.this.serial = REB3Simulation.this.serial | 0x1000000000000L;
        }
    }

    private class TriggerRegister
    extends RegisterSet.Register {
        public TriggerRegister(int address) {
            super(address);
        }

        @Override
        public int read() {
            int result = 0;
            if (REB3Simulation.this.timeEnabled) {
                result |= 2;
            }
            if (REB3Simulation.this.sequencer.getState().isRunning()) {
                result |= 4;
            }
            return result;
        }

        @Override
        public void write(int value) {
            if ((value & 0xFFFFFFC0) != 0) {
                throw new SimulationException("Illegal trigger bit set %08x", value);
            }
            REB3Simulation.this.setEnableTimer((value & 2) != 0);
            REB3Simulation.this.setStartSequencer((value & 4) != 0);
        }
    }

    private class StateRegister
    extends RegisterSet.ReadOnlyRegister {
        public StateRegister(int address) {
            super(address);
        }

        @Override
        public int read() {
            int result = 0;
            if (REB3Simulation.this.timeEnabled) {
                result |= 2;
            }
            if (REB3Simulation.this.sequencer.getState().isRunning()) {
                result |= 4;
            }
            return result;
        }
    }

    private class TimeBaseRegisterSet
    extends RegisterSet.SimpleLongRegisterSet {
        TimeBaseRegisterSet(int address) {
            super(address, 1);
        }

        @Override
        long readLong(int index) {
            return REB3Simulation.this.getTime();
        }

        @Override
        void writeLong(int index, long longValue) {
            if (REB3Simulation.this.timeEnabled) {
                throw new SimulationException("Attempt to write to TimeBase while enabled");
            }
            REB3Simulation.this.baseTime = longValue;
        }
    }
}

