/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui.jas;

import java.util.HashMap;
import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.subsystem.common.focalplane.data.HasFocalPlaneData;
import org.lsst.ccs.subsystem.power.ui.RebPowerControlPanel;
import org.lsst.ccs.subsystem.power.ui.jas.RebPowerStateFilter;

@Plugin(name="Reb Power Control plugin", description="Displays Reb power state including HV bias and DPhi")
public class RebPowerControlPlugin
extends ConsolePlugin {
    private final OptionalPage apcpduOptionalPage = new RebPowerControlOptionalPage();

    public void initialize() {
        OptionalPage.getService().add((OptionalPage)new RebPowerControlPanel.OptPage());
    }

    static class RebPowerControlOptionalPage
    implements OptionalPage {
        private HashMap<String, MonitorView> views = new HashMap();

        RebPowerControlOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            if (agent.getAgentProperty("agentCategory", "").equals(AgentCategory.POWER.name()) && !agent.getAgentProperty(HasFocalPlaneData.AGENT_PROPERTY, "").isEmpty()) {
                return "CCS Subsystems/" + agent.getName() + "/Reb Power Control";
            }
            return null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            SectionedTableView view = new SectionedTableView();
            view.setFormatter(RebPowerStateFilter.FORMAT);
            RebPowerStateFilter filter = new RebPowerStateFilter(agent);
            view.setFilter((AgentChannelsFilter)filter);
            view.setName(agent.getName() + ":RebPowerControl");
            this.views.put(this.getPage(agent), (MonitorView)view);
            return view.getPanel();
        }

        public void opened(String page) {
            MonitorView view = this.views.get(page);
            if (view != null) {
                view.install();
            }
        }

        public void closed(String page) {
            MonitorView view = this.views.remove(page);
            if (view != null) {
                view.uninstall();
            }
        }
    }
}

