/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.taitime;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.taitime.LeapSecondReader;
import org.lsst.ccs.utilities.taitime.TAITime;
import org.lsst.ccs.utilities.taitime.TimeStorage;

public class CCSTimeStamp
implements Serializable {
    private static final long serialVersionUID = 6264466048267081974L;
    private static volatile boolean initializationNeeded = true;
    private static TAITime times;
    private static LeapSecondReader reader;
    private final Instant taiInstant;
    private final Instant utcInstant;
    private static final Instant INVALID_INSTANT;
    private static final Logger LOG;

    public static CCSTimeStamp currentTime() {
        return new CCSTimeStamp();
    }

    public static CCSTimeStamp currentTimeFromMillis(long milliseconds) {
        return new CCSTimeStamp(milliseconds);
    }

    private CCSTimeStamp(long milliseconds) {
        if (TAITime.isStrict()) {
            throw new RuntimeException("Cannot use in strict mode !");
        }
        if (milliseconds == 0L || milliseconds == -1L) {
            LOG.log(Level.WARNING, "Creating invalid instant version of CCSTimeStamp for milliseconds: {0}", milliseconds);
            this.utcInstant = INVALID_INSTANT;
            this.taiInstant = INVALID_INSTANT;
        } else {
            this.utcInstant = Instant.ofEpochMilli(milliseconds);
            int leapSecond = CCSTimeStamp.getReader().getNumberOfLeapSeconds(milliseconds);
            this.taiInstant = this.utcInstant.plusSeconds(leapSecond);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LeapSecondReader getReader() {
        Class<CCSTimeStamp> clazz = CCSTimeStamp.class;
        synchronized (CCSTimeStamp.class) {
            block10: {
                if (reader == null) {
                    try {
                        try {
                            reader = new LeapSecondReader();
                        }
                        catch (IOException x) {
                            URL leapURL = BootstrapResourceUtils.getResourceURL((String)"leap-seconds.list");
                            if (leapURL != null) {
                                reader = new LeapSecondReader(leapURL);
                                LOG.warning("Unable to read default leap second file, falling back to reading local copy from bootstrap path");
                                long expires = reader.getExpiryDate();
                                if (expires != 0L && expires < System.currentTimeMillis()) {
                                    LOG.log(Level.SEVERE, "Leap second data read from {0} has expired", leapURL);
                                }
                                break block10;
                            }
                            throw x;
                        }
                    }
                    catch (IOException x) {
                        throw new RuntimeException("Leap second file can not be loaded", x);
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CCSTimeStamp() {
        Class<CCSTimeStamp> clazz = CCSTimeStamp.class;
        synchronized (CCSTimeStamp.class) {
            if (initializationNeeded) {
                times = new TAITime();
                if (!times.isConfigured()) {
                    CCSTimeStamp.getReader();
                }
                initializationNeeded = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (times.isConfigured()) {
                TimeStorage store = times.getTime();
                this.taiInstant = Instant.ofEpochSecond(store.getTimeSecsTAI(), store.getTimeNanoTAI());
                this.utcInstant = Instant.ofEpochSecond(store.getTimeSecsUTC(), store.getTimeNanoUTC());
            } else {
                this.utcInstant = Instant.now();
                int leapSecond = reader.getNumberOfLeapSeconds(this.utcInstant.toEpochMilli());
                this.taiInstant = this.utcInstant.plusSeconds(leapSecond);
            }
            return;
        }
    }

    public Instant getTAIInstant() {
        return this.taiInstant;
    }

    public Instant getUTCInstant() {
        return this.utcInstant;
    }

    public double getTAIDouble() {
        return (double)this.taiInstant.getEpochSecond() + (double)this.taiInstant.getNano() / 1.0E9;
    }

    public double getUTCDouble() {
        return (double)this.utcInstant.getEpochSecond() + (double)this.utcInstant.getNano() / 1.0E9;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CCSTimeStamp) {
            CCSTimeStamp ts = (CCSTimeStamp)obj;
            return this.taiInstant.equals(ts.taiInstant) && this.utcInstant.equals(ts.utcInstant);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.taiInstant);
        hash = 67 * hash + Objects.hashCode(this.utcInstant);
        return hash;
    }

    public String toString() {
        return "CCSTimeStamp{utc=" + this.utcInstant + "}";
    }

    static {
        INVALID_INSTANT = Instant.ofEpochMilli(0L);
        LOG = Logger.getLogger(CCSTimeStamp.class.getName());
    }
}

