/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.example;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.ByteChannel;
import java.util.Set;
import nom.tam.fits.TruncatedFileException;
import org.lsst.ccs.daq.ims.Catalog;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Folder;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.daq.ims.channel.FitsIntReader;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

public class FitsWriter {
    public static void main(String[] args) throws DAQException, IOException, TruncatedFileException {
        Store store = new Store("dev");
        Catalog catalog = store.getCatalog();
        Folder testFolder = catalog.find("tonyj-test");
        Image old = testFolder.find("Flat_screen_0000_20190322172301");
        old.delete();
        ImageMetaData meta = new ImageMetaData("Flat_screen_0000_20190322172301", "raw", "Image Annotation", 0, (Set<Location>)LocationSet.of((String[])new String[]{"R22/Reb0"}));
        Image image = testFolder.insert(meta);
        File dir = new File("/home/tonyj/Data/pretty/");
        File[] files = dir.listFiles((dir1, name) -> name.matches("1\\d_Flat_screen_0000_20190322172301.fits"));
        try (FitsIntReader reader = new FitsIntReader(Location.LocationType.SCIENCE, files);){
            int[] registerValues = new int[]{1, 2, 3, 4, 5, 6};
            Source source = image.addSource(Location.of((String)"R22/Reb0"), registerValues);
            try (ByteChannel channel = source.openChannel(Source.ChannelMode.WRITE);){
                ByteBuffer buffer = ByteBuffer.allocateDirect(0x100000);
                IntBuffer intBuffer = buffer.asIntBuffer();
                while (true) {
                    intBuffer.clear();
                    int len = reader.read(intBuffer);
                    if (len < 0) {
                        break;
                    }
                    buffer.position(0);
                    buffer.limit(4 * len);
                    channel.write(buffer);
                }
            }
        }
    }
}

