/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ats.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.ats.data.AtsState;
import org.lsst.ccs.subsystem.ats.ui.AtsMonitorPanel;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.common.ui.jas.MonOptionalPage;

@Plugin(name="ATS Monitor Plugin", description="ATS Monitor Plugin")
public class AtsMonitorPlugin
extends ConsolePlugin {
    public void initialize() {
        OptionalPage.getService().add((OptionalPage)new MonOptionalPage("atsType", AtsControl.class, null, false, new String[0]));
    }

    public static class AtsControl
    extends ControlPanel
    implements StatusMessageListener {
        private CommandSender cmdSender;
        private AtsMonitorPanel ctrlPanel;

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("AtsState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        public JPanel getControlPanel(CommandSender sndr) {
            this.cmdSender = sndr;
            this.ctrlPanel = new AtsMonitorPanel(sndr);
            return this.ctrlPanel;
        }

        public void initControlPanel() {
            this.updateControlPanel(this.cmdSender.sendCommand(null, "getSystemState", new Object[0]));
        }

        public void updateControlPanel(Object obj) {
            this.ctrlPanel.updateControlPanel((AtsState)obj);
        }

        public void disableSystem() {
            this.ctrlPanel.disableSystem();
        }

        public StatusMessageListener getListener() {
            return this;
        }
    }
}

