/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.ui;

import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.rafts.data.RaftState;

public class RaftsMonitorPanel
extends JPanel {
    private final CommandSender sender;
    private SystemStatusPanel statusPanel;
    private static final long serialVersionUID = 1L;

    public RaftsMonitorPanel(CommandSender sender) {
        this.sender = sender;
        this.initComponents();
        new DisableSystem().run();
    }

    private void initComponents() {
        this.statusPanel = new SystemStatusPanel(this.sender);
        this.add((Component)this.statusPanel);
    }

    public void updateControlPanel(RaftState state) {
        SwingUtilities.invokeLater(new UpdateControlPanel(state));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            RaftsMonitorPanel.this.statusPanel.disableSystem();
            RaftsMonitorPanel.this.repaint();
        }
    }

    class UpdateControlPanel
    implements Runnable {
        private final RaftState state;

        UpdateControlPanel(RaftState state) {
            this.state = state;
        }

        @Override
        public void run() {
            RaftsMonitorPanel.this.statusPanel.updateStatus(this.state.getTickMillis());
            RaftsMonitorPanel.this.repaint();
        }
    }
}

