/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui.focalplane.filter;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.subsystem.common.ui.focalplane.Segment;

public class Template
implements Serializable,
Comparable<Template> {
    public final String code;
    public final Segment segment;
    private static final Pattern fromString = Pattern.compile("(.+) \\(per (\\w+)\\)");

    public Template(String code, Segment segment) {
        this.code = code;
        this.segment = segment;
    }

    public String getAgent() {
        return this.code.substring(0, this.code.indexOf("/"));
    }

    public boolean hasAgent() {
        return !this.code.startsWith("/");
    }

    public Template stripAgent() {
        int i = this.code.indexOf("/");
        if (i == 0) {
            return this;
        }
        return new Template(this.code.substring(i), this.segment);
    }

    public static Template valueOf(AgentChannel channel) {
        return Template.valueOf(channel.getPath());
    }

    public static Template valueOf(String path, int[] indices) {
        if (indices == null) {
            return null;
        }
        Segment segment = Segment.RAFT;
        String p = "/" + Segment.RAFT.toString() + indices[0] + indices[1];
        path = path.replaceFirst(p, "");
        if (indices[2] != -1) {
            segment = Segment.REB;
            p = "/" + Segment.REB.toString() + indices[2];
            path = path.replaceFirst(p, "");
            if (indices[3] != -1) {
                segment = Segment.CCD;
                p = "/" + Segment.CCD.toString() + indices[2] + indices[3];
                path = path.replaceFirst(p, "");
                if (indices[4] != -1) {
                    segment = Segment.AMP;
                    p = String.valueOf(indices[4]) + indices[5];
                    path = path.replaceFirst(p, "");
                }
            }
        }
        return new Template(path, segment);
    }

    public static Template valueOf(String path) {
        Matcher m = Segment.FP_PATH_PATTERN.matcher(path);
        if (m.matches()) {
            String group = m.group("group");
            if (group == null) {
                return null;
            }
            String agent = m.group("agent");
            if (agent == null) {
                agent = "";
            }
            String code = agent + "/" + group;
            Segment segment = Segment.RAFT;
            if (m.group(Segment.AMP.name()) != null) {
                segment = Segment.AMP;
            } else if (m.group(Segment.CCD.name()) != null) {
                segment = Segment.CCD;
            } else if (m.group(Segment.REB.name()) != null) {
                segment = Segment.REB;
            }
            return new Template(code, segment);
        }
        return null;
    }

    public static Template fromString(String string) {
        Matcher m = fromString.matcher(string);
        if (m.matches()) {
            String code = m.group(1);
            Segment segment = Segment.valueOf(m.group(2));
            return new Template(code, segment);
        }
        throw new IllegalArgumentException("Cannot convert to template: " + string);
    }

    public static String getAgent(String encodedTemplate) {
        return encodedTemplate.substring(0, encodedTemplate.indexOf("/"));
    }

    public String toString() {
        return this.code + " (per " + this.segment.name() + ")";
    }

    public boolean equals(Object obj) {
        if (obj instanceof Template) {
            Template other = (Template)obj;
            return (this.code + (Object)((Object)this.segment)).equals(other.code + (Object)((Object)other.segment));
        }
        return false;
    }

    public int hashCode() {
        return (this.code + (Object)((Object)this.segment)).hashCode();
    }

    @Override
    public int compareTo(Template other) {
        return (this.code + (Object)((Object)this.segment)).compareTo(other.code + (Object)((Object)other.segment));
    }
}

