/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannelMulti;
import org.lsst.ccs.gconsole.plugins.monitor.GroupView;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusEvent;
import org.lsst.ccs.gconsole.services.aggregator.MutableAgentChannel;

public abstract class AbstractMonitorView3
implements GroupView {
    protected final LinkedHashMap<String, DisplayChannel> data = new LinkedHashMap();
    private long resetRequested = -2L;
    private final long RESET_DELAY = 1000L;

    protected abstract void resetChannels();

    protected void update() {
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public final void configure(AgentStatusEvent event) {
        this.processEvent(event);
    }

    @Override
    public final void disconnect(AgentStatusEvent event) {
        this.processEvent(event);
    }

    @Override
    public final void statusChanged(AgentStatusEvent event) {
        this.processEvent(event);
    }

    private void processEvent(AgentStatusEvent event) {
        AgentChannelsFilter filter = this.getFilter();
        ArrayList<AbstractMap.SimpleEntry<String, AgentChannel>> addedChannels = new ArrayList<AbstractMap.SimpleEntry<String, AgentChannel>>();
        for (AgentChannel agentChannel : event.getAddedChannels()) {
            for (String string : filter.getDisplayPaths(agentChannel)) {
                addedChannels.add(new AbstractMap.SimpleEntry<String, AgentChannel>(string, agentChannel));
            }
        }
        ArrayList<AbstractMap.SimpleEntry<String, AgentChannel>> removedChannels = new ArrayList<AbstractMap.SimpleEntry<String, AgentChannel>>();
        for (AgentChannel channel : event.getRemovedChannels()) {
            for (String displayPath : filter.getDisplayPaths(channel)) {
                removedChannels.add(new AbstractMap.SimpleEntry<String, AgentChannel>(displayPath, channel));
            }
        }
        ArrayList<AbstractMap.SimpleEntry<String, AgentChannel>> arrayList = new ArrayList<AbstractMap.SimpleEntry<String, AgentChannel>>();
        for (AgentChannel agentChannel : event.getStatusChanges().keySet()) {
            for (String displayPath : filter.getDisplayPaths(agentChannel)) {
                arrayList.add(new AbstractMap.SimpleEntry<String, AgentChannel>(displayPath, agentChannel));
            }
        }
        if (!(arrayList.isEmpty() && addedChannels.isEmpty() && removedChannels.isEmpty())) {
            SwingUtilities.invokeLater(() -> this.updateGUI(event, addedChannels, removedChannels, changedChannels));
        }
    }

    private void updateGUI(AgentStatusEvent event, List<Map.Entry<String, AgentChannel>> addedChannels, List<Map.Entry<String, AgentChannel>> removedChannels, List<Map.Entry<String, AgentChannel>> changedChannels) {
        String displayPath;
        AgentChannel channel;
        boolean needReset = false;
        for (Map.Entry<String, AgentChannel> e : removedChannels) {
            DisplayChannel dc = this.data.get(e.getKey());
            if (dc == null) continue;
            channel = e.getValue();
            boolean mutable = channel instanceof MutableAgentChannel;
            if (mutable) {
                ((MutableAgentChannel)channel).set("state", DataProviderState.OFF_LINE);
                dc.addChannel(channel);
                dc.update(null);
                continue;
            }
            if (dc.removeChannel(channel.getPath())) {
                this.data.remove(dc.getPath());
                needReset = true;
                continue;
            }
            dc.update(null);
        }
        for (Map.Entry<String, AgentChannel> e : addedChannels) {
            displayPath = e.getKey();
            channel = e.getValue();
            DisplayChannel dc = this.data.get(displayPath);
            if (dc == null) {
                dc = new DisplayChannelMulti(displayPath);
                dc.addChannel(channel);
                this.data.put(displayPath, dc);
                needReset = true;
                continue;
            }
            dc.addChannel(channel);
            dc.update(null);
        }
        for (Map.Entry<String, AgentChannel> e : changedChannels) {
            displayPath = e.getKey();
            channel = e.getValue();
            DisplayChannel dc = this.data.get(displayPath);
            if (dc == null) {
                dc = new DisplayChannelMulti(displayPath);
                dc.addChannel(channel);
                this.data.put(displayPath, dc);
                needReset = true;
                continue;
            }
            dc.addChannel(channel);
            dc.update(null);
        }
        if (!addedChannels.isEmpty()) {
            String agent = event.getSource().getName();
            Iterator<Map.Entry<String, DisplayChannel>> it = this.data.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, DisplayChannel> e = it.next();
                if (!e.getValue().purgeOfflineChannels(agent)) continue;
                it.remove();
                needReset = true;
            }
        }
        if (needReset) {
            this.scheduleReset();
        } else {
            this.update();
        }
    }

    private void scheduleReset() {
        if (this.resetRequested != -2L) {
            if (this.resetRequested == -1L) {
                Console.getConsole().getScheduler().schedule(() -> SwingUtilities.invokeLater(this::executeReset), 1000L, TimeUnit.MILLISECONDS);
            }
            this.resetRequested = System.currentTimeMillis();
        }
    }

    private void executeReset() {
        if (this.resetRequested != -2L) {
            long delay = this.resetRequested + 900L - System.currentTimeMillis();
            if (delay > 0L) {
                Console.getConsole().getScheduler().schedule(() -> SwingUtilities.invokeLater(this::executeReset), delay, TimeUnit.MILLISECONDS);
            } else {
                this.resetRequested = -1L;
                this.resetChannels();
            }
        }
    }

    @Override
    public void install() {
        SwingUtilities.invokeLater(() -> {
            this.resetRequested = -1L;
        });
        GroupView.super.install();
    }

    @Override
    public void uninstall() {
        GroupView.super.uninstall();
        SwingUtilities.invokeLater(() -> {
            this.resetRequested = -2L;
        });
    }

    @Override
    public List<String> getGroups() {
        List<String> channels = this.getFilter().getDisplayChannels();
        LinkedHashSet groups = new LinkedHashSet();
        (channels == null ? this.data.keySet() : channels).forEach(displayPath -> {
            String group = this.getGroup((String)displayPath);
            if (group != null) {
                groups.add(group);
            }
        });
        return new ArrayList<String>(groups);
    }
}

