/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.sal.atcamera.event.WrebSettingsAppliedEvent;
import org.lsst.sal.atcamera.telemetry.VacuumTelemetry;
import org.lsst.sal.atcamera.telemetry.WrebPowerTelemetry;
import org.lsst.sal.atcamera.telemetry.WrebTelemetry;

public class BigUglyConverter {
    private final Map<String, Integer> wrebSettingsAppliedMap = new HashMap<String, Integer>();
    private final Map<String, Integer> wrebTelemetryMap;
    private final Map<String, Integer> wrebPowerTelemetryMap;
    private final Map<Object, Integer> vacuumTelemetryMap;

    public BigUglyConverter() {
        this.wrebSettingsAppliedMap.put("WREB.DAC/pclkLowSh", 32);
        this.wrebSettingsAppliedMap.put("main/ccdType", -1);
        this.wrebSettingsAppliedMap.put("WREB/id", -1);
        this.wrebSettingsAppliedMap.put("WREB.ASPIC1/af1", 10);
        this.wrebSettingsAppliedMap.put("WREB.Bias0/rdP", 25);
        this.wrebSettingsAppliedMap.put("WREB/ifcName", -1);
        this.wrebSettingsAppliedMap.put("WREB.DAC/pclkHigh", 27);
        this.wrebSettingsAppliedMap.put("WREB.Bias0/csGateP", 16);
        this.wrebSettingsAppliedMap.put("WREB.DAC/rgHigh", 33);
        this.wrebSettingsAppliedMap.put("WREB.DAC/sclkHigh", 39);
        this.wrebSettingsAppliedMap.put("WREB.Bias0/gd", 17);
        this.wrebSettingsAppliedMap.put("WREB.DAC/rgLowSh", 38);
        this.wrebSettingsAppliedMap.put("WREB.Bias0/gdP", 18);
        this.wrebSettingsAppliedMap.put("WREB.DAC/csGate", -1);
        this.wrebSettingsAppliedMap.put("WREB.ASPIC1/tm", 14);
        this.wrebSettingsAppliedMap.put("WREB.Bias0/ogSh", 23);
        this.wrebSettingsAppliedMap.put("WREB.Bias0/od", 19);
        this.wrebSettingsAppliedMap.put("WREB.DAC/sclkHighSh", 41);
        this.wrebSettingsAppliedMap.put("WREB.Bias0/odP", 20);
        this.wrebSettingsAppliedMap.put("WREB.DAC/sclkLow", 42);
        this.wrebSettingsAppliedMap.put("WREB.Bias0/og", 21);
        this.wrebSettingsAppliedMap.put("WREB.ASPIC1/rc", 13);
        this.wrebSettingsAppliedMap.put("WREB.DAC/pclkHighP", 28);
        this.wrebSettingsAppliedMap.put("WREB.ASPIC0/clamp", 6);
        this.wrebSettingsAppliedMap.put("WREB.DAC/rgLow", 36);
        this.wrebSettingsAppliedMap.put("WREB/serialNum", -1);
        this.wrebSettingsAppliedMap.put("WREB.DAC/sclkHighP", 40);
        this.wrebSettingsAppliedMap.put("WREB.DAC/pclkHighSh", 29);
        this.wrebSettingsAppliedMap.put("WREB.DAC/pclkLow", 30);
        this.wrebSettingsAppliedMap.put("WREB.ASPIC1/gain", 12);
        this.wrebSettingsAppliedMap.put("WREB.DAC/rgLowP", 37);
        this.wrebSettingsAppliedMap.put("WREB.ASPIC0/af1", 5);
        this.wrebSettingsAppliedMap.put("WREB.DAC/sclkLowP", 43);
        this.wrebSettingsAppliedMap.put("WREB.ASPIC0/tm", 9);
        this.wrebSettingsAppliedMap.put("WREB.Bias0/csGate", 15);
        this.wrebSettingsAppliedMap.put("WREB.DAC/rgHighP", 34);
        this.wrebSettingsAppliedMap.put("WREB.DAC/pclkLowP", 31);
        this.wrebSettingsAppliedMap.put("WREB.Bias0/rd", 24);
        this.wrebSettingsAppliedMap.put("WREB.ASPIC1/clamp", 11);
        this.wrebSettingsAppliedMap.put("WREB.ASPIC0/rc", 8);
        this.wrebSettingsAppliedMap.put("WREB.Bias0/ogP", 22);
        this.wrebSettingsAppliedMap.put("WREB.DAC/rgHighSh", 35);
        this.wrebSettingsAppliedMap.put("WREB.DAC/sclkLowSh", 44);
        this.wrebSettingsAppliedMap.put("WREB.ASPIC0/gain", 7);
        this.wrebTelemetryMap = new HashMap<String, Integer>();
        this.wrebTelemetryMap.put("WREB.Temp1", 3);
        this.wrebTelemetryMap.put("WREB.Temp2", 4);
        this.wrebTelemetryMap.put("WREB.Temp3", 5);
        this.wrebTelemetryMap.put("WREB.Temp4", 6);
        this.wrebTelemetryMap.put("WREB.Temp5", 7);
        this.wrebTelemetryMap.put("WREB.Temp6", 8);
        this.wrebTelemetryMap.put("WREB.Atemp0U", 9);
        this.wrebTelemetryMap.put("WREB.Atemp0L", 10);
        this.wrebTelemetryMap.put("WREB.CCDtemp0", 11);
        this.wrebTelemetryMap.put("WREB.RTDtemp", -1);
        this.wrebTelemetryMap.put("WREB.DigPS_V", 12);
        this.wrebTelemetryMap.put("WREB.DigPS_I", 13);
        this.wrebTelemetryMap.put("WREB.AnaPS_V", 14);
        this.wrebTelemetryMap.put("WREB.AnaPS_I", 15);
        this.wrebTelemetryMap.put("WREB.ClkHPS_V", 16);
        this.wrebTelemetryMap.put("WREB.ClkHPS_I", 17);
        this.wrebTelemetryMap.put("WREB.ODPS_V", 18);
        this.wrebTelemetryMap.put("WREB.ODPS_I", 19);
        this.wrebTelemetryMap.put("WREB.HtrPS_V", 20);
        this.wrebTelemetryMap.put("WREB.HtrPS_I", 21);
        this.wrebTelemetryMap.put("WREB.Power", 22);
        this.wrebTelemetryMap.put("WREB.CKPSH_V", 0);
        this.wrebTelemetryMap.put("WREB.CKS_V", -1);
        this.wrebTelemetryMap.put("WREB.SCKU_V", 23);
        this.wrebTelemetryMap.put("WREB.SCKL_V", 24);
        this.wrebTelemetryMap.put("WREB.RG_V", -1);
        this.wrebTelemetryMap.put("WREB.RGU_V", 25);
        this.wrebTelemetryMap.put("WREB.RGL_V", 26);
        this.wrebTelemetryMap.put("WREB.CKP0V", 1);
        this.wrebTelemetryMap.put("WREB.CKS0V", 27);
        this.wrebTelemetryMap.put("WREB.RG0V", 28);
        this.wrebTelemetryMap.put("WREB.OD0V", 29);
        this.wrebTelemetryMap.put("WREB.OG0V", 2);
        this.wrebTelemetryMap.put("WREB.RD0V", 30);
        this.wrebTelemetryMap.put("WREB.GD0V", 31);
        this.wrebTelemetryMap.put("WREB.OD0I", 32);
        this.wrebPowerTelemetryMap = new HashMap<String, Integer>();
        this.wrebPowerTelemetryMap.put("Digital_V", 0);
        this.wrebPowerTelemetryMap.put("Digital_I", 1);
        this.wrebPowerTelemetryMap.put("Analog_V", 2);
        this.wrebPowerTelemetryMap.put("Analog_I", 3);
        this.wrebPowerTelemetryMap.put("ClkHigh_V", 4);
        this.wrebPowerTelemetryMap.put("ClkHigh_I", 5);
        this.wrebPowerTelemetryMap.put("ClkLow_V", 6);
        this.wrebPowerTelemetryMap.put("ClkLow_I", 7);
        this.wrebPowerTelemetryMap.put("OD_V", 8);
        this.wrebPowerTelemetryMap.put("OD_I", 9);
        this.wrebPowerTelemetryMap.put("DPHI_V", 10);
        this.wrebPowerTelemetryMap.put("DPHI_I", 11);
        this.wrebPowerTelemetryMap.put("Heater_V", 12);
        this.wrebPowerTelemetryMap.put("Heater_I", 13);
        this.wrebPowerTelemetryMap.put("HVBias_V", 14);
        this.wrebPowerTelemetryMap.put("HVBias_I", 15);
        this.vacuumTelemetryMap = new HashMap<Object, Integer>();
        this.vacuumTelemetryMap.put("TempCCD", 0);
        this.vacuumTelemetryMap.put("TempColdPlate", 1);
        this.vacuumTelemetryMap.put("TempCryoHead", 2);
        this.vacuumTelemetryMap.put("Vacuum", 3);
    }

    public WrebSettingsAppliedEvent convertWREBSettings(ConfigurationInfo configInfo) {
        float[] wrebPars = new float[45];
        Map currentValuesForCategory = configInfo.getCurrentValuesForCategory("Rafts");
        for (Map.Entry entry : currentValuesForCategory.entrySet()) {
            if (this.wrebSettingsAppliedMap.get(entry.getKey()) == null || this.wrebSettingsAppliedMap.get(entry.getKey()) == -1) continue;
            wrebPars[this.wrebSettingsAppliedMap.get(entry.getKey()).intValue()] = Float.parseFloat((String)entry.getValue());
        }
        return new WrebSettingsAppliedEvent(1, 1, "PathFinder", 2, 3, (int)wrebPars[5], (int)wrebPars[6], (int)wrebPars[7], (int)wrebPars[8], (int)wrebPars[9], (int)wrebPars[10], (int)wrebPars[11], (int)wrebPars[12], (int)wrebPars[13], (int)wrebPars[14], (int)wrebPars[15], (int)wrebPars[16], (int)wrebPars[17], (int)wrebPars[18], (int)wrebPars[19], (int)wrebPars[20], (int)wrebPars[21], (int)wrebPars[22], (int)wrebPars[23], (int)wrebPars[24], (int)wrebPars[25], 1, (int)wrebPars[27], (int)wrebPars[28], (int)wrebPars[29], (int)wrebPars[30], (int)wrebPars[31], (int)wrebPars[32], (int)wrebPars[33], (int)wrebPars[34], (int)wrebPars[35], (int)wrebPars[36], (int)wrebPars[37], (int)wrebPars[38], (int)wrebPars[39], (int)wrebPars[40], (int)wrebPars[41], (int)wrebPars[42], (int)wrebPars[43], (int)wrebPars[44], 0, "", "", "", "", "", "");
    }

    public WrebTelemetry convertWREBTelemetry(StatusSubsystemData statusInfo) {
        float[] wrebTelPars = new float[34];
        String key = statusInfo.getDataKey();
        KeyValueData subsystemData = statusInfo.getSubsystemData();
        List values = (List)((Object)subsystemData.getValue());
        for (KeyValueData kvd : values) {
            if (kvd.getKey().contains("main") || this.wrebTelemetryMap.get(kvd.getKey()) == null || this.wrebTelemetryMap.get(kvd.getKey()) == -1) continue;
            wrebTelPars[this.wrebTelemetryMap.get((Object)kvd.getKey()).intValue()] = Float.parseFloat(kvd.getValue().toString());
        }
        return new WrebTelemetry(wrebTelPars[0], wrebTelPars[1], wrebTelPars[2], wrebTelPars[3], wrebTelPars[4], wrebTelPars[5], wrebTelPars[6], wrebTelPars[7], wrebTelPars[8], wrebTelPars[9], wrebTelPars[10], wrebTelPars[11], wrebTelPars[12], wrebTelPars[13], wrebTelPars[14], wrebTelPars[15], wrebTelPars[16], wrebTelPars[17], wrebTelPars[18], wrebTelPars[19], wrebTelPars[20], wrebTelPars[21], wrebTelPars[22], wrebTelPars[23], wrebTelPars[24], wrebTelPars[25], wrebTelPars[26], wrebTelPars[27], wrebTelPars[28], wrebTelPars[29], wrebTelPars[30], wrebTelPars[31], wrebTelPars[32]);
    }

    public WrebPowerTelemetry converWREBPowerTelemetry(StatusSubsystemData statusInfo) {
        float[] wrebTelPars = new float[16];
        String key = statusInfo.getDataKey();
        KeyValueData subsystemData = statusInfo.getSubsystemData();
        List values = (List)((Object)subsystemData.getValue());
        for (KeyValueData kvd : values) {
            System.out.println(kvd.getKey() + " = " + kvd.getValue());
            if (kvd.getKey().contains("main") || this.wrebPowerTelemetryMap.get(kvd.getKey()) == null || this.wrebPowerTelemetryMap.get(kvd.getKey()) == -1) continue;
            wrebTelPars[this.wrebPowerTelemetryMap.get((Object)kvd.getKey()).intValue()] = Float.parseFloat(kvd.getValue().toString());
        }
        return new WrebPowerTelemetry(wrebTelPars[0], wrebTelPars[1], wrebTelPars[2], wrebTelPars[3], wrebTelPars[4], wrebTelPars[5], wrebTelPars[6], wrebTelPars[7], wrebTelPars[8], wrebTelPars[9], wrebTelPars[10], wrebTelPars[11], wrebTelPars[12], wrebTelPars[13], wrebTelPars[14], wrebTelPars[15]);
    }

    public VacuumTelemetry convertVacuumTelemetry(StatusSubsystemData statusInfo) {
        float[] vacuumTelPars = new float[4];
        String key = statusInfo.getDataKey();
        KeyValueData subsystemData = statusInfo.getSubsystemData();
        List values = (List)((Object)subsystemData.getValue());
        for (KeyValueData kvd : values) {
            if (kvd.getKey().contains("main") || this.vacuumTelemetryMap.get(kvd.getKey()) == -1) continue;
            vacuumTelPars[this.vacuumTelemetryMap.get((Object)kvd.getKey()).intValue()] = Float.parseFloat(kvd.getValue().toString());
        }
        return new VacuumTelemetry(vacuumTelPars[0], vacuumTelPars[1], vacuumTelPars[2], vacuumTelPars[3], 0.0f);
    }
}

