/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui.jas;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.plugins.monitor.TabbedView;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.power.data.ATSPowerState;
import org.lsst.ccs.subsystem.power.ui.ATSPowerControlPanel;
import org.lsst.ccs.subsystem.power.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.power.ui.jas.MonitorFilter;

@Plugin(name="ATS Power Supply Plugin", description="ATS Power Supply Plugin")
public class ATSPowerControlPlugin
extends ConsolePlugin {
    public void initialize() {
        Console.getConsole().getOptionalPageService().add((OptionalPage)new ATSPowerControlOptionalPage());
    }

    static class BusListener
    implements StatusMessageListener {
        private final ATSPowerControlPanel controls;

        BusListener(ATSPowerControlPanel controls) {
            this.controls = controls;
        }

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("ATSPowerState")) {
                    this.controls.updateControlPanel((ATSPowerState)sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }
    }

    static class ATSPowerControlOptionalPage
    implements OptionalPage {
        private final CommandSender cmdSender = new CommandSender();
        private final Map<String, BusListener> busListeners = new ConcurrentHashMap<String, BusListener>();

        ATSPowerControlOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            return agent != null && agent.hasAgentProperty("atsPowerAgent") ? this.getPageName(agent) : null;
        }

        public boolean agentDisconnected(AgentInfo agent) {
            String pageName = this.getPageName(agent);
            BusListener listener = this.busListeners.get(pageName);
            if (listener == null) {
                return true;
            }
            listener.controls.disableSystem();
            return false;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            String pageName = this.getPageName(agent);
            String agentName = agent.getName();
            BusListener listener = this.busListeners.get(pageName);
            if (listener != null) {
                this.initControls(agentName, listener.controls);
                return existingComponent;
            }
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            TabbedView view = new TabbedView();
            view.setViewFactory(name -> new SectionedTableView());
            MonitorFilter monitorFilter = new MonitorFilter(agentName);
            view.setFilter((AgentChannelsFilter)monitorFilter);
            view.install();
            panel.add((Component)view.getPanel(), "Center");
            ATSPowerControlPanel controls = new ATSPowerControlPanel(this.cmdSender);
            controls.setSubsystems(agent.getName());
            panel.add((Component)controls, "South");
            listener = new BusListener(controls);
            AgentMessagingLayer aml = Console.getConsole().getMessagingAccess();
            aml.addStatusMessageListener((StatusMessageListener)listener, msg -> msg.getOriginAgentInfo().getName().equals(agentName) && msg instanceof StatusSubsystemData);
            this.busListeners.put(pageName, listener);
            this.initControls(agentName, controls);
            return panel;
        }

        public void closed(String pageName) {
            BusListener listener = this.busListeners.remove(pageName);
            if (listener == null) {
                throw new RuntimeException("No page exists with the name " + pageName);
            }
            Console.getConsole().getMessagingAccess().removeStatusMessageListener((StatusMessageListener)listener);
        }

        private String getPageName(AgentInfo agent) {
            return "CCS Subsystems/" + agent.getName();
        }

        private void initControls(String agentName, ATSPowerControlPanel controls) {
            Object response = this.cmdSender.sendCommand(agentName, null, "getFullState", new Object[0]);
            if (response instanceof ATSPowerState) {
                controls.updateControlPanel((ATSPowerState)response);
            }
        }
    }
}

