/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.power.data.RebPsState;
import org.lsst.ccs.subsystem.power.ui.jas.CommandSender;

public class RebPsControlPanel
extends JPanel {
    private static final Font FONT = new Font("Tahoma", 1, 12);
    private static final Color RED = new Color(180, 0, 0);
    private static final Color GREEN = new Color(0, 180, 0);
    private static final Color YELLOW = new Color(200, 180, 0);
    private static final Color GREY = Color.GRAY;
    private static final int REB_Q = 3;
    private static final int N_REB = 6;
    private static final int N_PS = 8;
    private static final int PS_DIG = 0;
    private static final int PS_ANA = 1;
    private static final int PS_OD = 2;
    private static final int PS_CLKH = 3;
    private static final int PS_CLKL = 4;
    private static final int PS_HTR = 5;
    private static final int PS_DPHI = 6;
    private static final int PS_HV = 7;
    private static final Map<Integer, Integer> btnMapSR = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> invBtnMapSR;
    private static final Map<Integer, Integer> btnMapCR;
    private static final Map<Integer, Integer> invBtnMapCR;
    private final CommandSender gui;
    private final JPanel pnlPowerState = new JPanel();
    private final JLabel lblPowerState = new JLabel("System State: ");
    private final JLabel lblPowerStateValue = new JLabel("....");
    private final JPanel pnlPsId = new JPanel();
    private final JLabel lblPsId = new JLabel("PS ID: ");
    private final JLabel lblPsIdValue = new JLabel("....");
    private final JPanel pnlMainPower = new JPanel();
    private final JLabel lblMainPower = new JLabel("Main Power: ");
    private final JButton btnMainPower = new JButton("");
    private final JPanel pnlPowerPeriod = new JPanel();
    private final JLabel lblPowerPeriod = new JLabel("Update Period: ");
    private final JTextField tfPowerPeriod = new JTextField("...");
    private final JLabel lblPowerPeriodUnits = new JLabel("sec");
    private final JPanel pnlPowerControl = new JPanel();
    private final JLabel[] lblPsNames = new JLabel[8];
    private final JLabel[] lblRebName = new JLabel[6];
    private final JButton[][] btnToggle = new JButton[6][8];
    private final JButton[] btnSeqOn = new JButton[6];
    private final JButton[] btnSeqOff = new JButton[6];
    private final JLabel lblBiasDac = new JLabel("Bias DAC");
    private final JTextField[] tfBiasDac = new JTextField[6];
    private final JLabel lblDphiDac = new JLabel("Dphi DAC");
    private final JTextField[] tfDphiDac = new JTextField[6];
    private final int[] biasDacs = new int[6];
    private final int[] dphiDacs = new int[6];
    private int numReb = 0;
    private boolean gotCR = false;
    private String powerName;
    private double powerPeriod = 5.0;
    private static final long serialVersionUID = 1L;

    public RebPsControlPanel(CommandSender gui) {
        this.gui = gui;
        this.initComponents();
        new UpdatePowerStatus(new RebPsState(0, -1, new int[0], new double[0], new double[0], 0, 0, "")).run();
        new DisableSystem().run();
    }

    public void setSubsystems(String powerName) {
        this.powerName = powerName;
    }

    private void initComponents() {
        int reb;
        Dimension ds = this.lblPowerStateValue.getPreferredSize();
        ds.width = 70;
        this.lblPowerStateValue.setPreferredSize(ds);
        this.lblPowerStateValue.setMinimumSize(ds);
        Dimension di = this.lblPsIdValue.getPreferredSize();
        di.width = 50;
        this.lblPsIdValue.setPreferredSize(di);
        this.lblPsIdValue.setMinimumSize(di);
        Dimension dc = this.btnMainPower.getPreferredSize();
        dc.height = 16;
        this.btnMainPower.setPreferredSize(dc);
        this.btnMainPower.setMinimumSize(dc);
        this.btnMainPower.setFocusable(false);
        this.btnMainPower.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RebPsControlPanel.this.toggleMainPower();
            }
        });
        Dimension dp = this.tfPowerPeriod.getPreferredSize();
        dp.width = 50;
        this.tfPowerPeriod.setPreferredSize(dp);
        this.tfPowerPeriod.setMinimumSize(dp);
        this.tfPowerPeriod.setHorizontalAlignment(0);
        this.tfPowerPeriod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RebPsControlPanel.this.setUpdatePeriod();
            }
        });
        for (reb = 0; reb < 6; ++reb) {
            this.lblRebName[reb] = new JLabel("REB" + reb);
        }
        this.lblPsNames[0] = new JLabel("Dig");
        this.lblPsNames[1] = new JLabel("Ana");
        this.lblPsNames[2] = new JLabel("OD");
        this.lblPsNames[3] = new JLabel("ClkH");
        this.lblPsNames[4] = new JLabel("ClkL");
        this.lblPsNames[5] = new JLabel("Htr");
        this.lblPsNames[6] = new JLabel("Dphi");
        this.lblPsNames[7] = new JLabel("HVbias");
        for (reb = 0; reb < 6; ++reb) {
            JButton btn = new JButton("On");
            btn.setForeground(GREEN);
            btn.setName(String.valueOf(reb));
            btn.setFocusable(false);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JButton)evt.getSource()).getName();
                    RebPsControlPanel.this.sequencePower(Integer.valueOf(name), true);
                }
            });
            this.btnSeqOn[reb] = btn;
            btn = new JButton("Off");
            btn.setForeground(RED);
            btn.setName(String.valueOf(reb));
            btn.setFocusable(false);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JButton)evt.getSource()).getName();
                    RebPsControlPanel.this.sequencePower(Integer.valueOf(name), false);
                }
            });
            this.btnSeqOff[reb] = btn;
            for (int ps = 0; ps < 8; ++ps) {
                btn = new JButton(" ");
                btn.setName(String.valueOf(reb << 4 | ps));
                btn.setFocusable(false);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        int srcPsReb = Integer.valueOf(((JButton)evt.getSource()).getName());
                        int dstPsReb = (Integer)(RebPsControlPanel.this.gotCR ? invBtnMapCR : invBtnMapSR).get(srcPsReb);
                        RebPsControlPanel.this.togglePower(dstPsReb >> 4, dstPsReb & 0xF);
                    }
                });
                this.btnToggle[reb][ps] = btn;
            }
            JTextField tf = new JTextField("...");
            tf.setName("D" + reb);
            Dimension dd = tf.getPreferredSize();
            dd.width = 60;
            tf.setPreferredSize(dd);
            tf.setMinimumSize(dd);
            tf.setHorizontalAlignment(0);
            tf.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JTextField)evt.getSource()).getName();
                    RebPsControlPanel.this.setDphiDac(Integer.valueOf(name.substring(1)));
                }
            });
            this.tfDphiDac[reb] = tf;
            tf = new JTextField("...");
            tf.setName("B" + reb);
            tf.setPreferredSize(dd);
            tf.setMinimumSize(dd);
            tf.setHorizontalAlignment(0);
            tf.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JTextField)evt.getSource()).getName();
                    RebPsControlPanel.this.setBiasDac(Integer.valueOf(name.substring(1)));
                }
            });
            this.tfBiasDac[reb] = tf;
        }
        this.pnlPowerState.add(this.lblPowerState);
        this.pnlPowerState.add(this.lblPowerStateValue);
        this.pnlPsId.add(this.lblPsId);
        this.pnlPsId.add(this.lblPsIdValue);
        this.pnlMainPower.add(this.lblMainPower);
        this.pnlMainPower.add(this.btnMainPower);
        this.pnlPowerPeriod.add(this.lblPowerPeriod);
        this.pnlPowerPeriod.add(this.tfPowerPeriod);
        this.pnlPowerPeriod.add(this.lblPowerPeriodUnits);
        this.pnlPowerControl.setLayout(new GridBagLayout());
        this.drawControl(6, false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 10, 6, 10);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.pnlPowerState, gbc);
        ++gbc.gridx;
        this.add((Component)this.pnlPsId, gbc);
        ++gbc.gridx;
        this.add((Component)this.pnlMainPower, gbc);
        ++gbc.gridx;
        this.add((Component)this.pnlPowerPeriod, gbc);
        gbc.insets = new Insets(6, 6, 6, 6);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        this.add((Component)this.pnlPowerControl, gbc);
    }

    private void drawControl(int nReb, boolean isCR) {
        if (nReb == 0 || nReb == this.numReb && isCR == this.gotCR) {
            return;
        }
        this.numReb = nReb;
        this.gotCR = isCR;
        this.pnlPowerControl.removeAll();
        GridBagConstraints gbp = new GridBagConstraints();
        gbp.insets = new Insets(4, 6, 4, 6);
        gbp.gridx = 1;
        gbp.gridwidth = 2;
        gbp.gridy = 0;
        this.pnlPowerControl.add((Component)new JLabel("Sequenced"), gbp);
        gbp.gridx += 2;
        gbp.gridwidth = 1;
        for (int ps = 0; ps < 8; ++ps) {
            if (this.gotCR || ps != 6) {
                this.pnlPowerControl.add((Component)this.lblPsNames[ps], gbp);
                ++gbp.gridx;
            }
            if (this.gotCR && ps == 6) {
                this.pnlPowerControl.add((Component)this.lblDphiDac, gbp);
                ++gbp.gridx;
            }
            if (ps != 7) continue;
            this.pnlPowerControl.add((Component)this.lblBiasDac, gbp);
            ++gbp.gridx;
        }
        gbp.gridx = 0;
        ++gbp.gridy;
        for (int reb = 0; reb < this.numReb; ++reb) {
            if (this.gotCR && reb % 3 == 2) continue;
            this.pnlPowerControl.add((Component)this.lblRebName[reb], gbp);
            ++gbp.gridx;
            this.pnlPowerControl.add((Component)this.btnSeqOn[reb], gbp);
            ++gbp.gridx;
            this.pnlPowerControl.add((Component)this.btnSeqOff[reb], gbp);
            ++gbp.gridx;
            for (int ps = 0; ps < 8; ++ps) {
                if (this.gotCR || ps != 6) {
                    if (ps != 5 || !this.gotCR || reb % 3 == 0) {
                        this.pnlPowerControl.add((Component)this.btnToggle[reb][ps], gbp);
                    }
                    ++gbp.gridx;
                }
                if (this.gotCR && ps == 6) {
                    this.pnlPowerControl.add((Component)this.tfDphiDac[reb], gbp);
                    ++gbp.gridx;
                }
                if (ps != 7) continue;
                this.pnlPowerControl.add((Component)this.tfBiasDac[reb], gbp);
                ++gbp.gridx;
            }
            gbp.gridx = 0;
            ++gbp.gridy;
        }
    }

    private void setUpdatePeriod() {
        try {
            double value = Double.valueOf(this.tfPowerPeriod.getText());
            this.gui.sendCommand(this.powerName, null, "setUpdatePeriod", (int)(1000.0 * value));
            this.tfPowerPeriod.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.tfPowerPeriod.setText(String.valueOf(this.powerPeriod));
        }
    }

    private void toggleMainPower() {
        this.gui.sendCommand(this.powerName, null, "toggleMainPower", new Object[0]);
    }

    private void sequencePower(int reb, boolean on) {
        this.gui.sendCommand(this.powerName, null, "sequencePower", reb, on);
    }

    private void togglePower(int reb, int ps) {
        this.gui.sendCommand(this.powerName, null, "togglePower", reb, ps);
    }

    private void setBiasDac(int reb) {
        try {
            double value = Integer.valueOf(this.tfBiasDac[reb].getText()).intValue();
            this.gui.sendCommand(this.powerName, null, "setBiasDac", reb, value);
            this.tfBiasDac[reb].setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.tfBiasDac[reb].setText(String.valueOf(this.biasDacs[reb]));
        }
    }

    private void setDphiDac(int reb) {
        try {
            double value = Integer.valueOf(this.tfDphiDac[reb].getText()).intValue();
            this.gui.sendCommand(this.powerName, null, "setDphiDac", reb, value);
            this.tfDphiDac[reb].setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.tfDphiDac[reb].setText(String.valueOf(this.dphiDacs[reb]));
        }
    }

    public void updateControlPanel(RebPsState rs) {
        SwingUtilities.invokeLater(new UpdatePowerStatus(rs));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    static {
        for (int reb = 0; reb < 6; ++reb) {
            btnMapSR.put(reb << 4 | 0, reb << 4 | 0);
            btnMapSR.put(reb << 4 | 1, reb << 4 | 1);
            btnMapSR.put(reb << 4 | 2, reb << 4 | 2);
            btnMapSR.put(reb << 4 | 3, reb << 4 | 3);
            btnMapSR.put(reb << 4 | 4, reb << 4 | 4);
            btnMapSR.put(reb << 4 | 5, reb << 4 | 5);
            btnMapSR.put(reb << 4 | 6, reb << 4 | 7);
        }
        invBtnMapSR = new HashMap<Integer, Integer>();
        for (int ps : btnMapSR.keySet()) {
            invBtnMapSR.put(btnMapSR.get(ps), ps);
        }
        btnMapCR = new HashMap<Integer, Integer>();
        for (int reb = 0; reb < 6; ++reb) {
            if (reb % 3 != 2) {
                btnMapCR.put(reb << 4 | 0, reb << 4 | 0);
            } else {
                btnMapCR.put(reb << 4 | 0, reb - 2 << 4 | 5);
            }
            btnMapCR.put(reb << 4 | 1, reb << 4 | 1);
            btnMapCR.put(reb << 4 | 2, reb << 4 | 2);
            btnMapCR.put(reb << 4 | 3, reb << 4 | 3);
            btnMapCR.put(reb << 4 | 4, reb << 4 | 4);
            btnMapCR.put(reb << 4 | 5, reb << 4 | 6);
            btnMapCR.put(reb << 4 | 6, reb << 4 | 7);
        }
        invBtnMapCR = new HashMap<Integer, Integer>();
        for (int ps : btnMapCR.keySet()) {
            invBtnMapCR.put(btnMapCR.get(ps), ps);
        }
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            RebPsControlPanel.this.lblPowerStateValue.setText("STOPPED");
            RebPsControlPanel.this.lblPowerStateValue.setForeground(RED);
            RebPsControlPanel.this.btnMainPower.setEnabled(false);
            RebPsControlPanel.this.btnMainPower.setBackground(GREY);
            RebPsControlPanel.this.tfPowerPeriod.setEnabled(false);
            for (int reb = 0; reb < RebPsControlPanel.this.numReb; ++reb) {
                RebPsControlPanel.this.btnSeqOn[reb].setEnabled(false);
                RebPsControlPanel.this.btnSeqOff[reb].setEnabled(false);
                for (int ps = 0; ps < 8; ++ps) {
                    RebPsControlPanel.this.btnToggle[reb][ps].setEnabled(false);
                    RebPsControlPanel.this.btnToggle[reb][ps].setBackground(GREY);
                }
                RebPsControlPanel.this.tfBiasDac[reb].setEnabled(false);
                RebPsControlPanel.this.tfDphiDac[reb].setEnabled(false);
            }
        }
    }

    class UpdatePowerStatus
    implements Runnable {
        private final RebPsState rs;

        UpdatePowerStatus(RebPsState rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            int nReb = this.rs.getPowerState().length;
            boolean isCR = this.rs.getPsType() == 1;
            RebPsControlPanel.this.drawControl(nReb, isCR);
            RebPsControlPanel.this.lblPowerStateValue.setText("RUNNING");
            RebPsControlPanel.this.lblPowerStateValue.setForeground(GREEN);
            RebPsControlPanel.this.lblPsIdValue.setText(this.rs.getPsId());
            int mps = this.rs.getMainPowerState();
            Color color = mps == 1 ? GREEN : (mps == 0 ? RED : GREY);
            RebPsControlPanel.this.btnMainPower.setEnabled(color != GREY);
            RebPsControlPanel.this.btnMainPower.setBackground(color);
            RebPsControlPanel.this.tfPowerPeriod.setEnabled(true);
            RebPsControlPanel.this.powerPeriod = (double)this.rs.getTickMillis() / 1000.0;
            RebPsControlPanel.this.tfPowerPeriod.setText(String.valueOf(RebPsControlPanel.this.powerPeriod));
            Map btnMap = isCR ? btnMapCR : btnMapSR;
            int[] state = this.rs.getPowerState();
            double[] bDacs = this.rs.getHvBiasDacs();
            double[] dDacs = this.rs.getDphiDacs();
            for (int reb = 0; reb < nReb; ++reb) {
                boolean present = state[reb] >= 0;
                RebPsControlPanel.this.btnSeqOn[reb].setEnabled(present);
                RebPsControlPanel.this.btnSeqOff[reb].setEnabled(present);
                for (int ps = 0; ps < 7; ++ps) {
                    color = present ? ((state[reb] & 1 << ps + 1) == 0 ? RED : GREEN) : GREY;
                    int btnPsReb = (Integer)btnMap.get(reb << 4 | ps);
                    RebPsControlPanel.this.btnToggle[btnPsReb >> 4][btnPsReb & 0xF].setEnabled(present);
                    RebPsControlPanel.this.btnToggle[btnPsReb >> 4][btnPsReb & 0xF].setBackground(color);
                }
                RebPsControlPanel.this.tfBiasDac[reb].setEnabled(present);
                int value = reb < bDacs.length ? (int)bDacs[reb] : 0;
                RebPsControlPanel.this.tfBiasDac[reb].setText(String.valueOf(value));
                ((RebPsControlPanel)RebPsControlPanel.this).biasDacs[reb] = value;
                RebPsControlPanel.this.tfDphiDac[reb].setEnabled(present);
                value = reb < dDacs.length ? (int)dDacs[reb] : 0;
                RebPsControlPanel.this.tfDphiDac[reb].setText(String.valueOf(value));
                ((RebPsControlPanel)RebPsControlPanel.this).dphiDacs[reb] = value;
            }
        }
    }
}

