/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.fits.dao;

import java.sql.Timestamp;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.fits.dao.Image;
import org.lsst.fits.dao.Image_;
import org.lsst.fits.dao.SessionUtil;
import org.lsst.fits.fitsinfo.Filter;
import org.lsst.fits.fitsinfo.Sort;

public class ImageDAO {
    private final String site;

    public ImageDAO(String site) {
        this.site = site;
    }

    public List<Image> getImages(int skip, int take, Filter filter, Sort sort) {
        try (Session session = SessionUtil.getSession((String)this.site);){
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(Image.class);
            Root root = criteria.from(Image.class);
            criteria.select((Selection)root);
            if (sort != null) {
                criteria.orderBy(sort.buildQuery(builder, root));
            } else {
                criteria.orderBy(new Order[]{builder.asc((Expression)root.get(Image_.obsId)), builder.asc((Expression)root.get(Image_.controller)), builder.asc((Expression)root.get(Image_.dayobs)), builder.asc((Expression)root.get(Image_.seqnum))});
            }
            if (filter != null) {
                criteria.where(filter.buildQuery(builder, root));
            }
            Query query = session.createQuery(criteria);
            if (skip > 0) {
                query.setFirstResult(skip);
            }
            if (take > 0) {
                query.setMaxResults(take);
            }
            List list = query.getResultList();
            return list;
        }
    }

    public Image getImage(ImageName in) {
        try (Session session = SessionUtil.getSession((String)this.site);){
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(Image.class);
            Root root = criteria.from(Image.class);
            Predicate[] predicates = new Predicate[]{builder.equal((Expression)root.get(Image_.seqnum), (Object)in.getNumber()), builder.equal((Expression)root.get(Image_.dayobs), (Object)in.getDateString()), builder.equal((Expression)root.get(Image_.controller), (Object)in.getController().getCode()), builder.equal((Expression)root.get(Image_.telCode), (Object)in.getSource().getCode())};
            criteria.select((Selection)root).where(predicates);
            Image image = (Image)session.createQuery(criteria).getSingleResult();
            return image;
        }
    }

    /*
     * Loose catch block
     */
    public Image getLatestImage() {
        Throwable throwable = null;
        try (Session session = SessionUtil.getSession((String)this.site);){
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(Image.class);
            Root root = criteria.from(Image.class);
            Subquery subquery = criteria.subquery(Timestamp.class);
            Root subRoot = subquery.from(Image.class);
            subquery.select(builder.greatest((Expression)subRoot.get(Image_.obsDate)));
            criteria.select((Selection)root).where((Expression)builder.equal((Expression)root.get(Image_.obsDate), (Expression)subquery));
            try {
                Image image = (Image)session.createQuery(criteria).setMaxResults(1).getSingleResult();
                return image;
            }
            catch (NoResultException x) {
                Image image;
                block17: {
                    block18: {
                        image = null;
                        if (session == null) break block17;
                        if (throwable == null) break block18;
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block17;
                    }
                    session.close();
                }
                return image;
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public String getNextImage(ImageName in) {
        Throwable throwable = null;
        try (Session session = SessionUtil.getSession((String)this.site);){
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(Image.class);
            Root root = criteria.from(Image.class);
            Predicate[] predicates = new Predicate[]{builder.equal((Expression)root.get(Image_.controller), (Object)in.getController().getCode()), builder.equal((Expression)root.get(Image_.telCode), (Object)in.getSource().getCode()), builder.or((Expression)builder.greaterThan((Expression)root.get(Image_.dayobs), (Comparable)((Object)in.getDateString())), (Expression)builder.and((Expression)builder.greaterThan((Expression)root.get(Image_.seqnum), (Comparable)Integer.valueOf(in.getNumber())), (Expression)builder.equal((Expression)root.get(Image_.dayobs), (Object)in.getDateString())))};
            criteria.select((Selection)root).where(predicates);
            criteria.orderBy(new Order[]{builder.asc((Expression)root.get(Image_.dayobs)), builder.asc((Expression)root.get(Image_.seqnum))});
            try {
                Image image = (Image)session.createQuery(criteria).setMaxResults(1).getSingleResult();
                String string = image.getObsId();
                return string;
            }
            catch (NoResultException x) {
                String string;
                block17: {
                    block18: {
                        string = null;
                        if (session == null) break block17;
                        if (throwable == null) break block18;
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block17;
                    }
                    session.close();
                }
                return string;
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public String getPreviousImage(ImageName in) {
        Throwable throwable = null;
        try (Session session = SessionUtil.getSession((String)this.site);){
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(Image.class);
            Root root = criteria.from(Image.class);
            Predicate[] predicates = new Predicate[]{builder.equal((Expression)root.get(Image_.controller), (Object)in.getController().getCode()), builder.equal((Expression)root.get(Image_.telCode), (Object)in.getSource().getCode()), builder.or((Expression)builder.lessThan((Expression)root.get(Image_.dayobs), (Comparable)((Object)in.getDateString())), (Expression)builder.and((Expression)builder.lessThan((Expression)root.get(Image_.seqnum), (Comparable)Integer.valueOf(in.getNumber())), (Expression)builder.equal((Expression)root.get(Image_.dayobs), (Object)in.getDateString())))};
            criteria.select((Selection)root).where(predicates);
            criteria.orderBy(new Order[]{builder.desc((Expression)root.get(Image_.dayobs)), builder.desc((Expression)root.get(Image_.seqnum))});
            try {
                Image image = (Image)session.createQuery(criteria).setMaxResults(1).getSingleResult();
                String string = image.getObsId();
                return string;
            }
            catch (NoResultException x) {
                String string;
                block17: {
                    block18: {
                        string = null;
                        if (session == null) break block17;
                        if (throwable == null) break block18;
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block17;
                    }
                    session.close();
                }
                return string;
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    public Long getTotalImageCount(Filter filter) {
        try (Session session = SessionUtil.getSession((String)this.site);){
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery countQuery = builder.createQuery(Long.class);
            Root root = countQuery.from(Image.class);
            if (filter != null) {
                countQuery.where(filter.buildQuery(builder, root));
            }
            countQuery.select((Selection)builder.count((Expression)root));
            Long l = (Long)session.createQuery(countQuery).getSingleResult();
            return l;
        }
    }

    public List<Object> getImageGroup(String groupSelector, boolean desc, int skip, int take, Filter filter) {
        try (Session session = SessionUtil.getSession((String)this.site);){
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery();
            Root root = criteria.from(Image.class);
            criteria.groupBy(new Expression[]{root.get(groupSelector)});
            criteria.multiselect(new Selection[]{root.get(groupSelector), builder.count((Expression)root)});
            if (desc) {
                criteria.orderBy(new Order[]{builder.desc((Expression)root.get(groupSelector))});
            } else {
                criteria.orderBy(new Order[]{builder.asc((Expression)root.get(groupSelector))});
            }
            if (filter != null) {
                criteria.where(filter.buildQuery(builder, root));
            }
            Query query = session.createQuery(criteria);
            if (skip > 0) {
                query.setFirstResult(skip);
            }
            if (take > 0) {
                query.setMaxResults(take);
            }
            List list = query.getResultList();
            return list;
        }
    }

    public Long getImageGroupCount(String groupSelector, Filter filter) {
        try (Session session = SessionUtil.getSession((String)this.site);){
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery countQuery = builder.createQuery(Long.class);
            Root root = countQuery.from(Image.class);
            if (filter != null) {
                countQuery.where(filter.buildQuery(builder, root));
            }
            countQuery.select((Selection)builder.countDistinct((Expression)root.get(groupSelector)));
            Long l = (Long)session.createQuery(countQuery).getSingleResult();
            return l;
        }
    }
}

