/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.fits.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Formula;

@Entity
@Table(name="ccs_image")
public class Image
implements Serializable {
    @Id
    private String telCode;
    @Id
    private String controller;
    @Id
    private String dayobs;
    @Id
    private int seqnum;
    private String imgType;
    private String testType;
    private String runNumber;
    private Integer tseqnum;
    private String tstand;
    private String fileLocation;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date obsDate;
    private int raftMask;
    private Float exposureTime;
    private Float darkTime;
    @Formula(value="concat(telcode,'_',controller,'_',dayobs,'_',lpad(seqnum,6,'0'))")
    private String obsId;
    @Formula(value="cast(runNumber as INTEGER)")
    private Long run;
    @Formula(value="CASE WHEN runNumber is null THEN 'NONE' ELSE CASE WHEN runNumber like '%D' THEN 'DEV' ELSE 'PROD' END END")
    private String runMode;

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.telCode);
        hash = 89 * hash + Objects.hashCode(this.controller);
        hash = 89 * hash + Objects.hashCode(this.dayobs);
        hash = 89 * hash + this.seqnum;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Image other = (Image)obj;
        if (this.seqnum != other.seqnum) {
            return false;
        }
        if (!Objects.equals(this.telCode, other.telCode)) {
            return false;
        }
        if (!Objects.equals(this.controller, other.controller)) {
            return false;
        }
        return Objects.equals(this.dayobs, other.dayobs);
    }

    public String getTelCode() {
        return this.telCode;
    }

    public String getController() {
        return this.controller;
    }

    public String getDayobs() {
        return this.dayobs;
    }

    public int getSeqnum() {
        return this.seqnum;
    }

    public String getImgType() {
        return this.imgType;
    }

    public String getTestType() {
        return this.testType;
    }

    public String getRunNumber() {
        return this.runNumber;
    }

    public Long getRun() {
        return this.run;
    }

    public String getRunMode() {
        return this.runMode;
    }

    public int getTseqnum() {
        return this.tseqnum == null ? 0 : this.tseqnum;
    }

    public String getTstand() {
        return this.tstand;
    }

    public String getFileLocation() {
        return this.fileLocation;
    }

    public Date getObsDate() {
        return this.obsDate;
    }

    public int getRaftMask() {
        return this.raftMask == 0 ? 4096 : this.raftMask;
    }

    public String getObsId() {
        return this.obsId;
    }

    public float getExposureTime() {
        return this.exposureTime == null ? 0.0f : this.exposureTime.floatValue();
    }

    public float getDarkTime() {
        return this.darkTime == null ? 0.0f : this.darkTime.floatValue();
    }

    public String toString() {
        return "Image{telCode=" + this.telCode + ", controller=" + this.controller + ", dayobs=" + this.dayobs + ", seqnum=" + this.seqnum + ", imgType=" + this.imgType + ", testType=" + this.testType + ", runNumber=" + this.runNumber + ", tseqnum=" + this.tseqnum + ", tstand=" + this.tstand + ", fileLocation=" + this.fileLocation + ", obsDate=" + this.obsDate + ", raftMask=" + this.raftMask + ", exposureTime=" + this.exposureTime + ", darkTime=" + this.darkTime + ", obsId=" + this.obsId + '}';
    }
}

