/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.fits.headers.restdatasource;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.lsst.ccs.fits.headers.restdatasource.JsonReader;
import org.lsst.ccs.imagenaming.ImageName;

/*
 * Exception performing whole class analysis ignored.
 */
public class JsonReader {
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile(".*_(R\\d\\d_S.\\d).json");
    private final Path root;

    JsonReader(Path root) {
        this.root = root;
    }

    Map<String, Object> read(Path file) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        1 valueTypeRef = new /* Unavailable Anonymous Inner Class!! */;
        try (BufferedReader reader = Files.newBufferedReader(file);){
            Map readValue = (Map)objectMapper.readValue((Reader)reader, (TypeReference)valueTypeRef);
            readValue.remove("__CONTENT__");
            Map map = readValue;
            return map;
        }
    }

    List<String> getComponents(ImageName imageName) throws IOException {
        Path path = this.root.resolve(imageName.getDateString()).resolve(imageName.toString());
        Stream<String> sorted = Files.list(path).filter(file -> !Files.isDirectory(file, new LinkOption[0])).map(Path::getFileName).map(Path::toString).map(s -> FILE_NAME_PATTERN.matcher((CharSequence)s)).filter(Matcher::matches).map(m -> m.group(1)).sorted();
        return Stream.concat(Stream.of("common"), sorted).collect(Collectors.toList());
    }

    private Map<String, Object> getCommonHeaders(ImageName imageName) throws IOException {
        Path path = this.root.resolve(imageName.getDateString()).resolve(imageName.toString());
        List files = Files.list(path).filter(file -> !Files.isDirectory(file, new LinkOption[0])).filter(file -> FILE_NAME_PATTERN.matcher(file.getFileName().toString()).matches()).collect(Collectors.toList());
        Map result = null;
        for (Path file2 : files) {
            Map headers = this.read(file2);
            result = JsonReader.keepCommon(result, (Map)headers);
        }
        return result;
    }

    private static Map<String, Object> keepCommon(Map<String, Object> a, Map<String, Object> b) {
        if (a == null) {
            return b;
        }
        b.forEach((key, value) -> {
            if (a.containsKey(key) && !Objects.equals(a.get(key), value)) {
                a.remove(key);
            }
        });
        return a;
    }

    Map<String, Object> getHeadersForComponent(ImageName imageName, String component) throws IOException {
        Map commonHeaders = this.getCommonHeaders(imageName);
        if ("common".equals(component)) {
            return commonHeaders;
        }
        Path file = this.root.resolve(imageName.getDateString()).resolve(imageName.toString()).resolve(imageName + "_" + component + ".json");
        Map headers = this.read(file);
        for (String key : commonHeaders.keySet()) {
            headers.remove(key);
        }
        return headers;
    }

    static Map<String, Object> suppressNullValues(Map<String, Object> in) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : in.entrySet()) {
            if (entry.getValue() == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        Path path = Paths.get("/home/tonyj/Data/", new String[0]);
        JsonReader reader = new JsonReader(path);
        ImageName imageName = new ImageName("MC_C_20231126_000275");
        List imageNameComponents = reader.getComponents(imageName);
        System.out.println(imageNameComponents);
        Map c = reader.read(Paths.get("/home/tonyj/Data/20231126/MC_C_20231126_000275/MC_C_20231126_000275_R03_S10.json", new String[0]));
        System.out.println(c);
        Map commonHeaders = reader.getHeadersForComponent(imageName, "common");
        System.out.println(JsonReader.suppressNullValues((Map)commonHeaders));
        Map uncommonHeaders = reader.getHeadersForComponent(imageName, "R11_S12");
        System.out.println(uncommonHeaders);
    }
}

