/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.fits.fitsinfo;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.fits.dao.Image;
import org.lsst.fits.dao.ImageDAO;
import org.lsst.fits.fitsinfo.Filter;
import org.lsst.fits.fitsinfo.Group;
import org.lsst.fits.fitsinfo.GroupSummary;
import org.lsst.fits.fitsinfo.Sort;

@Path(value="/")
@Produces(value={"application/json"})
public class FitsDataSource {
    @GET
    @Path(value="/{site}/images")
    public Object images(@PathParam(value="site") String siteName, @DefaultValue(value="0") @QueryParam(value="skip") int skip, @DefaultValue(value="0") @QueryParam(value="take") int take, @DefaultValue(value="false") @QueryParam(value="requireTotalCount") boolean requireTotalCount, @DefaultValue(value="false") @QueryParam(value="requireGroupCount") boolean requireGroupCount, @DefaultValue(value="[]") @QueryParam(value="group") Group groups, @DefaultValue(value="[]") @QueryParam(value="sort") Sort sort, @DefaultValue(value="[]") @QueryParam(value="filter") Filter filter, @DefaultValue(value="[]") @QueryParam(value="groupSummary") GroupSummary groupSummary) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        ImageDAO dao = new ImageDAO(siteName);
        if (groups != null) {
            ArrayList groupData = new ArrayList();
            for (Group.GroupEntry group : groups.getEntries()) {
                String selector = group.getSelector();
                List resultSet = dao.getImageGroup(selector, group.isDesc(), skip, take, filter);
                for (Object rs : resultSet) {
                    LinkedHashMap<String, Object> groupResult = new LinkedHashMap<String, Object>();
                    Object[] rsa = (Object[])rs;
                    groupResult.put("key", rsa[0]);
                    if (group.isExpanded()) {
                        throw new UnsupportedOperationException("group isExpanded not implemented yet");
                    }
                    groupResult.put("items", null);
                    groupResult.put("count", rsa[1]);
                    groupData.add(groupResult);
                    if (groupSummary == null) continue;
                    groupResult.put("summary", new Long[]{(Long)rsa[1]});
                }
                if (!requireGroupCount) continue;
                result.put("groupCount", dao.getImageGroupCount(selector, filter));
            }
            result.put("data", groupData);
        } else {
            List images = dao.getImages(skip, take, filter, sort);
            result.put("data", images);
        }
        if (requireTotalCount) {
            result.put("totalCount", dao.getTotalImageCount(filter));
        }
        return result;
    }

    @GET
    @Path(value="/{site}/image/{id}")
    public Image image(@PathParam(value="site") String siteName, @PathParam(value="id") String id) {
        ImageDAO dao = new ImageDAO(siteName);
        return dao.getImage(new ImageName(id));
    }

    @GET
    @Path(value="/{site}/imageInfo/{id}")
    public Map<String, Object> imageInfo(@PathParam(value="site") String siteName, @PathParam(value="id") String id) {
        ImageName in;
        Image image;
        ImageDAO dao = new ImageDAO(siteName);
        if ("latest".equalsIgnoreCase(id)) {
            image = dao.getLatestImage();
            in = new ImageName(image.getObsId());
        } else {
            in = new ImageName(id);
            image = dao.getImage(in);
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("image", image);
        result.put("next", dao.getNextImage(in));
        result.put("previous", dao.getPreviousImage(in));
        return result;
    }
}

