/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.fits.imageio.wcs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class WCSReader {
    Map<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>();

    public WCSReader(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public WCSReader(URL url) throws IOException {
        this(url.openStream());
    }

    public WCSReader(InputStream input) throws IOException {
        Properties props = new Properties();
        props.load(input);
        input.close();
        String keys = props.get("legend").toString();
        if (keys == null) {
            throw new IOException("Missing legend in wCS file");
        }
        Object[] keyList = keys.split("\\s*,\\s*");
        System.out.println(Arrays.toString(keyList));
        props.entrySet().stream().filter(e -> !"legend".equals(e.getKey())).forEach(arg_0 -> this.lambda$new$1((String[])keyList, arg_0));
    }

    public Map<String, Map<String, Object>> getWCSInfo() {
        return this.data;
    }

    private /* synthetic */ void lambda$new$1(String[] keyList, Map.Entry e) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String key = e.getKey().toString();
        String value = e.getValue().toString();
        String[] values = value.split(",\\s+");
        for (int i = 0; i < keyList.length; ++i) {
            if (values[i].startsWith("[")) {
                result.put(keyList[i], values[i]);
                continue;
            }
            double v = Double.parseDouble(values[i]);
            result.put(keyList[i], v);
        }
        this.data.put(key, result);
    }
}

