/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.fits.imageio.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import org.lsst.fits.imageio.CameraImageReadParam;
import org.lsst.fits.imageio.CameraImageReader;
import org.lsst.fits.imageio.Segment;
import org.lsst.fits.imageio.bias.BiasCorrection;
import org.lsst.fits.imageio.test.ImageReaderComponent;

public class Main {
    private CameraImageReader reader;
    private CameraImageReadParam readParam;
    private ImageReaderComponent ic;
    private static final Logger LOG = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) throws IOException, UnsupportedLookAndFeelException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        Main main = new Main();
        main.start(args[0]);
    }

    private void start(String file) throws IOException {
        CameraImageReader reader = this.open(new File(file));
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createColorMenu());
        menuBar.add(this.createBiasMenu());
        menuBar.add(this.createOverscanMenu());
        menuBar.add(this.createScaleMenu());
        this.ic = new ImageReaderComponent(true, reader, this.readParam);
        final JTextField infoComponent = new JTextField("Info");
        infoComponent.setEditable(false);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)this.ic, "Center");
        contentPanel.add((Component)infoComponent, "South");
        this.ic.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point ip = Main.this.ic.getImagePosition(e.getPoint());
                StringBuilder builder = new StringBuilder();
                builder.append("x=").append(ip.x).append(" y=").append(ip.y);
                Segment segment = Main.this.reader.getImageMetaDataForPoint(Main.this.readParam, ip.x, ip.y);
                if (segment != null) {
                    try {
                        builder.append(" ").append(segment.getRaftBay()).append(" ").append(segment.getCcdSlot()).append(" ").append(segment.getSegmentName());
                        AffineTransform wcsTranslation = segment.getWCSTranslation(false);
                        AffineTransform inverse = wcsTranslation.createInverse();
                        inverse.transform(ip, ip);
                        builder.append(" x=").append(ip.x).append(" y=").append(ip.y);
                        Number pixel = Main.this.reader.getPixelForSegment(segment, ip.x, ip.y);
                        builder.append(" pixel=").append(pixel);
                        int rgb = Main.this.reader.getRGBForSegment(segment, ip.x, ip.y);
                        builder.append(" rgb=").append(rgb & 0xFF);
                        BiasCorrection.CorrectionFactors cf = Main.this.reader.getCorrectionFactorForSegment(segment);
                        int correctionFactor = cf.correctionFactor(segment.getDataSec().x + ip.x, segment.getDataSec().y + ip.y);
                        builder.append(" cf=").append(correctionFactor);
                    }
                    catch (NoninvertibleTransformException ex) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                infoComponent.setText(builder.toString());
            }
        });
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame();
            frame.setJMenuBar(menuBar);
            frame.setContentPane(contentPanel);
            frame.setDefaultCloseOperation(3);
            frame.setSize(new Dimension(600, 600));
            frame.setVisible(true);
        });
    }

    private CameraImageReader open(File file) throws IOException {
        int pos_suffix = file.getName().lastIndexOf(46);
        String suffix = file.getName().substring(pos_suffix);
        Iterator<ImageReader> imageReadersByFormatName = ImageIO.getImageReadersBySuffix(suffix);
        this.reader = (CameraImageReader)imageReadersByFormatName.next();
        CameraImageReadParam newReadParam = this.reader.getDefaultReadParam();
        if (this.readParam != null) {
            newReadParam.setColorMap(this.readParam.getColorMap());
            newReadParam.setBiasCorrection(this.readParam.getBiasCorrection());
            newReadParam.setScale(this.readParam.getScale());
            newReadParam.setShowBiasRegions(this.readParam.isShowBiasRegions());
        }
        this.readParam = newReadParam;
        this.reader.setInput(ImageIO.createImageInputStream(file));
        return this.reader;
    }

    private JMenu createFileMenu() {
        JMenu fileMenu = new JMenu("File");
        JMenuItem open = new JMenuItem("Open...");
        open.addActionListener(event -> {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "Raft file (.raft)";
                }

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".raft");
                }
            });
            chooser.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "Focal Plane file (.fp)";
                }

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".fp");
                }
            });
            chooser.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "CCD file (.ccd)";
                }

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".ccd");
                }
            });
            int rc = chooser.showOpenDialog(this.ic);
            if (rc == 0) {
                try {
                    this.reader = this.open(chooser.getSelectedFile());
                    this.ic.setImageReader(this.reader, this.readParam);
                }
                catch (IOException ex) {
                    LOG.log(Level.SEVERE, "Unable to open file", ex);
                }
            }
        });
        fileMenu.add(open);
        return fileMenu;
    }

    private JMenu createBiasMenu() {
        JMenu biasMenu = new JMenu("Bias");
        ButtonGroup group = new ButtonGroup();
        String currentBiasCorrection = this.readParam.getBiasCorrectionName();
        for (String biasCorrectionMenuName : this.readParam.getAvailableBiasCorrections()) {
            JCheckBoxMenuItem biasCorrectionItem = new JCheckBoxMenuItem(biasCorrectionMenuName);
            if (biasCorrectionMenuName.equals(currentBiasCorrection)) {
                biasCorrectionItem.setSelected(true);
            }
            biasCorrectionItem.addActionListener(e -> {
                this.readParam.setBiasCorrection(((JMenuItem)e.getSource()).getText());
                this.refresh();
            });
            group.add(biasCorrectionItem);
            biasMenu.add(biasCorrectionItem);
        }
        return biasMenu;
    }

    private JMenu createOverscanMenu() {
        JMenu overscanMenu = new JMenu("Overscan");
        JCheckBoxMenuItem show = new JCheckBoxMenuItem("Show");
        show.addActionListener(e -> {
            this.readParam.setShowBiasRegions(((JMenuItem)e.getSource()).isSelected());
            this.refresh();
        });
        overscanMenu.add(show);
        return overscanMenu;
    }

    private JMenu createColorMenu() {
        JMenu colorMenu = new JMenu("Color");
        ButtonGroup group = new ButtonGroup();
        String currentColorItem = this.readParam.getColorMapName();
        for (String colorMenuItemName : this.readParam.getAvailableColorMaps()) {
            JCheckBoxMenuItem colorMenuItem = new JCheckBoxMenuItem(colorMenuItemName);
            if (colorMenuItemName.equals(currentColorItem)) {
                colorMenuItem.setSelected(true);
            }
            colorMenuItem.addActionListener(e -> {
                this.readParam.setColorMap(((JMenuItem)e.getSource()).getText());
                this.refresh();
            });
            group.add(colorMenuItem);
            colorMenu.add(colorMenuItem);
        }
        return colorMenu;
    }

    private JMenu createScaleMenu() {
        JMenu scaleMenu = new JMenu("Scale");
        JCheckBoxMenuItem global = new JCheckBoxMenuItem("Global");
        global.setSelected(this.readParam.getScale() == CameraImageReadParam.Scale.GLOBAL);
        global.addActionListener(e -> {
            this.readParam.setScale(global.isSelected() ? CameraImageReadParam.Scale.GLOBAL : CameraImageReadParam.Scale.AMPLIFIER);
            this.refresh();
        });
        scaleMenu.add(global);
        return scaleMenu;
    }

    private void refresh() {
        try {
            this.ic.setImageReader(this.reader, this.readParam);
        }
        catch (IOException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

