/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.fits.imageio.test;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public final class ImageReaderComponent
extends JComponent {
    private static final long serialVersionUID = 1L;
    private float scale = 1.0f;
    private ImageReader reader = null;
    private float minScale = 0.0f;
    private final float maxScale = 10.0f;
    private JScrollPane scroll;
    private boolean zoomScaleSet = false;
    private int imageHeight;
    private int imageWidth;
    private BufferedImage bi;
    private ImageReadParam param;

    public ImageReaderComponent() {
        this(false);
    }

    public ImageReaderComponent(boolean zoomPan) {
        this.setLayout(new BorderLayout());
        Inner inner = new Inner();
        if (zoomPan) {
            this.scroll = new JScrollPane(inner);
            this.add(this.scroll);
        } else {
            this.add(inner);
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (ImageReaderComponent.this.zoomScaleSet) {
                    ImageReaderComponent.this.minScale = Math.min((float)ImageReaderComponent.this.getHeight() / (float)ImageReaderComponent.this.imageHeight, (float)ImageReaderComponent.this.getWidth() / (float)ImageReaderComponent.this.imageWidth);
                    ImageReaderComponent.this.minScale = Math.min(ImageReaderComponent.this.minScale, 10.0f);
                    ImageReaderComponent.this.scale = Math.max(ImageReaderComponent.this.scale, ImageReaderComponent.this.minScale);
                }
            }
        });
    }

    public ImageReaderComponent(boolean zoomPan, ImageReader image, ImageReadParam param) throws IOException {
        this(zoomPan);
        this.setImageReader(image, param);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = new Dimension(200, 200);
        if (this.reader != null) {
            size.width = this.imageWidth;
            size.height = this.imageHeight;
        }
        return size;
    }

    final void setImageReader(ImageReader image, ImageReadParam param) throws IOException {
        this.reader = image;
        this.param = param;
        this.imageHeight = image.getHeight(0);
        this.imageWidth = image.getWidth(0);
        this.zoomScaleSet = false;
        this.repaint();
    }

    private void checkScale() {
        if (!this.zoomScaleSet) {
            this.minScale = Math.min((float)this.getHeight() / (float)this.imageHeight, (float)this.getWidth() / (float)this.imageWidth);
            this.scale = this.minScale = Math.min(this.minScale, 10.0f);
            this.zoomScaleSet = true;
        }
    }

    ImageReader getImage() {
        return this.reader;
    }

    Point getImagePosition(Point point) {
        Rectangle visibleRect = this.scroll.getViewport().getVisibleRect();
        return new Point(Math.round((float)visibleRect.x + (float)point.x / this.scale), Math.round((float)(this.imageHeight - visibleRect.y) - (float)point.y / this.scale));
    }

    private final class Inner
    extends JComponent {
        private static final long serialVersionUID = 1L;

        Inner() {
            MouseAdapter a = new MouseAdapter(){
                private Point savePoint;
                private Rectangle saveViewRectangle;

                @Override
                public void mouseDragged(MouseEvent e) {
                    Rectangle newRectangle = new Rectangle(this.saveViewRectangle);
                    newRectangle.x += this.savePoint.x - e.getX();
                    newRectangle.y += this.savePoint.y - e.getY();
                    ImageReaderComponent.this.scroll.getViewport().scrollRectToVisible(newRectangle);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.savePoint = e.getPoint();
                    this.saveViewRectangle = ImageReaderComponent.this.scroll.getViewport().getVisibleRect();
                }

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    if (e.getPreciseWheelRotation() > 0.0) {
                        Inner.this.zoom(e.getPoint(), 1.1111112f);
                    } else {
                        Inner.this.zoom(e.getPoint(), 0.9f);
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    ImageReaderComponent.this.dispatchEvent(e);
                }
            };
            this.addMouseWheelListener(a);
            this.addMouseMotionListener(a);
            this.addMouseListener(a);
        }

        public void zoom(Point point, float zoomFactor) {
            Point pos = ImageReaderComponent.this.scroll.getViewport().getViewPosition();
            Point2D.Float mouseRelativeToImage = new Point2D.Float((float)point.x / ImageReaderComponent.this.scale, (float)point.y / ImageReaderComponent.this.scale);
            ImageReaderComponent.this.scale *= zoomFactor;
            ImageReaderComponent.this.scale = Math.max(ImageReaderComponent.this.minScale, Math.min(10.0f, ImageReaderComponent.this.scale));
            Point2D.Float mouseRelativeToImageNew = new Point2D.Float((float)point.x / ImageReaderComponent.this.scale, (float)point.y / ImageReaderComponent.this.scale);
            Point2D.Float shiftNeeded = new Point2D.Float(mouseRelativeToImageNew.x - mouseRelativeToImage.x, mouseRelativeToImageNew.y - mouseRelativeToImage.y);
            float newX = (float)pos.x - shiftNeeded.x * ImageReaderComponent.this.scale;
            float newY = (float)pos.y - shiftNeeded.y * ImageReaderComponent.this.scale;
            Point newPos = new Point(Math.round(newX), Math.round(newY));
            ImageReaderComponent.this.scroll.getViewport().setViewPosition(newPos);
            this.revalidate();
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = new Dimension(200, 200);
            if (ImageReaderComponent.this.reader != null) {
                ImageReaderComponent.this.checkScale();
                size.width = (int)((float)ImageReaderComponent.this.imageWidth * ImageReaderComponent.this.scale);
                size.height = (int)((float)ImageReaderComponent.this.imageWidth * ImageReaderComponent.this.scale);
            }
            return size;
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (ImageReaderComponent.this.reader != null) {
                Graphics2D g2 = (Graphics2D)g;
                AffineTransform at = new AffineTransform();
                at.scale(1.0, -1.0);
                at.translate(0.0, -this.getHeight());
                at.scale(ImageReaderComponent.this.scale, ImageReaderComponent.this.scale);
                Rectangle sourceRegion = ImageReaderComponent.this.scroll.getViewport().getViewRect();
                if ((double)ImageReaderComponent.this.scale != 1.0) {
                    double factor = 1.0 / (double)ImageReaderComponent.this.scale;
                    sourceRegion.x = (int)((double)sourceRegion.x * factor);
                    sourceRegion.y = (int)((double)sourceRegion.y * factor);
                    sourceRegion.width = (int)((double)sourceRegion.width * factor);
                    sourceRegion.height = (int)((double)sourceRegion.height * factor);
                }
                Rectangle viewRect = ImageReaderComponent.this.scroll.getViewport().getViewRect();
                int subSamplingX = (int)Math.max(1.0, Math.floor((double)sourceRegion.width / viewRect.getWidth()));
                int subSamplingY = (int)Math.max(1.0, Math.floor((double)sourceRegion.height / viewRect.getHeight()));
                ImageReaderComponent.this.param.setSourceRegion(sourceRegion);
                ImageReaderComponent.this.param.setSourceSubsampling(subSamplingX, subSamplingY, 0, 0);
                try {
                    ImageReaderComponent.this.bi = ImageReaderComponent.this.reader.read(0, ImageReaderComponent.this.param);
                    g2.drawImage(ImageReaderComponent.this.bi, viewRect.x, viewRect.y, viewRect.width, viewRect.height, this);
                }
                catch (IOException ex) {
                    Logger.getLogger(ImageReaderComponent.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

