/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.fits.imageio.test;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class ImageComponent
extends JComponent {
    private static final long serialVersionUID = 1L;
    private float scale = 1.0f;
    private BufferedImage image;
    private float minScale = 0.0f;
    private final float maxScale = 1.0f;
    private final boolean zoomPan;
    private JScrollPane scroll;
    private boolean zoomScaleSet = false;

    public ImageComponent() {
        this(false);
    }

    public ImageComponent(boolean zoomPan) {
        this.zoomPan = zoomPan;
        this.image = null;
        this.setLayout(new BorderLayout());
        Inner inner = new Inner();
        if (zoomPan) {
            this.scroll = new JScrollPane(inner);
            this.add(this.scroll);
        } else {
            this.add(inner);
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (ImageComponent.this.zoomScaleSet) {
                    ImageComponent.this.minScale = Math.min((float)ImageComponent.this.getHeight() / (float)ImageComponent.this.image.getHeight(), (float)ImageComponent.this.getWidth() / (float)ImageComponent.this.image.getWidth());
                    ImageComponent.this.minScale = Math.min(ImageComponent.this.minScale, 1.0f);
                    ImageComponent.this.scale = Math.max(ImageComponent.this.scale, ImageComponent.this.minScale);
                }
            }
        });
    }

    public ImageComponent(boolean zoomPan, BufferedImage image) {
        this(zoomPan);
        this.setImage(image);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = new Dimension(200, 200);
        if (this.image != null) {
            size.width = this.image.getWidth();
            size.height = this.image.getHeight();
        }
        return size;
    }

    final void setImage(BufferedImage image) {
        this.image = image;
        this.zoomScaleSet = false;
        this.repaint();
    }

    private void checkScale() {
        if (!this.zoomScaleSet) {
            this.minScale = Math.min((float)this.getHeight() / (float)this.image.getHeight(), (float)this.getWidth() / (float)this.image.getWidth());
            this.scale = this.minScale = Math.min(this.minScale, 1.0f);
            this.zoomScaleSet = true;
        }
    }

    BufferedImage getImage() {
        return this.image;
    }

    private class Inner
    extends JComponent {
        Inner() {
            if (ImageComponent.this.zoomPan) {
                MouseAdapter a = new MouseAdapter(){
                    private Point savePoint;
                    private Rectangle saveViewRectangle;

                    @Override
                    public void mouseDragged(MouseEvent e) {
                        Rectangle newRectangle = new Rectangle(this.saveViewRectangle);
                        newRectangle.x += this.savePoint.x - e.getX();
                        newRectangle.y += this.savePoint.y - e.getY();
                        ImageComponent.this.scroll.getViewport().scrollRectToVisible(newRectangle);
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        this.savePoint = e.getPoint();
                        this.saveViewRectangle = ImageComponent.this.scroll.getViewport().getVisibleRect();
                    }

                    @Override
                    public void mouseWheelMoved(MouseWheelEvent e) {
                        if (e.getPreciseWheelRotation() > 0.0) {
                            Inner.this.zoom(e.getPoint(), 1.1111112f);
                        } else {
                            Inner.this.zoom(e.getPoint(), 0.9f);
                        }
                    }
                };
                this.addMouseWheelListener(a);
                this.addMouseMotionListener(a);
                this.addMouseListener(a);
            }
        }

        public void zoom(Point point, float zoomFactor) {
            Point pos = ImageComponent.this.scroll.getViewport().getViewPosition();
            Point2D.Float mouseRelativeToImage = new Point2D.Float((float)point.x / ImageComponent.this.scale, (float)point.y / ImageComponent.this.scale);
            ImageComponent.this.scale *= zoomFactor;
            ImageComponent.this.scale = Math.max(ImageComponent.this.minScale, Math.min(1.0f, ImageComponent.this.scale));
            Point2D.Float mouseRelativeToImageNew = new Point2D.Float((float)point.x / ImageComponent.this.scale, (float)point.y / ImageComponent.this.scale);
            Point2D.Float shiftNeeded = new Point2D.Float(mouseRelativeToImageNew.x - mouseRelativeToImage.x, mouseRelativeToImageNew.y - mouseRelativeToImage.y);
            float newX = (float)pos.x - shiftNeeded.x * ImageComponent.this.scale;
            float newY = (float)pos.y - shiftNeeded.y * ImageComponent.this.scale;
            Point newPos = new Point(Math.round(newX), Math.round(newY));
            ImageComponent.this.scroll.getViewport().setViewPosition(newPos);
            this.revalidate();
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = new Dimension(200, 200);
            if (ImageComponent.this.image != null) {
                ImageComponent.this.checkScale();
                size.width = (int)((float)ImageComponent.this.image.getWidth() * ImageComponent.this.scale);
                size.height = (int)((float)ImageComponent.this.image.getHeight() * ImageComponent.this.scale);
            }
            return size;
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (ImageComponent.this.image != null) {
                if (ImageComponent.this.zoomPan) {
                    AffineTransform at = new AffineTransform();
                    at.scale(1.0, -1.0);
                    at.translate(0.0, -this.getHeight());
                    at.scale(ImageComponent.this.scale, ImageComponent.this.scale);
                    ((Graphics2D)g).drawImage(ImageComponent.this.image, at, this);
                } else {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.scale(1.0, -1.0);
                    g2.translate(0, -this.getHeight());
                    g2.drawImage(ImageComponent.this.image, 0, 0, this.getWidth(), this.getHeight(), this);
                }
            }
        }
    }
}

