/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.fits.imageio.scale;

import java.util.Arrays;
import java.util.BitSet;
import org.lsst.fits.imageio.RawData;
import org.lsst.fits.imageio.scale.ScaleCalculator;

public class ZScale
implements ScaleCalculator {
    private static final double MAX_REJECT = 0.5;
    private static final int MIN_NPIXELS = 5;
    private static final double KREJ = 2.5;
    private static final int MAX_ITERATIONS = 5;
    private final double contrast;
    private final int nSamples;

    ZScale(int nSamples, double contrast) {
        this.nSamples = nSamples;
        this.contrast = contrast;
    }

    @Override
    public double[] computeScale(RawData data) {
        int[] samples = this.sample(data, this.nSamples);
        return this.samples(samples);
    }

    private int[] sample(RawData data, int nSamples) {
        int nc = data.getSegment().getNAxis1();
        int nl = data.getSegment().getNAxis2();
        int stride = (int)Math.max(1.0, Math.sqrt((float)((nc - 1) * (nl - 1)) / (float)nSamples));
        return null;
    }

    private double[] samples(int[] samples) {
        Arrays.sort(samples);
        int npix = samples.length;
        double zmin = samples[0];
        double zmax = samples[npix - 1];
        int centerPixel = (npix - 1) / 2;
        double median = npix % 2 == 1 ? (double)samples[centerPixel] : 0.5 * (double)(samples[centerPixel] + samples[centerPixel + 1]);
        int minpix = (int)Math.max(5.0, (double)npix * 0.5);
        int ngrow = (int)Math.max(1.0, (double)npix * 0.01);
        Line line = this.fitLine(samples, 2.5, ngrow, 5);
        if (line.getNGoodPix() < minpix) {
            return new double[]{zmin, zmax};
        }
        double zslope = line.getZSlope();
        if (this.contrast > 0.0) {
            zslope /= this.contrast;
        }
        double z1 = Math.max(zmin, median - (double)(centerPixel - 1) * zslope);
        double z2 = Math.min(zmax, median + (double)(npix - centerPixel) * zslope);
        return new double[]{z1, z2};
    }

    private Line fitLine(int[] samples, double kReject, int ngrow, int maxIterations) {
        int npix = samples.length;
        if (npix <= 1) {
            return new Line(npix, 0, 1);
        }
        int ngoodpix = npix;
        int minpix = (int)Math.max(5.0, (double)npix * 0.5);
        int last_ngoodpix = npix + 1;
        BitSet badpix = new BitSet(npix);
        for (int iter = 0; iter < maxIterations && ngoodpix < last_ngoodpix && ngoodpix >= minpix; ++iter) {
            double sumx = 0.0;
            double sumxx = 0.0;
            double sumxy = 0.0;
            double sumy = 0.0;
            int sum = 0;
            for (int i = 0; i < npix; ++i) {
                if (badpix.get(i)) continue;
                double x = -1.0 + (double)i * 2.0 / (double)(npix - 1);
                sumx += x;
                sumxx += x * x;
                sumxy += x * (double)samples[i];
                sumy += (double)samples[i];
                ++sum;
            }
            double delta = (double)sum * sumxx - sumx * sumx;
            double intercept = (sumxx * sumy - sumx * sumxy) / delta;
            double slope = ((double)sum * sumxy - sumx * sumy) / delta;
            double[] meanSigma = this.computeSigma(badpix, samples, intercept, slope);
            double threshold = meanSigma[1] * kReject;
            for (int i = 0; i < npix; ++i) {
                double x;
                double z;
                if (!badpix.get(i) || !((z = Math.abs((double)samples[i] - (intercept + (x = -1.0 + (double)i * 2.0 / (double)(npix - 1)) * slope))) > threshold)) continue;
                badpix.set(i);
            }
        }
        return null;
    }

    private double[] computeSigma(BitSet badpix, int[] samples, double intercept, double slope) {
        int npix = samples.length;
        double sumz = 0.0;
        double sumzz = 0.0;
        int goodPixels = 0;
        for (int i = 0; i < npix; ++i) {
            if (!badpix.get(i)) continue;
            double x = -1.0 + (double)i * 2.0 / (double)(npix - 1);
            double z = (double)samples[i] - (intercept + x * slope);
            sumz += z;
            sumzz += z * z;
            ++goodPixels;
        }
        switch (goodPixels) {
            case 0: {
                return new double[]{Double.NaN, Double.NaN};
            }
            case 1: {
                return new double[]{sumz, Double.NaN};
            }
        }
        double mean = sumz / (double)goodPixels;
        double temp = sumzz / (double)(goodPixels - 1) - sumz * sumz / (double)(goodPixels * (goodPixels - 1));
        double sigma = temp < 0.0 ? 0.0 : Math.sqrt(temp);
        return new double[]{mean, sigma};
    }

    private static class Line {
        public Line() {
        }

        private Line(int length, int i, int i0) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private int getNGoodPix() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private double getZSlope() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

