/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.fits.imageio.cmap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.fits.imageio.cmap.RGBColorMap;

public class SAOColorMap
extends RGBColorMap {
    private static final Pattern COORD_PATTERN = Pattern.compile("\\(([0-9.]+),([0-9.]+)\\)");
    private int[] rgb;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SAOColorMap(int size, String colorMap) {
        super(size);
        try (InputStream input = SAOColorMap.class.getResourceAsStream(colorMap);){
            if (input == null) {
                throw new RuntimeException("Missing soa file: " + colorMap);
            }
            LineProvider lines = new LineProvider(input);
            ColorScheme colorScheme = ColorScheme.valueOf(lines.nextLine());
            switch (colorScheme) {
                case PSEUDOCOLOR: {
                    HashMap<Color, Interpolation> cmap = new HashMap<Color, Interpolation>();
                    Color currentColor = null;
                    Interpolation currentInterpolation = null;
                    while (true) {
                        String line;
                        if ((line = lines.nextLine()) == null) {
                            if (currentColor == null) break;
                            cmap.put(currentColor, currentInterpolation);
                            break;
                        }
                        if (line.endsWith(":")) {
                            if (currentColor != null) {
                                cmap.put(currentColor, currentInterpolation);
                            }
                            currentColor = Color.valueOf(line.replace(":", ""));
                            currentInterpolation = new Interpolation();
                            continue;
                        }
                        if (currentColor == null || currentInterpolation == null) {
                            throw new RuntimeException("Missing color line");
                        }
                        currentInterpolation.readPoints(line);
                    }
                    this.rgb = SAOColorMap.convertToCMap(size, cmap);
                    return;
                }
                default: {
                    throw new RuntimeException("Unsupported color scheme: " + colorScheme);
                }
            }
        }
        catch (IOException x) {
            throw new RuntimeException("Invalid colormap " + colorMap, x);
        }
    }

    @Override
    public int getRGB(int value) {
        return this.rgb[value];
    }

    private static int[] convertToCMap(int size, Map<Color, Interpolation> cmap) {
        int[] rgb = new int[size];
        for (int i = 0; i < size; ++i) {
            float f = (float)i / ((float)size - 1.0f);
            rgb[i] = Math.round(255.0f * cmap.get((Object)Color.RED).get(f)) << 16 | Math.round(255.0f * cmap.get((Object)Color.GREEN).get(f)) << 8 | Math.round(255.0f * cmap.get((Object)Color.BLUE).get(f));
        }
        return rgb;
    }

    public static void main(String[] args) {
        SAOColorMap image = new SAOColorMap(256, "cubehelix00.sao");
        for (int i = 0; i < image.rgb.length; ++i) {
            System.out.printf("%3d: %06x\n", i, image.rgb[i]);
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + Arrays.hashCode(this.rgb);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SAOColorMap other = (SAOColorMap)obj;
        return Arrays.equals(this.rgb, other.rgb);
    }

    private static class LineProvider
    implements AutoCloseable {
        private final BufferedReader reader;

        public LineProvider(InputStream input) {
            this.reader = new BufferedReader(new InputStreamReader(input));
        }

        String nextLine() throws IOException {
            String line;
            String[] tokens;
            String commentRemoved;
            do {
                if ((line = this.reader.readLine()) != null) continue;
                return null;
            } while ((commentRemoved = (tokens = line.split("#", 2))[0].trim()).isEmpty());
            return commentRemoved;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }

    private static enum ColorScheme {
        PSEUDOCOLOR;

    }

    private static enum Color {
        RED,
        GREEN,
        BLUE;

    }

    private static class Interpolation {
        private final List<Float> x = new ArrayList<Float>();
        private final List<Float> y = new ArrayList<Float>();

        private Interpolation() {
        }

        float get(float value) {
            int binarySearch = Collections.binarySearch(this.x, Float.valueOf(value));
            if (binarySearch >= 0) {
                return this.y.get(binarySearch).floatValue();
            }
            float y1 = this.y.get(-binarySearch - 2).floatValue();
            float y2 = this.y.get(-binarySearch - 1).floatValue();
            float x1 = this.x.get(-binarySearch - 2).floatValue();
            float x2 = this.x.get(-binarySearch - 1).floatValue();
            return y1 + (y2 - y1) * (value - x1) / (x2 - x1);
        }

        void readPoints(String line) throws IOException {
            Matcher matcher = COORD_PATTERN.matcher(line);
            while (matcher.find()) {
                if (matcher.groupCount() != 2) {
                    throw new IOException("Invalid pattern: " + COORD_PATTERN);
                }
                float f1 = Float.parseFloat(matcher.group(1));
                float f2 = Float.parseFloat(matcher.group(2));
                this.add(f1, f2);
            }
        }

        private void add(float x, float y) {
            this.x.add(Float.valueOf(x));
            this.y.add(Float.valueOf(y));
        }
    }
}

