/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.fits.imageio.cmap;

import java.awt.image.ByteLookupTable;
import java.awt.image.LookupOp;

public abstract class RGBColorMap {
    private final int size;

    public RGBColorMap(int size) {
        this.size = size;
    }

    public abstract int getRGB(int var1);

    public int getSize() {
        return this.size;
    }

    public LookupOp getLookupOp() {
        byte[][] data = new byte[3][this.size];
        for (int i = 0; i < this.size; ++i) {
            int rgb = this.getRGB(i);
            data[0][i] = (byte)(rgb >> 16 & 0xFF);
            data[1][i] = (byte)(rgb >> 8 & 0xFF);
            data[2][i] = (byte)(rgb & 0xFF);
        }
        ByteLookupTable table = new ByteLookupTable(0, data);
        return new LookupOp(table, null);
    }
}

