/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.fits.imageio.bias;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.Arrays;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.TruncatedFileException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.BufferedFile;
import org.lsst.fits.imageio.Segment;
import org.lsst.fits.imageio.bias.BiasCorrection;

public class SerialParallelBiasSubtraction2
implements BiasCorrection {
    private final int targetBiasLevel = 20000;

    @Override
    public BiasCorrection.CorrectionFactors compute(IntBuffer data, Segment segment) {
        int nAxis1 = segment.getNAxis1();
        int nAxis2 = segment.getNAxis2();
        Rectangle datasec = segment.getDataSec();
        int[] serialBias = new int[datasec.height];
        int averageSerialBias = 0;
        int serialOverscanStart = datasec.x + datasec.width + 4;
        int position = 0;
        for (int y = datasec.y; y < datasec.height + datasec.y; ++y) {
            int biasSum = 0;
            for (int x = serialOverscanStart; x < nAxis1; ++x) {
                biasSum += data.get(position + x);
            }
            serialBias[y - datasec.y] = biasSum /= nAxis1 - serialOverscanStart;
            averageSerialBias += biasSum;
            position += nAxis1;
        }
        averageSerialBias /= datasec.height;
        int i = 0;
        while (i < serialBias.length) {
            int n = i++;
            serialBias[n] = serialBias[n] - averageSerialBias;
        }
        int[] parallelBias = new int[datasec.width];
        int averageParallelBias = 0;
        int parallelOverscanStart = datasec.y + datasec.height + 4;
        int prevBiasSum = 22000;
        for (int x = datasec.x; x < datasec.width + datasec.x; ++x) {
            int biasSum = 0;
            for (int y = parallelOverscanStart; y < nAxis2; ++y) {
                biasSum += data.get(x + y * nAxis1);
            }
            if ((biasSum /= nAxis2 - parallelOverscanStart) > 100000 || biasSum < 10000) {
                biasSum = prevBiasSum;
            }
            parallelBias[x - datasec.x] = biasSum;
            averageParallelBias += biasSum;
            position += nAxis1;
            prevBiasSum = biasSum;
        }
        averageParallelBias /= datasec.width;
        int i2 = 0;
        while (i2 < parallelBias.length) {
            int n = i2++;
            parallelBias[n] = parallelBias[n] - averageParallelBias;
        }
        int overallCorrection = 20000 - (averageSerialBias * datasec.height + averageParallelBias * datasec.width) / (datasec.height + datasec.width);
        SimpleCorrectionFactors simpleCorrectionFactors = new SimpleCorrectionFactors(datasec, overallCorrection, serialBias, parallelBias);
        return simpleCorrectionFactors;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return SerialParallelBiasSubtraction2.class.hashCode();
    }

    public static void main(String[] args) throws IOException, TruncatedFileException, FitsException {
        File file = new File("/home/tonyj/Data/pretty/20_Flat_screen_0000_20190322172301.fits");
        BufferedFile bf = new BufferedFile(file, "r");
        Header header = new Header((ArrayDataInput)bf);
        for (int i = 0; i < 11; ++i) {
            header = new Header((ArrayDataInput)bf);
            bf.seek(bf.getFilePointer() + header.getDataSize());
        }
        header = new Header((ArrayDataInput)bf);
        Segment segment = new Segment(header, file, bf, "R22", "S20", '4', null);
        IntBuffer intBuffer = (IntBuffer)segment.readRawDataAsync(null).join().getBuffer();
        SerialParallelBiasSubtraction2 bc = new SerialParallelBiasSubtraction2();
        BiasCorrection.CorrectionFactors factors = bc.compute(intBuffer, segment);
        System.out.println(factors);
    }

    public static class SimpleCorrectionFactors
    implements BiasCorrection.CorrectionFactors {
        private final Rectangle datasec;
        private final int[] serialBias;
        private final int[] parallelBias;
        private final int overallCorrection;

        private SimpleCorrectionFactors(Rectangle datasec, int overallCorrection, int[] serialBias, int[] parallelBias) {
            this.datasec = datasec;
            this.serialBias = serialBias;
            this.parallelBias = parallelBias;
            this.overallCorrection = overallCorrection;
        }

        @Override
        public int correctionFactor(int x, int y) {
            return -this.overallCorrection + this.serialBias[y - this.datasec.y] + this.parallelBias[x - this.datasec.x];
        }

        public String toString() {
            double sAvg = Arrays.stream(this.serialBias).average().getAsDouble();
            double pAvg = Arrays.stream(this.parallelBias).average().getAsDouble();
            return "SimpleCorrectionFactors{savg=" + sAvg + ", pavg=" + pAvg + ", datasec=" + this.datasec + ", serialBias=" + Arrays.toString(this.serialBias) + ", parallelBias=" + Arrays.toString(this.parallelBias) + ", overallCorrection=" + this.overallCorrection + "}";
        }
    }
}

