/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.fits.imageio.bias;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.Arrays;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.TruncatedFileException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.BufferedFile;
import org.lsst.fits.imageio.Segment;
import org.lsst.fits.imageio.bias.BiasCorrection;

public class SerialParallelBiasSubtraction
implements BiasCorrection {
    private final int targetBiasLevel = 20000;

    @Override
    public BiasCorrection.CorrectionFactors compute(IntBuffer data, Segment segment) {
        int nAxis1 = segment.getNAxis1();
        int nAxis2 = segment.getNAxis2();
        Rectangle datasec = segment.getDataSec();
        int[] serialBias = new int[datasec.height];
        int averageSerialBias = 0;
        int serialOverscanStart = datasec.x + datasec.width + 4;
        int position = 0;
        for (int y = datasec.y; y < datasec.height + datasec.y; ++y) {
            int biasSum = 0;
            for (int x = serialOverscanStart; x < nAxis1; ++x) {
                biasSum += data.get(position + x);
            }
            serialBias[y - datasec.y] = biasSum /= nAxis1 - serialOverscanStart;
            averageSerialBias += biasSum;
            position += nAxis1;
        }
        averageSerialBias /= datasec.height;
        int i = 0;
        while (i < serialBias.length) {
            int n = i++;
            serialBias[n] = serialBias[n] - 20000;
        }
        int[] parallelBias = new int[datasec.width];
        int minParallelBias = 999999;
        int parallelOverscanStart = datasec.y + datasec.height + 4;
        for (int x = datasec.x; x < datasec.width + datasec.x; ++x) {
            int biasSum = 0;
            for (int y = parallelOverscanStart; y < nAxis2; ++y) {
                biasSum += data.get(x + y * nAxis1);
            }
            parallelBias[x - datasec.x] = biasSum /= nAxis2 - parallelOverscanStart;
            minParallelBias = Math.min(minParallelBias, biasSum);
            position += nAxis1;
        }
        int i2 = 0;
        while (i2 < parallelBias.length) {
            int n = i2++;
            parallelBias[n] = parallelBias[n] - minParallelBias;
        }
        return new SimpleCorrectionFactors(datasec, serialBias, parallelBias);
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return SerialParallelBiasSubtraction.class.hashCode();
    }

    public static void main(String[] args) throws IOException, TruncatedFileException, FitsException {
        File file = new File("/home/tonyj/Data/pretty/11_Flat_screen_0000_20190322172301.fits");
        BufferedFile bf = new BufferedFile(file, "r");
        Header header = new Header((ArrayDataInput)bf);
        header = new Header((ArrayDataInput)bf);
        Segment segment = new Segment(header, file, bf, "R22", "S11", 'Q', null);
        IntBuffer intBuffer = (IntBuffer)segment.readRawDataAsync(null).join().getBuffer();
        SerialParallelBiasSubtraction bc = new SerialParallelBiasSubtraction();
        BiasCorrection.CorrectionFactors factors = bc.compute(intBuffer, segment);
        System.out.println(factors);
    }

    public static class SimpleCorrectionFactors
    implements BiasCorrection.CorrectionFactors {
        private final Rectangle datasec;
        private final int[] serialBias;
        private final int[] parallelBias;

        private SimpleCorrectionFactors(Rectangle datasec, int[] serialBias, int[] parallelBias) {
            this.datasec = datasec;
            this.serialBias = serialBias;
            this.parallelBias = parallelBias;
        }

        @Override
        public int correctionFactor(int x, int y) {
            return this.serialBias[y - this.datasec.y] + this.parallelBias[x - this.datasec.x];
        }

        public String toString() {
            return "CorrectionFactors{datasec=" + this.datasec + ", serialBias=" + Arrays.toString(this.serialBias) + ", parallelBias=" + Arrays.toString(this.parallelBias) + "}";
        }
    }
}

